/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import nxt.BlockchainTest;
import nxt.addons.JO;
import nxt.http.callers.CombineSecretCall;
import nxt.http.callers.SendMoneyCall;
import nxt.http.callers.SplitSecretCall;
import nxt.util.Logger;
import org.junit.Assert;
import org.junit.Test;

public class SecretSharingApiTest
extends BlockchainTest {
    @Test
    public void useApis2of3() {
        JO jO = ((SplitSecretCall)SplitSecretCall.create().secretPhrase(ALICE.getSecretPhrase())).totalPieces(3).minimumPieces(2).call();
        List list = jO.getArray("pieces").values();
        JO jO2 = CombineSecretCall.create().pieces(new String[]{(String)list.get(0), (String)list.get(1)}).call();
        Assert.assertEquals((Object)ALICE.getSecretPhrase(), (Object)jO2.getString("secretPhrase"));
        jO2 = CombineSecretCall.create().pieces(new String[]{(String)list.get(0), (String)list.get(2)}).call();
        Assert.assertEquals((Object)ALICE.getSecretPhrase(), (Object)jO2.getString("secretPhrase"));
        jO2 = CombineSecretCall.create().pieces(new String[]{(String)list.get(1), (String)list.get(2)}).call();
        Assert.assertEquals((Object)ALICE.getSecretPhrase(), (Object)jO2.getString("secretPhrase"));
    }

    @Test
    public void useApis3of5() {
        JO jO = ((SplitSecretCall)SplitSecretCall.create().secretPhrase(CHUCK.getSecretPhrase())).totalPieces(5).minimumPieces(3).call();
        List list = jO.getArray("pieces").values();
        Logger.logInfoMessage((String)list.toString());
        JO jO2 = CombineSecretCall.create().pieces(new String[]{(String)list.get(1), (String)list.get(3), (String)list.get(4)}).call();
        Assert.assertEquals((Object)CHUCK.getSecretPhrase(), (Object)jO2.getString("secretPhrase"));
    }

    @Test
    public void missingPieces() {
        JO jO = ((SplitSecretCall)SplitSecretCall.create().secretPhrase(ALICE.getSecretPhrase())).totalPieces(3).minimumPieces(2).call();
        List list = jO.getArray("pieces").values();
        JO jO2 = CombineSecretCall.create().pieces(new String[]{(String)list.get(0)}).call();
        Assert.assertNotEquals((Object)ALICE.getSecretPhrase(), (Object)jO2.getString("secretPhrase"));
    }

    @Test
    public void wrongPieces() {
        JO jO = ((SplitSecretCall)SplitSecretCall.create().secretPhrase(CHUCK.getSecretPhrase())).totalPieces(3).minimumPieces(2).call();
        List list = jO.getArray("pieces").values();
        JO jO2 = CombineSecretCall.create().pieces(new String[]{(String)list.get(0), (String)list.get(1)}).call();
        Assert.assertEquals((Object)CHUCK.getSecretPhrase(), (Object)jO2.getString("secretPhrase"));
        jO2 = CombineSecretCall.create().pieces(new String[]{(String)list.get(0) + "AB", (String)list.get(1)}).call();
        Assert.assertNotEquals((Object)CHUCK.getSecretPhrase(), (Object)jO2.getString("secretPhrase"));
    }

    @Test
    public void submitSecretPhrasePiece() {
        JO jO = ((SendMoneyCall)((SendMoneyCall)((SendMoneyCall)((SendMoneyCall)SendMoneyCall.create((int)2).recipient(BlockchainTest.BOB.getRsAccount())).amountNQT(123456789L).feeNQT(1000000L)).sharedPiece(new String[]{"1:9999:3:2:0:3:626cef7a2bfe67d3ecc2168c32e8a460db5c2c71adaed3b9"})).sharedPieceAccount(ALICE.getRsAccount())).call();
        Assert.assertEquals((Object)"true", (Object)jO.getString("broadcasted"));
    }

    @Test
    public void submitMultipleSecretPhrasePiece() {
        JO jO = ((SendMoneyCall)((SendMoneyCall)((SendMoneyCall)((SendMoneyCall)SendMoneyCall.create((int)2).recipient(BlockchainTest.BOB.getRsAccount())).amountNQT(123456789L).feeNQT(1000000L)).sharedPiece(new String[]{"0:-1797511508:5:3:0:1:00994e4109d68fba8ed92c1b65b7c50963d4480f623de5d5d1f230eb199ac37c088f3bc3", "0:-1797511508:5:3:0:2:01135524eff764421052eb34520b6f009588ad5bb3f707443dacccab51b430283513ee4a", "0:-1797511508:5:3:0:5:042599fb5a1d4876b15b8e1705864273d5395e7f05f3e2bd163c5a2b4cf34adade2c0e33"})).sharedPieceAccount(CHUCK.getRsAccount())).call();
        Assert.assertEquals((Object)"true", (Object)jO.getString("broadcasted"));
    }
}

