/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import nxt.BlockchainTest;
import nxt.blockchain.FxtChain;
import nxt.http.APICall;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class SendMoneyTest
extends BlockchainTest {
    @Test
    public void sendMoney() {
        JSONObject jSONObject = new APICall.Builder("sendMoney").param("chain", "" + FxtChain.FXT.getId()).param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).param("amountNQT", 100L * FxtChain.FXT.ONE_COIN).param("feeNQT", FxtChain.FXT.ONE_COIN * 10L).build().invoke();
        Logger.logDebugMessage((String)("sendMoney: " + jSONObject));
        Assert.assertEquals((long)0L, (long)FORGY.getFxtBalanceDiff());
        Assert.assertEquals((long)0L, (long)FORGY.getFxtUnconfirmedBalanceDiff());
        Assert.assertEquals((long)0L, (long)ALICE.getFxtBalanceDiff());
        Assert.assertEquals((long)(-100L * FxtChain.FXT.ONE_COIN - 10L * FxtChain.FXT.ONE_COIN), (long)ALICE.getFxtUnconfirmedBalanceDiff());
        Assert.assertEquals((long)0L, (long)BOB.getFxtBalanceDiff());
        Assert.assertEquals((long)0L, (long)BOB.getFxtUnconfirmedBalanceDiff());
        SendMoneyTest.generateBlock();
        Assert.assertEquals((long)(10L * FxtChain.FXT.ONE_COIN), (long)FORGY.getFxtBalanceDiff());
        Assert.assertEquals((long)(10L * FxtChain.FXT.ONE_COIN), (long)FORGY.getFxtUnconfirmedBalanceDiff());
        Assert.assertEquals((long)(-100L * FxtChain.FXT.ONE_COIN - 10L * FxtChain.FXT.ONE_COIN), (long)ALICE.getFxtBalanceDiff());
        Assert.assertEquals((long)(-100L * FxtChain.FXT.ONE_COIN - 10L * FxtChain.FXT.ONE_COIN), (long)ALICE.getFxtUnconfirmedBalanceDiff());
        Assert.assertEquals((long)(100L * FxtChain.FXT.ONE_COIN), (long)BOB.getFxtBalanceDiff());
        Assert.assertEquals((long)(100L * FxtChain.FXT.ONE_COIN), (long)BOB.getFxtUnconfirmedBalanceDiff());
    }

    @Test
    public void sendTooMuchMoney() {
        JSONObject jSONObject = new APICall.Builder("sendMoney").param("chain", "" + FxtChain.FXT.getId()).param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).param("amountNQT", ALICE.getInitialFxtBalance()).param("feeNQT", 10L * FxtChain.FXT.ONE_COIN).build().invoke();
        Logger.logDebugMessage((String)("sendMoney: " + jSONObject));
        Assert.assertEquals((Object)6L, (Object)jSONObject.get((Object)"errorCode"));
    }

    @Test
    public void sendAndReturn() {
        JSONObject jSONObject = new APICall.Builder("sendMoney").param("chain", "" + FxtChain.FXT.getId()).param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).param("amountNQT", 100L * FxtChain.FXT.ONE_COIN).param("feeNQT", 10L * FxtChain.FXT.ONE_COIN).build().invoke();
        Logger.logDebugMessage((String)("sendMoney1: " + jSONObject));
        jSONObject = new APICall.Builder("sendMoney").param("chain", "" + FxtChain.FXT.getId()).param("secretPhrase", BOB.getSecretPhrase()).param("recipient", ALICE.getStrId()).param("amountNQT", 100L * FxtChain.FXT.ONE_COIN).param("feeNQT", 10L * FxtChain.FXT.ONE_COIN).build().invoke();
        Logger.logDebugMessage((String)("sendMoney2: " + jSONObject));
        Assert.assertEquals((long)0L, (long)FORGY.getFxtBalanceDiff());
        Assert.assertEquals((long)0L, (long)FORGY.getFxtUnconfirmedBalanceDiff());
        Assert.assertEquals((long)0L, (long)ALICE.getFxtBalanceDiff());
        Assert.assertEquals((long)(-100L * FxtChain.FXT.ONE_COIN - 10L * FxtChain.FXT.ONE_COIN), (long)ALICE.getFxtUnconfirmedBalanceDiff());
        Assert.assertEquals((long)0L, (long)BOB.getFxtBalanceDiff());
        Assert.assertEquals((long)(-100L * FxtChain.FXT.ONE_COIN - 10L * FxtChain.FXT.ONE_COIN), (long)BOB.getFxtUnconfirmedBalanceDiff());
        SendMoneyTest.generateBlock();
        Assert.assertEquals((long)(20L * FxtChain.FXT.ONE_COIN), (long)FORGY.getFxtBalanceDiff());
        Assert.assertEquals((long)(20L * FxtChain.FXT.ONE_COIN), (long)FORGY.getFxtUnconfirmedBalanceDiff());
        Assert.assertEquals((long)(-10L * FxtChain.FXT.ONE_COIN), (long)ALICE.getFxtBalanceDiff());
        Assert.assertEquals((long)(-10L * FxtChain.FXT.ONE_COIN), (long)ALICE.getFxtUnconfirmedBalanceDiff());
        Assert.assertEquals((long)(-10L * FxtChain.FXT.ONE_COIN), (long)BOB.getFxtBalanceDiff());
        Assert.assertEquals((long)(-10L * FxtChain.FXT.ONE_COIN), (long)BOB.getFxtUnconfirmedBalanceDiff());
    }

    @Test
    public void signAndBroadcastBytes() {
        JSONObject jSONObject = new APICall.Builder("sendMoney").param("chain", "" + FxtChain.FXT.getId()).param("publicKey", ALICE.getPublicKeyStr()).param("recipient", BOB.getStrId()).param("amountNQT", 100L * FxtChain.FXT.ONE_COIN).param("feeNQT", 10L * FxtChain.FXT.ONE_COIN).build().invoke();
        Logger.logDebugMessage((String)("sendMoney: " + jSONObject));
        SendMoneyTest.generateBlock();
        Assert.assertEquals((long)0L, (long)ALICE.getFxtBalanceDiff());
        Assert.assertEquals((long)0L, (long)ALICE.getFxtUnconfirmedBalanceDiff());
        Assert.assertEquals((long)0L, (long)BOB.getFxtBalanceDiff());
        Assert.assertEquals((long)0L, (long)BOB.getFxtUnconfirmedBalanceDiff());
        jSONObject = new APICall.Builder("signTransaction").param("secretPhrase", ALICE.getSecretPhrase()).param("unsignedTransactionBytes", (String)jSONObject.get((Object)"unsignedTransactionBytes")).build().invoke();
        Logger.logDebugMessage((String)("signTransaction: " + jSONObject));
        jSONObject = new APICall.Builder("broadcastTransaction").param("transactionBytes", (String)jSONObject.get((Object)"transactionBytes")).build().invoke();
        Logger.logDebugMessage((String)("broadcastTransaction: " + jSONObject));
        SendMoneyTest.generateBlock();
        Assert.assertEquals((long)(-100L * FxtChain.FXT.ONE_COIN - 10L * FxtChain.FXT.ONE_COIN), (long)ALICE.getFxtBalanceDiff());
        Assert.assertEquals((long)(-100L * FxtChain.FXT.ONE_COIN - 10L * FxtChain.FXT.ONE_COIN), (long)ALICE.getFxtUnconfirmedBalanceDiff());
        Assert.assertEquals((long)(100L * FxtChain.FXT.ONE_COIN), (long)BOB.getFxtBalanceDiff());
        Assert.assertEquals((long)(100L * FxtChain.FXT.ONE_COIN), (long)BOB.getFxtUnconfirmedBalanceDiff());
    }

    @Test
    public void signAndBroadcastJSON() {
        JSONObject jSONObject = new APICall.Builder("sendMoney").param("chain", "" + FxtChain.FXT.getId()).param("publicKey", ALICE.getPublicKeyStr()).param("recipient", BOB.getStrId()).param("amountNQT", 100L * FxtChain.FXT.ONE_COIN).param("feeNQT", 10L * FxtChain.FXT.ONE_COIN).build().invoke();
        Logger.logDebugMessage((String)("sendMoney: " + jSONObject));
        SendMoneyTest.generateBlock();
        Assert.assertEquals((long)0L, (long)ALICE.getFxtBalanceDiff());
        Assert.assertEquals((long)0L, (long)ALICE.getFxtUnconfirmedBalanceDiff());
        Assert.assertEquals((long)0L, (long)BOB.getFxtBalanceDiff());
        Assert.assertEquals((long)0L, (long)BOB.getFxtUnconfirmedBalanceDiff());
        jSONObject = new APICall.Builder("signTransaction").param("secretPhrase", ALICE.getSecretPhrase()).param("unsignedTransactionJSON", jSONObject.get((Object)"transactionJSON").toString()).build().invoke();
        Logger.logDebugMessage((String)("signTransaction: " + jSONObject));
        jSONObject = new APICall.Builder("broadcastTransaction").param("transactionBytes", (String)jSONObject.get((Object)"transactionBytes")).build().invoke();
        Logger.logDebugMessage((String)("broadcastTransaction: " + jSONObject));
        SendMoneyTest.generateBlock();
        Assert.assertEquals((long)(-100L * FxtChain.FXT.ONE_COIN - 10L * FxtChain.FXT.ONE_COIN), (long)ALICE.getFxtBalanceDiff());
        Assert.assertEquals((long)(-100L * FxtChain.FXT.ONE_COIN - 10L * FxtChain.FXT.ONE_COIN), (long)ALICE.getFxtUnconfirmedBalanceDiff());
        Assert.assertEquals((long)(100L * FxtChain.FXT.ONE_COIN), (long)BOB.getFxtBalanceDiff());
        Assert.assertEquals((long)(100L * FxtChain.FXT.ONE_COIN), (long)BOB.getFxtUnconfirmedBalanceDiff());
    }
}

