/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.accountControl;

import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.crypto.HashFunction;
import nxt.http.APICall;
import nxt.http.accountControl.ACTestUtils;
import nxt.util.JSONAssert;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class CompositePhasingOnlyTest
extends BlockchainTest {
    @Test
    public void testSetAndGet() throws Exception {
        ACTestUtils.assertNoPhasingOnlyControl();
        this.setSimpleCompositeControl("A", BOB);
        APICall.Builder builder = new APICall.Builder("getPhasingOnlyControl").param("account", Long.toUnsignedString(ALICE.getId()));
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        jSONAssert.subObj("controlParams").subObj("phasingSubPolls").subObj("A");
    }

    @Test
    public void testUpdateCompositeControl() throws Exception {
        ACTestUtils.assertNoPhasingOnlyControl();
        this.setSimpleCompositeControl("A", BOB);
        APICall.Builder builder = new APICall.Builder("getPhasingOnlyControl").param("account", Long.toUnsignedString(ALICE.getId()));
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        JSONAssert jSONAssert2 = jSONAssert.subObj("controlParams").subObj("phasingSubPolls");
        jSONAssert2.subObj("A");
        Assert.assertEquals((long)1L, (long)jSONAssert2.getJson().size());
        ACTestUtils.PhasingBuilder phasingBuilder = this.createCompositeBuilder();
        phasingBuilder.feeNQT(3L * ChildChain.IGNIS.ONE_COIN).param("controlExpression", "B");
        phasingBuilder.startSubPoll("B").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(CHUCK);
        phasingBuilder.startPhasingParams().votingModel(VoteWeighting.VotingModel.COMPOSITE).param("phasingExpression", "A").param("phasingQuorum", 1);
        phasingBuilder.startSubPoll("A").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(BOB);
        jSONAssert = new JSONAssert(phasingBuilder.build().invoke());
        jSONAssert.str("fullHash");
        jSONAssert.subObj("transactionJSON").subObj("attachment").subObj("phasingControlParams").subObj("phasingSubPolls").subObj("B");
        CompositePhasingOnlyTest.generateBlock();
        this.approveUpdate(jSONAssert);
        jSONAssert = new JSONAssert(builder.build().invoke());
        jSONAssert2 = jSONAssert.subObj("controlParams").subObj("phasingSubPolls");
        jSONAssert2.subObj("B");
        Assert.assertEquals((long)1L, (long)jSONAssert2.getJson().size());
    }

    @Test
    public void testRemoveCompositeControl() throws Exception {
        this.setSimpleCompositeControl("RemoveTest", BOB);
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder(ALICE);
        phasingBuilder.feeNQT(3L * ChildChain.IGNIS.ONE_COIN);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.NONE);
        phasingBuilder.startPhasingParams().votingModel(VoteWeighting.VotingModel.COMPOSITE).param("phasingExpression", "RemoveTest").param("phasingQuorum", 1);
        phasingBuilder.startSubPoll("RemoveTest").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(BOB);
        JSONAssert jSONAssert = new JSONAssert(phasingBuilder.build().invoke());
        CompositePhasingOnlyTest.generateBlock();
        this.approveUpdate(jSONAssert);
        int n = Nxt.getBlockchain().getHeight();
        APICall.Builder builder = new APICall.Builder("getPhasingOnlyControl").param("account", Long.toUnsignedString(ALICE.getId()));
        JSONObject jSONObject = builder.build().invoke();
        Assert.assertEquals((long)0L, (long)jSONObject.size());
        String string = "RmTest2";
        this.setSimpleCompositeControl(string, BOB);
        jSONAssert = new JSONAssert(builder.build().invoke());
        JSONAssert jSONAssert2 = jSONAssert.subObj("controlParams").subObj("phasingSubPolls");
        jSONAssert2.subObj(string);
        Assert.assertEquals((long)1L, (long)jSONAssert2.getJson().size());
        Nxt.getBlockchainProcessor().popOffTo(n);
        jSONObject = builder.build().invoke();
        Assert.assertEquals((long)0L, (long)jSONObject.size());
        this.setSimpleCompositeControl(string, BOB);
        jSONAssert = new JSONAssert(builder.build().invoke());
        jSONAssert2 = jSONAssert.subObj("controlParams").subObj("phasingSubPolls");
        jSONAssert2.subObj(string);
        Assert.assertEquals((long)1L, (long)jSONAssert2.getJson().size());
    }

    @Test
    public void testSubParamsEqualCheck() {
        ACTestUtils.PhasingBuilder phasingBuilder = this.createCompositeBuilder();
        phasingBuilder.param("controlExpression", "A & B");
        phasingBuilder.startSubPoll("A").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(BOB);
        phasingBuilder.startSubPoll("B").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(CHUCK, DAVE);
        phasingBuilder.build().invoke();
        CompositePhasingOnlyTest.generateBlock();
        phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        phasingBuilder.param("recipient", BOB.getStrId()).param("amountNQT", 100L * ChildChain.IGNIS.ONE_COIN);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.COMPOSITE).param("phasingExpression", "A & B").param("phasingQuorum", 1);
        phasingBuilder.startSubPoll("A").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(BOB);
        phasingBuilder.startSubPoll("B").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(CHUCK);
        JSONAssert jSONAssert = new JSONAssert(phasingBuilder.build().invoke());
        Assert.assertTrue((boolean)jSONAssert.str("errorDescription").startsWith("Sub-poll for variable \"B\" does not match"));
        phasingBuilder.startSubPoll("B").whitelist(CHUCK, DAVE).quorum(2);
        jSONAssert = new JSONAssert(phasingBuilder.build().invoke());
        Assert.assertTrue((boolean)jSONAssert.str("errorDescription").startsWith("Sub-poll for variable \"B\" does not match"));
        phasingBuilder.startSubPoll("B").quorum(1);
        jSONAssert = new JSONAssert(phasingBuilder.build().invoke());
        jSONAssert.str("fullHash");
        CompositePhasingOnlyTest.generateBlock();
    }

    @Test
    public void testCompositeControlImplication() {
        ACTestUtils.PhasingBuilder phasingBuilder = this.createCompositeBuilder();
        phasingBuilder.param("controlExpression", "A & B");
        phasingBuilder.startSubPoll("A").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(BOB);
        phasingBuilder.startSubPoll("B").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(CHUCK, DAVE);
        phasingBuilder.build().invoke();
        CompositePhasingOnlyTest.generateBlock();
        ACTestUtils.PhasingBuilder phasingBuilder2 = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        phasingBuilder2.param("recipient", BOB.getStrId()).param("amountNQT", 100L * ChildChain.IGNIS.ONE_COIN);
        phasingBuilder2.votingModel(VoteWeighting.VotingModel.COMPOSITE).param("phasingExpression", "A").param("phasingQuorum", 1);
        phasingBuilder2.startSubPoll("A").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(BOB);
        JSONAssert jSONAssert = new JSONAssert(phasingBuilder2.build().invoke());
        Assert.assertTrue((boolean)jSONAssert.str("errorDescription").startsWith("Phasing expression does not imply the account control expression"));
        phasingBuilder2.param("phasingExpression", "A & B | C");
        phasingBuilder2.startSubPoll("B").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(CHUCK, DAVE);
        phasingBuilder2.startSubPoll("C").votingModel(VoteWeighting.VotingModel.HASH).quorum(1).hashedSecret("somesecret", HashFunction.SHA256);
        jSONAssert = new JSONAssert(phasingBuilder2.build().invoke());
        Assert.assertTrue((boolean)jSONAssert.str("errorDescription").startsWith("Phasing expression does not imply the account control expression"));
        phasingBuilder2.param("phasingExpression", "A & B & C");
        jSONAssert = new JSONAssert(phasingBuilder2.build().invoke());
        jSONAssert.str("fullHash");
    }

    @Test
    public void testSimpleControl() {
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder(ALICE);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(BOB, CHUCK).quorum(1);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        CompositePhasingOnlyTest.generateBlock();
        ACTestUtils.PhasingBuilder phasingBuilder2 = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        phasingBuilder2.param("recipient", DAVE.getStrId()).param("amountNQT", 100L * ChildChain.IGNIS.ONE_COIN);
        phasingBuilder2.votingModel(VoteWeighting.VotingModel.COMPOSITE).param("phasingExpression", "ACC").param("phasingQuorum", 1);
        phasingBuilder2.startSubPoll("ACC").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(2).whitelist(BOB, CHUCK);
        JSONAssert jSONAssert = new JSONAssert(phasingBuilder2.build().invoke());
        Assert.assertTrue((boolean)jSONAssert.str("errorDescription").startsWith("Sub-poll for variable \"ACC\" does not match"));
        phasingBuilder2.param("phasingExpression", "ACC | B");
        phasingBuilder2.startSubPoll("ACC").quorum(1);
        phasingBuilder2.startSubPoll("B").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(DAVE);
        jSONAssert = new JSONAssert(phasingBuilder2.build().invoke());
        Assert.assertTrue((boolean)jSONAssert.str("errorDescription").startsWith("Phasing expression does not imply the account control expression"));
        phasingBuilder2.param("phasingExpression", "ACC & B");
        jSONAssert = new JSONAssert(phasingBuilder2.build().invoke());
        jSONAssert.str("fullHash");
    }

    @Test
    public void testPropertyVoting() {
        ACTestUtils.PhasingBuilder phasingBuilder = this.createCompositeBuilder();
        phasingBuilder.param("controlExpression", "A & B");
        String string = "propac2";
        String string2 = "valX";
        phasingBuilder.startSubPoll("A").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(BOB);
        phasingBuilder.startSubPoll("B").votingModel(VoteWeighting.VotingModel.PROPERTY).quorum(1);
        phasingBuilder.phasingParam("SenderPropertySetter", CHUCK.getStrId());
        phasingBuilder.phasingParam("SenderPropertyName", string);
        phasingBuilder.phasingParam("SenderPropertyValue", string2);
        JSONAssert jSONAssert = new JSONAssert(phasingBuilder.build().invoke());
        jSONAssert.str("fullHash");
        CompositePhasingOnlyTest.generateBlock();
        ACTestUtils.PhasingBuilder phasingBuilder2 = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        phasingBuilder2.param("recipient", DAVE.getStrId()).param("amountNQT", 100L * ChildChain.IGNIS.ONE_COIN);
        phasingBuilder2.votingModel(VoteWeighting.VotingModel.COMPOSITE).param("phasingExpression", "A & B").param("phasingQuorum", 1);
        phasingBuilder2.startSubPoll("A").votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(BOB);
        phasingBuilder2.startSubPoll("B").votingModel(VoteWeighting.VotingModel.PROPERTY).quorum(1);
        phasingBuilder2.phasingParam("SenderPropertySetter", CHUCK.getStrId());
        phasingBuilder2.phasingParam("SenderPropertyName", string);
        phasingBuilder2.phasingParam("SenderPropertyValue", string2 + "a");
        jSONAssert = new JSONAssert(phasingBuilder2.build().invoke());
        Assert.assertTrue((boolean)jSONAssert.str("errorDescription").startsWith("Sub-poll for variable \"B\" does not match"));
        phasingBuilder2.phasingParam("SenderPropertyValue", string2);
        jSONAssert = new JSONAssert(phasingBuilder2.build().invoke());
        jSONAssert.str("fullHash");
    }

    private ACTestUtils.PhasingBuilder createCompositeBuilder() {
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder(ALICE);
        ACTestUtils.setControlPhasingParams(phasingBuilder, VoteWeighting.VotingModel.COMPOSITE, null, 1L, null, null, null, 10L * ChildChain.IGNIS.ONE_COIN, 5, 1440);
        return phasingBuilder;
    }

    private ACTestUtils.PhasingBuilder setSimpleCompositeControl(String string, Tester tester) {
        ACTestUtils.PhasingBuilder phasingBuilder = this.createCompositeBuilder();
        phasingBuilder.param("controlExpression", string);
        phasingBuilder.startSubPoll(string).votingModel(VoteWeighting.VotingModel.ACCOUNT).quorum(1).whitelist(tester);
        JSONAssert jSONAssert = new JSONAssert(phasingBuilder.build().invoke());
        jSONAssert.str("fullHash");
        jSONAssert.subObj("transactionJSON").subObj("attachment").subObj("phasingControlParams").subObj("phasingSubPolls").subObj(string);
        CompositePhasingOnlyTest.generateBlock();
        return phasingBuilder;
    }

    private void approveUpdate(JSONAssert jSONAssert) {
        APICall.Builder builder = new ACTestUtils.Builder("approveTransaction", BOB.getSecretPhrase()).param("phasedTransaction", "" + jSONAssert.subObj("transactionJSON").integer("chain") + ":" + jSONAssert.str("fullHash"));
        jSONAssert = new JSONAssert(builder.build().invoke());
        jSONAssert.str("fullHash");
        CompositePhasingOnlyTest.generateBlock();
    }
}

