/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.assetexchange;

import java.math.BigDecimal;
import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.account.HoldingType;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.accountControl.ACTestUtils;
import nxt.http.assetexchange.AssetExchangeTest;
import nxt.http.client.TransferAssetBuilder;
import nxt.http.twophased.TestPropertyVoting;
import nxt.util.JSONAssert;
import nxt.voting.VoteWeighting;
import org.junit.Assert;
import org.junit.Test;

public class AssetControlTest
extends BlockchainTest {
    @Test
    public void testSetAndGet() {
        String string = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetIdString();
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("setPhasingAssetControl", BOB);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(CHUCK).quorum(1);
        phasingBuilder.param("asset", string);
        JSONAssert jSONAssert = new JSONAssert(phasingBuilder.build().invoke());
        Assert.assertEquals((Object)"Asset control can only be set by the asset issuer", (Object)jSONAssert.str("errorDescription"));
        phasingBuilder.secretPhrase(ALICE.getSecretPhrase());
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        APICall.Builder builder = new APICall.Builder("getPhasingAssetControl").param("asset", string);
        JSONAssert jSONAssert2 = new JSONAssert(builder.build().invoke()).subObj("controlParams");
        Assert.assertEquals((long)VoteWeighting.VotingModel.ACCOUNT.getCode(), (long)Long.valueOf(jSONAssert2.integer("phasingVotingModel")).byteValue());
    }

    @Test
    public void testSimpleTransfer() {
        String string = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetIdString();
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("setPhasingAssetControl", ALICE);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(CHUCK).quorum(1);
        phasingBuilder.param("asset", string);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        int n = 1000000;
        String string2 = new TransferAssetBuilder(string, ALICE, BOB).setQuantityQNT(n).transferWithError().getErrorDescription();
        Assert.assertEquals((Object)"Non-phased transaction when phasing asset control is enabled", (Object)string2);
        APICall aPICall = new ACTestUtils.PhasingBuilder("transferAsset", ALICE).votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(CHUCK).quorum(1).param("recipient", BOB.getRsAccount()).param("asset", string).param("quantityQNT", n).build();
        String string3 = new JSONAssert(aPICall.invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        ACTestUtils.approve(string3, CHUCK, null);
        AssetControlTest.generateBlocks(4);
        Assert.assertEquals((long)n, (long)BOB.getAssetQuantityDiff(Long.parseUnsignedLong(string)));
    }

    @Test
    public void testSimpleAssetAndAccountControl() {
        String string = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetIdString();
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("setPhasingAssetControl", ALICE);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(CHUCK).quorum(1);
        phasingBuilder.param("asset", string);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        phasingBuilder = new ACTestUtils.PhasingBuilder(ALICE);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(DAVE).quorum(1);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        int n = 1000000;
        APICall aPICall = new ACTestUtils.PhasingBuilder("transferAsset", ALICE).votingModel(VoteWeighting.VotingModel.COMPOSITE).phasingParam("Expression", "ACC & ASC").quorum(1).startSubPoll("ASC").votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(CHUCK).quorum(1).startSubPoll("ACC").votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(DAVE).quorum(1).param("recipient", BOB.getRsAccount()).param("asset", string).param("quantityQNT", n).feeNQT(ChildChain.IGNIS.ONE_COIN * 5L).build();
        String string2 = new JSONAssert(aPICall.invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        ACTestUtils.approve(string2, CHUCK, null);
        ACTestUtils.approve(string2, DAVE, null);
        AssetControlTest.generateBlocks(4);
        Assert.assertEquals((long)n, (long)BOB.getAssetQuantityDiff(Long.parseUnsignedLong(string)));
    }

    @Test
    public void testAssetControlByProperty() {
        String string = "propac2";
        String string2 = "valX";
        String string3 = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetIdString();
        ACTestUtils.PhasingBuilder phasingBuilder = this.createByPropertyPhasingBuilder(string, string2, string3);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, string, string2).build().invokeNoError();
        TestPropertyVoting.createSetPropertyBuilder(CHUCK, BOB, string, string2).build().invokeNoError();
        AssetControlTest.generateBlock();
        int n = 1000000;
        ACTestUtils.PhasingBuilder phasingBuilder2 = new ACTestUtils.PhasingBuilder("transferAsset", ALICE).votingModel(VoteWeighting.VotingModel.PROPERTY).quorum(1).phasingParam("SenderPropertySetter", CHUCK.getStrId()).phasingParam("SenderPropertyName", string).phasingParam("SenderPropertyValue", string2);
        phasingBuilder2.param("recipient", BOB.getRsAccount()).param("asset", string3).param("quantityQNT", n);
        Assert.assertTrue((boolean)new JSONAssert(phasingBuilder2.build().invoke()).str("errorDescription").startsWith("Phasing parameters do not match phasing asset control."));
        phasingBuilder2.phasingParam("RecipientPropertySetter", CHUCK.getStrId()).phasingParam("RecipientPropertyName", string).phasingParam("RecipientPropertyValue", string2);
        new JSONAssert(phasingBuilder2.build().invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        Assert.assertEquals((long)n, (long)BOB.getAssetQuantityDiff(Long.parseUnsignedLong(string3)));
    }

    @Test
    public void testDividendPaymentOnControlledAsset() {
        String string = "propac2";
        String string2 = "valX";
        String string3 = "valY";
        String string4 = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetIdString();
        ACTestUtils.PhasingBuilder phasingBuilder = this.createByPropertyPhasingBuilder(string, string2, string4);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        String string5 = AssetExchangeTest.issueAsset(ALICE, "AssetD").getAssetIdString();
        APICall.Builder builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, string, string2);
        builder.build().invoke();
        builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, BOB, string, string2);
        builder.build().invoke();
        AssetControlTest.generateBlock();
        int n = 1000000;
        ACTestUtils.PhasingBuilder phasingBuilder2 = new ACTestUtils.PhasingBuilder("transferAsset", ALICE);
        phasingBuilder2.param("recipient", BOB.getRsAccount()).param("asset", string4).param("quantityQNT", n);
        this.setupByPropertyPhasing(string, string2, phasingBuilder2);
        new JSONAssert(phasingBuilder2.build().invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        Assert.assertEquals((long)n, (long)BOB.getAssetQuantityDiff(Long.parseUnsignedLong(string4)));
        builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, string, string3);
        builder.build().invoke();
        builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, BOB, string, string3);
        builder.build().invoke();
        new JSONAssert(AssetExchangeTest.payDividend(string4, ALICE, Nxt.getBlockchain().getHeight(), 1L, (Chain)ChildChain.IGNIS, HoldingType.ASSET.getCode(), string5)).str("fullHash");
        Assert.assertEquals((long)BigDecimal.valueOf(n, 4).longValue(), (long)BOB.getAssetQuantityDiff(Long.parseUnsignedLong(string5)));
        string5 = AssetExchangeTest.issueAsset(ALICE, "AssetE").getAssetIdString();
        phasingBuilder = this.createByPropertyPhasingBuilder(string, string2, string5);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        AssetControlTest.generateBlocks(10);
        JSONAssert jSONAssert = new JSONAssert(AssetExchangeTest.payDividend(string4, ALICE, Nxt.getBlockchain().getHeight(), 1L, (Chain)ChildChain.IGNIS, HoldingType.ASSET.getCode(), string5));
        Assert.assertEquals((Object)"Non-phased transaction when phasing asset control is enabled", (Object)jSONAssert.str("errorDescription"));
        builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, string, string2);
        builder.build().invoke();
        phasingBuilder2 = new ACTestUtils.PhasingBuilder("dividendPayment", ALICE);
        this.setupByPropertyPhasing(string, string2, phasingBuilder2);
        phasingBuilder2.param("asset", string4).param("height", Nxt.getBlockchain().getHeight()).param("holdingType", HoldingType.ASSET.getCode()).param("holding", string5).param("amountNQTPerShare", 1);
        Assert.assertEquals((Object)"Dividend payment with asset under by-recipient property control is not supported", (Object)new JSONAssert(phasingBuilder2.build().invoke()).str("errorDescription"));
    }

    @Test
    public void testShufflingOfControlledAsset() {
        String string = "propac2";
        String string2 = "valX";
        String string3 = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetIdString();
        ACTestUtils.PhasingBuilder phasingBuilder = this.createByPropertyPhasingBuilder(string, string2, string3);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        int n = 1000000;
        ACTestUtils.PhasingBuilder phasingBuilder2 = new ACTestUtils.PhasingBuilder("transferAsset", ALICE);
        this.setupByPropertyPhasing(string, string2, phasingBuilder2);
        phasingBuilder2.param("recipient", BOB.getRsAccount()).param("asset", string3).param("quantityQNT", n);
        new JSONAssert(phasingBuilder2.build().invoke()).str("fullHash");
        phasingBuilder2 = new ACTestUtils.PhasingBuilder("shufflingCreate", ALICE);
        this.setupByPropertyPhasing(string, string2, phasingBuilder2);
        phasingBuilder2.param("amount", String.valueOf(10000)).param("holding", string3).param("holdingType", String.valueOf(HoldingType.ASSET.getCode())).param("participantCount", String.valueOf(3)).param("registrationPeriod", 10);
        Assert.assertEquals((Object)"Shuffling of asset under asset control is not supported", (Object)new JSONAssert(phasingBuilder2.build().invoke()).str("errorDescription"));
    }

    @Test
    public void testSetOnDistributedAsset() {
        String string = "propac2";
        String string2 = "valX";
        String string3 = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetIdString();
        AssetExchangeTest.transfer(string3, ALICE, BOB, 100000L).getFullHash();
        ACTestUtils.PhasingBuilder phasingBuilder = this.createByPropertyPhasingBuilder(string, string2, string3);
        Assert.assertEquals((Object)"Adding asset control requires the asset issuer to own all asset units", (Object)new JSONAssert(phasingBuilder.build().invoke()).str("errorDescription"));
    }

    @Test
    public void testRemoveControl() {
        String string = "propac2";
        String string2 = "valX";
        String string3 = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetIdString();
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("setPhasingAssetControl", ALICE).votingModel(VoteWeighting.VotingModel.NONE);
        phasingBuilder.param("asset", string3);
        Assert.assertEquals((Object)"Phasing asset control is not currently enabled", (Object)new JSONAssert(phasingBuilder.build().invoke()).str("errorDescription"));
        this.setupByPropertyPhasing(string, string2, phasingBuilder);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        phasingBuilder = new ACTestUtils.PhasingBuilder("setPhasingAssetControl", ALICE).votingModel(VoteWeighting.VotingModel.NONE);
        phasingBuilder.param("asset", string3);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        AssetControlTest.generateBlock();
        AssetExchangeTest.transfer(string3, ALICE, BOB, 100000L).getFullHash();
    }

    private ACTestUtils.PhasingBuilder createByPropertyPhasingBuilder(String string, String string2, String string3) {
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("setPhasingAssetControl", ALICE);
        this.setupByPropertyPhasing(string, string2, phasingBuilder);
        phasingBuilder.param("asset", string3);
        return phasingBuilder;
    }

    private void setupByPropertyPhasing(String string, String string2, ACTestUtils.PhasingBuilder phasingBuilder) {
        phasingBuilder.votingModel(VoteWeighting.VotingModel.PROPERTY).quorum(1);
        phasingBuilder.phasingParam("SenderPropertySetter", CHUCK.getStrId());
        phasingBuilder.phasingParam("SenderPropertyName", string);
        phasingBuilder.phasingParam("SenderPropertyValue", string2);
        phasingBuilder.phasingParam("RecipientPropertySetter", CHUCK.getStrId());
        phasingBuilder.phasingParam("RecipientPropertyName", string);
        phasingBuilder.phasingParam("RecipientPropertyValue", string2);
    }
}

