/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.bundling;

import java.util.ArrayList;
import java.util.stream.Collectors;
import nxt.Nxt;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.Transaction;
import nxt.http.APICall;
import nxt.http.JSONData;
import nxt.http.bundling.BundlerTest;
import nxt.util.Convert;
import nxt.util.JSONAssert;
import nxt.util.Logger;
import org.junit.Assert;
import org.junit.Test;

public class RulesTest
extends BundlerTest {
    @Test
    public void testTwoRules() {
        long l = ChildChain.IGNIS.ONE_COIN * 10L;
        this.startTwoRulesBundler(l, 0L);
        Assert.assertTrue((boolean)this.bundleTransaction(BOB, 0L));
        long l2 = this.getMinFeeNQT(l);
        Assert.assertFalse((boolean)this.bundleTransaction(ALICE, l2 - 1L));
        Assert.assertTrue((boolean)this.bundleTransaction(ALICE, l2));
        Assert.assertTrue((boolean)this.bundleTransaction(ALICE, l2 * 2L));
    }

    @Test
    public void testRulePriority() {
        long l = ChildChain.IGNIS.ONE_COIN * 10L;
        long l2 = this.getMinFeeNQT(l);
        ArrayList<String> arrayList = new ArrayList<String>(100);
        for (int i = 0; i < 100; ++i) {
            arrayList.add(this.createTransaction(BOB, 0L, null));
            if (i % 2 != 0) continue;
            this.createTransaction(ALICE, l2 * 2L, null);
        }
        this.startTwoRulesBundler(l, 100L);
        RulesTest.generateBlock();
        for (String string : arrayList) {
            JSONAssert jSONAssert = this.getTransaction(string);
            if (!jSONAssert.getJson().containsKey((Object)"height")) {
                Logger.logErrorMessage((String)("missing height: " + jSONAssert.getJson().toJSONString() + " " + arrayList));
                FxtTransaction fxtTransaction = (FxtTransaction)Nxt.getBlockchain().getBlockAtHeight(2).getFxtTransactions().get(0);
                Logger.logErrorMessage((String)("Fxt tx: " + JSONData.transaction((Transaction)fxtTransaction)));
                Logger.logErrorMessage((String)("" + fxtTransaction.getSortedChildTransactions().stream().map(childTransaction -> Convert.toHexString((byte[])childTransaction.getFullHash())).collect(Collectors.toList()).toString()));
            }
            Assert.assertEquals((long)Nxt.getBlockchain().getHeight(), (long)jSONAssert.integer("height"));
        }
    }

    private JSONAssert getTransaction(String string) {
        return new JSONAssert(new APICall.Builder("getTransaction").param("fullHash", string).build().invoke());
    }

    @Test
    public void testProportionalFee() {
        long l = ChildChain.IGNIS.ONE_COIN;
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("startBundler").secretPhrase(BOB.getSecretPhrase()).param("chain", ChildChain.IGNIS.getId()).param("minRateNQTPerFXT", l).param("feeCalculatorName", "PROPORTIONAL_FEE").build().invoke());
        jSONAssert.str("totalFeesLimitFQT");
        long l2 = this.getMinFeeNQT(l);
        int n = 2;
        String string = this.createTransaction(ALICE, l2 * (long)n, null);
        RulesTest.generateBlock();
        jSONAssert = this.getTransaction(string);
        jSONAssert = new JSONAssert(new APICall.Builder("getFxtTransaction").param("transaction", jSONAssert.str("fxtTransaction")).build().invoke());
        long l3 = Convert.parseUnsignedLong((String)jSONAssert.str("feeNQT"));
        Assert.assertEquals((long)(this.getMinFeeFQT() * (long)n), (long)l3);
    }

    @Test
    public void testProportionalFeeZeroRate() {
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("startBundler").secretPhrase(BOB.getSecretPhrase()).param("chain", ChildChain.IGNIS.getId()).param("minRateNQTPerFXT", 0).param("feeCalculatorName", "PROPORTIONAL_FEE").build().invoke());
        Assert.assertTrue((boolean)jSONAssert.str("errorDescription").startsWith("Division by zero"));
    }

    @Test
    public void testAddBundlingRule() {
        long l = ChildChain.IGNIS.ONE_COIN;
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("startBundler").secretPhrase(BOB.getSecretPhrase()).param("chain", ChildChain.IGNIS.getId()).param("minRateNQTPerFXT", l * 2L).param("feeCalculatorName", "PROPORTIONAL_FEE").build().invoke());
        jSONAssert.str("totalFeesLimitFQT");
        long l2 = this.getMinFeeNQT(l);
        Assert.assertFalse((boolean)this.bundleTransaction(ALICE, l2));
        jSONAssert = new JSONAssert(new APICall.Builder("addBundlingRule").secretPhrase(BOB.getSecretPhrase()).param("chain", ChildChain.IGNIS.getId()).param("minRateNQTPerFXT", l).param("feeCalculatorName", "MIN_FEE").build().invoke());
        jSONAssert.str("totalFeesLimitFQT");
        Assert.assertTrue((boolean)this.bundleTransaction(ALICE, l2));
    }
}

