/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.client;

import nxt.Tester;
import nxt.http.APICall;
import nxt.util.JSONAssert;
import org.json.simple.JSONObject;

public class PlaceAssetOrderBuilder {
    private final Tester sender;
    private final long assetId;
    private final long quantityQNT;
    private final long price;
    private long feeNQT;

    public PlaceAssetOrderBuilder(Tester tester, String string, long l, long l2) {
        this(tester, Long.parseUnsignedLong(string), l, l2);
    }

    public PlaceAssetOrderBuilder(Tester tester, long l, long l2, long l3) {
        this.sender = tester;
        this.assetId = l;
        this.quantityQNT = l2;
        this.price = l3;
    }

    public PlaceAssetOrderBuilder setFeeNQT(long l) {
        this.feeNQT = l;
        return this;
    }

    private APICall build(String string) {
        return new APICall.Builder(string).param("secretPhrase", this.sender.getSecretPhrase()).param("asset", Long.toUnsignedString(this.assetId)).param("quantityQNT", this.quantityQNT).param("priceNQTPerShare", this.price).param("feeNQT", this.feeNQT).build();
    }

    private APICall buildBid() {
        return this.build("placeBidOrder");
    }

    private APICall buildAsk() {
        return this.build("placeAskOrder");
    }

    public PlaceOrderResult placeBidOrder() {
        return this.placeSuccess(this.buildBid());
    }

    public PlaceOrderResult placeAskOrder() {
        return this.placeSuccess(this.buildAsk());
    }

    private PlaceOrderResult placeSuccess(APICall aPICall) {
        return new PlaceOrderResult(aPICall.invokeNoError());
    }

    public APICall.InvocationError placeBidOrderWithError() {
        return this.buildBid().invokeWithError();
    }

    public APICall.InvocationError placeAskOrderWithError() {
        return this.buildAsk().invokeWithError();
    }

    public static class PlaceOrderResult {
        private final JSONObject jsonObject;

        PlaceOrderResult(JSONObject jSONObject) {
            this.jsonObject = jSONObject;
        }

        public String getFullHash() {
            return new JSONAssert(this.jsonObject).str("fullHash");
        }
    }
}

