/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.client;

import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.ms.Currency;
import org.json.simple.JSONObject;

public class PublishExchangeOfferBuilder {
    private final Tester account;
    private final Currency currency;
    private long feeNQT;
    private long buyRateNQT;
    private long sellRateNQT;
    private long totalBuyLimit;
    private long totalSellLimit;
    private long initialBuySupply;
    private long initialSellSupply;
    private int expirationHeight;

    public PublishExchangeOfferBuilder(Tester tester, Currency currency) {
        this.feeNQT = ChildChain.IGNIS.ONE_COIN;
        this.buyRateNQT = 1L;
        this.sellRateNQT = 1L;
        this.totalBuyLimit = 0L;
        this.totalSellLimit = 0L;
        this.initialBuySupply = 0L;
        this.initialSellSupply = 0L;
        this.expirationHeight = 0;
        this.account = tester;
        this.currency = currency;
    }

    private APICall build() {
        return new APICall.Builder("publishExchangeOffer").secretPhrase(this.account.getSecretPhrase()).feeNQT(this.feeNQT).param("currency", Long.toUnsignedString(this.currency.getId())).param("buyRateNQTPerUnit", this.buyRateNQT).param("sellRateNQTPerUnit", this.sellRateNQT).param("totalBuyLimitQNT", this.totalBuyLimit).param("totalSellLimitQNT", this.totalSellLimit).param("initialBuySupplyQNT", this.initialBuySupply).param("initialSellSupplyQNT", this.initialSellSupply).param("expirationHeight", this.expirationHeight).build();
    }

    public PublishExchangeOfferBuilder setFeeNQT(long l) {
        this.feeNQT = l;
        return this;
    }

    public PublishExchangeOfferBuilder setBuyRateNQT(long l) {
        this.buyRateNQT = l;
        return this;
    }

    public PublishExchangeOfferBuilder setSellRateNQT(long l) {
        this.sellRateNQT = l;
        return this;
    }

    public PublishExchangeOfferBuilder setTotalBuyLimit(long l) {
        this.totalBuyLimit = l;
        return this;
    }

    public PublishExchangeOfferBuilder setTotalSellLimit(long l) {
        this.totalSellLimit = l;
        return this;
    }

    public PublishExchangeOfferBuilder setInitialBuySupply(long l) {
        this.initialBuySupply = l;
        return this;
    }

    public PublishExchangeOfferBuilder setInitialSellSupply(long l) {
        this.initialSellSupply = l;
        return this;
    }

    public PublishExchangeOfferBuilder setExpirationHeight(int n) {
        this.expirationHeight = n;
        return this;
    }

    public JSONObject invokeNoError() {
        return this.build().invokeNoError();
    }
}

