/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.monetarysystem;

import nxt.BlockchainTest;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.ms.CurrencyType;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestCurrencyIssuance
extends BlockchainTest {
    @Test
    public void issueCurrency() {
        this.issueCurrencyImpl();
    }

    @Test
    public void issueCurrencyNoBroadcast() {
        JSONObject jSONObject = new Builder().param("broadcast", false).secretPhrase(null).param("publicKey", ALICE.getPublicKey()).build().invoke();
        Assert.assertNull((Object)jSONObject.get((Object)"errorCode"));
    }

    public String issueCurrencyImpl() {
        APICall aPICall = new Builder().build();
        return TestCurrencyIssuance.issueCurrencyApi(aPICall);
    }

    @Test
    public void issueMultipleCurrencies() {
        APICall aPICall = new Builder().naming("axcc", "AXCC", "Currency A").build();
        TestCurrencyIssuance.issueCurrencyApi(aPICall);
        aPICall = new Builder().naming("bXbx", "BXBX", "Currency B").feeNQT(1000L * ChildChain.IGNIS.ONE_COIN).build();
        TestCurrencyIssuance.issueCurrencyApi(aPICall);
        aPICall = new Builder().naming("ccXcc", "CCCXC", "Currency C").feeNQT(40L * ChildChain.IGNIS.ONE_COIN).build();
        TestCurrencyIssuance.issueCurrencyApi(aPICall);
        aPICall = new APICall.Builder("getCurrency").param("code", "BXBX").build();
        JSONObject jSONObject = aPICall.invoke();
        Assert.assertEquals((Object)"bXbx", (Object)jSONObject.get((Object)"name"));
    }

    static String issueCurrencyApi(APICall aPICall) {
        JSONObject jSONObject = aPICall.invoke();
        String string = Tester.responseToStringId(jSONObject);
        TestCurrencyIssuance.generateBlock();
        aPICall = new APICall.Builder("getCurrency").param("currency", string).build();
        JSONObject jSONObject2 = aPICall.invoke();
        Assert.assertEquals((Object)string, (Object)jSONObject2.get((Object)"currency"));
        return string;
    }

    public static class Builder
    extends APICall.Builder {
        private static int[] FEE_STEPS = new int[]{0, 0, 0, 25000, 1000, 40};
        public static final Tester creator = BlockchainTest.ALICE;
        public static final int initialSupplyQNT = 100000;

        public Builder() {
            super("issueCurrency");
            this.secretPhrase(creator.getSecretPhrase());
            this.chain(ChildChain.IGNIS.getId());
            this.param("name", "Test1");
            this.param("code", "TSXXX");
            this.param("description", "Test Currency 1");
            this.param("type", CurrencyType.EXCHANGEABLE.getCode());
            this.param("maxSupplyQNT", 100000);
            this.param("initialSupplyQNT", 100000);
            this.param("issuanceHeight", 0);
            this.param("algorithm", (byte)0);
            this.feeNQT(40L * ChildChain.IGNIS.ONE_COIN);
        }

        public Builder naming(String string, String string2, String string3) {
            this.param("name", string);
            this.param("code", string2).param("description", string3);
            this.feeNQT((long)FEE_STEPS[string2.length()] * ChildChain.IGNIS.ONE_COIN);
            return this;
        }

        public Builder type(int n) {
            this.param("type", n);
            return this;
        }

        public Builder maxSupply(long l) {
            this.param("maxSupplyQNT", l);
            return this;
        }

        public Builder reserveSupply(long l) {
            this.param("reserveSupplyQNT", l);
            return this;
        }

        public Builder initialSupply(long l) {
            this.param("initialSupplyQNT", l);
            return this;
        }

        public Builder issuanceHeight(int n) {
            this.param("issuanceHeight", n);
            return this;
        }

        public Builder minReservePerUnitNQT(long l) {
            this.param("minReservePerUnitNQT", l);
            return this;
        }

        public Builder minting(byte by, byte by2, byte by3) {
            this.param("minDifficulty", by);
            this.param("maxDifficulty", by2);
            this.param("algorithm", by3);
            return this;
        }
    }
}

