/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.monetarysystem;

import nxt.BlockchainTest;
import nxt.blockchain.ChildChain;
import nxt.crypto.HashFunction;
import nxt.http.APICall;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import nxt.ms.CurrencyMinting;
import nxt.ms.CurrencyType;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestCurrencyMint
extends BlockchainTest {
    @Test
    public void mint() {
        APICall aPICall = new TestCurrencyIssuance.Builder().type(CurrencyType.MINTABLE.getCode() | CurrencyType.EXCHANGEABLE.getCode()).maxSupply(10000000L).initialSupply(0L).issuanceHeight(0).minting((byte)2, (byte)8, HashFunction.SHA256.getId()).build();
        String string = TestCurrencyIssuance.issueCurrencyApi(aPICall);
        this.mintCurrency(string);
    }

    public void mintCurrency(String string) {
        long l;
        APICall aPICall = new APICall.Builder("currencyMint").secretPhrase(ALICE.getSecretPhrase()).feeNQT(ChildChain.IGNIS.ONE_COIN).param("currency", string).param("nonce", 123456).param("unitsQNT", 1000).param("counter", 1).build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("mintResponse: " + jSONObject));
        TestCurrencyMint.generateBlock();
        aPICall = new APICall.Builder("getCurrency").param("currency", string).build();
        JSONObject jSONObject2 = aPICall.invoke();
        Logger.logDebugMessage((String)("getCurrencyResponse: " + jSONObject2));
        Assert.assertEquals((Object)"0", (Object)jSONObject2.get((Object)"currentSupplyQNT"));
        long l2 = 10L;
        long l3 = (Long)jSONObject2.get((Object)"algorithm");
        for (l = 0L; l < Long.MAX_VALUE && !CurrencyMinting.meetsTarget((byte[])CurrencyMinting.getHash((byte)((byte)l3), (long)l, (long)Convert.parseUnsignedLong((String)string), (long)l2, (long)1L, (long)ALICE.getId()), (byte[])CurrencyMinting.getTarget((int)2, (int)8, (long)l2, (long)0L, (long)100000L)); ++l) {
        }
        Logger.logDebugMessage((String)("nonce: " + l));
        aPICall = new APICall.Builder("currencyMint").secretPhrase(ALICE.getSecretPhrase()).feeNQT(ChildChain.IGNIS.ONE_COIN).param("currency", string).param("nonce", l).param("unitsQNT", l2).param("counter", 1).build();
        jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("mintResponse: " + jSONObject));
        TestCurrencyMint.generateBlock();
        aPICall = new APICall.Builder("getCurrency").param("currency", string).build();
        jSONObject2 = aPICall.invoke();
        Logger.logDebugMessage((String)("getCurrencyResponse: " + jSONObject2));
        Assert.assertEquals((Object)("" + l2), (Object)jSONObject2.get((Object)"currentSupplyQNT"));
        aPICall = new APICall.Builder("getMintingTarget").param("currency", string).param("account", ALICE.getId()).param("unitsQNT", "1000").build();
        JSONObject jSONObject3 = aPICall.invoke();
        Logger.logDebugMessage((String)("getMintingTargetResponse: " + jSONObject3));
        Assert.assertEquals((Object)"4000", (Object)jSONObject3.get((Object)"difficulty"));
        Assert.assertEquals((Object)"a9f1d24d62105839b4c876be9f1a2fdd24068195438b6ce7fba9f1d24d621000", (Object)jSONObject3.get((Object)"targetBytes"));
    }
}

