/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.shuffling;

import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.Tester;
import nxt.addons.JO;
import nxt.blockchain.Block;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.crypto.AnonymouslyEncryptedData;
import nxt.http.shuffling.ShufflingUtil;
import nxt.shuffling.Shuffler;
import nxt.shuffling.ShufflingStage;
import nxt.shuffling.ShufflingTransactionType;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAutomatedShuffling
extends BlockchainTest {
    private static final int chainId = ChildChain.IGNIS.getId();

    @Before
    public void stopAllShufflers() {
        Shuffler.stopAllShufflers();
    }

    @Test
    public void successfulShuffling() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        for (int i = 0; i < 4; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        TestAutomatedShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.DONE.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertNull((Object)string2);
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void successfulRestartShuffling() {
        int n;
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        ShufflingUtil.stopShuffler(CHUCK, string);
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.stopShuffler(CHUCK, string);
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        for (n = 0; n < 2; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ShufflingUtil.stopShuffler(BOB, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        for (n = 0; n < 2; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ShufflingUtil.stopShuffler(ALICE, string);
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        TestAutomatedShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.DONE.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertNull((Object)string2);
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void successfulAssetShuffling() {
        JSONObject jSONObject = ShufflingUtil.createAssetShuffling(ALICE);
        String string = (String)jSONObject.get((Object)"fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        for (int i = 0; i < 6; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.DONE.getCode(), (Object)jO.get("stage"));
        String string2 = (String)jO.get("assignee");
        Assert.assertNull((Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + 1003L * ChildChain.IGNIS.ONE_COIN)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + 1003L * ChildChain.IGNIS.ONE_COIN)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE + 1003L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE + 1003L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.ALICE_RECIPIENT.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.ALICE_RECIPIENT.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.BOB_RECIPIENT.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.BOB_RECIPIENT.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.DAVE_RECIPIENT.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.DAVE_RECIPIENT.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)660000L, (long)ALICE.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)660000L, (long)ALICE.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)60000L, (long)BOB.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)60000L, (long)BOB.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)60000L, (long)CHUCK.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)60000L, (long)CHUCK.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)60000L, (long)DAVE.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)60000L, (long)DAVE.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
    }

    @Test
    public void successfulCurrencyShuffling() {
        JSONObject jSONObject = ShufflingUtil.createCurrencyShuffling(ALICE);
        String string = (String)jSONObject.get((Object)"fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        for (int i = 0; i < 6; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.DONE.getCode(), (Object)jO.get("stage"));
        String string2 = (String)jO.get("assignee");
        Assert.assertNull((Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.ALICE_RECIPIENT.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.ALICE_RECIPIENT.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.BOB_RECIPIENT.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.BOB_RECIPIENT.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.DAVE_RECIPIENT.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.DAVE_RECIPIENT.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)9660000L, (long)ALICE.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)9660000L, (long)ALICE.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)60000L, (long)BOB.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)60000L, (long)BOB.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)60000L, (long)CHUCK.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)60000L, (long)CHUCK.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)60000L, (long)DAVE.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)60000L, (long)DAVE.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
    }

    @Test
    public void registrationNotFinished() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        for (int i = 0; i < 9; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)2L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertNull((Object)string2);
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertEquals((long)(2L * ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(2L * ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void registrationNotFinishedAsset() {
        JSONObject jSONObject = ShufflingUtil.createAssetShuffling(ALICE);
        String string = (String)jSONObject.get((Object)"fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        for (int i = 0; i < 9; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO.get("stage"));
        JO jO2 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO2.get("participants");
        Assert.assertEquals((long)2L, (long)jSONArray.size());
        String string2 = (String)jO.get("assignee");
        Assert.assertNull((Object)string2);
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE - 1003L * ChildChain.IGNIS.ONE_COIN), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE - 1003L * ChildChain.IGNIS.ONE_COIN), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertEquals((long)700000L, (long)ALICE.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)700000L, (long)ALICE.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)100000L, (long)BOB.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)100000L, (long)BOB.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)(2L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 1003L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(2L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 1003L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void processingNotStarted() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        for (int i = 0; i < 10; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)ALICE.getStrId(), (Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void processingNotStartedCurrency() {
        JSONObject jSONObject = ShufflingUtil.createCurrencyShuffling(ALICE);
        String string = (String)jSONObject.get((Object)"fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        for (int i = 0; i < 10; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO.get("stage"));
        JO jO2 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO2.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO.get("assignee");
        Assert.assertEquals((Object)ALICE.getStrId(), (Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)9700000L, (long)ALICE.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)9700000L, (long)ALICE.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)100000L, (long)BOB.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)100000L, (long)BOB.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)100000L, (long)CHUCK.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)100000L, (long)CHUCK.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)100000L, (long)DAVE.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)100000L, (long)DAVE.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void tooManyParticipants() {
        JO jO = ShufflingUtil.create(ALICE, 3);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        for (int i = 0; i < 10; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)3L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)ALICE.getStrId(), (Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
    }

    @Test
    public void processingNotFinished() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestAutomatedShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        for (int i = 0; i < 15; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(DAVE.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(3L * (ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * (ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void verifyNotFinished() {
        int n;
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        for (n = 0; n < 5; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        for (n = 0; n < 2; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        for (n = 0; n < 15; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNotNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void verifyNotFinishedRestart() {
        int n;
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        for (n = 0; n < 5; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ShufflingUtil.stopShuffler(BOB, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        for (n = 0; n < 2; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        ShufflingUtil.stopShuffler(ALICE, string);
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        for (n = 0; n < 15; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNotNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void cancelAfterVerifyChuck() {
        int n;
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        for (n = 0; n < 5; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        for (n = 0; n < 5; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        String string2 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.cancel(string, CHUCK, string2, 0L);
        TestAutomatedShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        String string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string3);
        for (int i = 0; i < 15; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string3);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNotNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void cancelAfterVerifyChuckRestart() {
        int n;
        int n2;
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        ShufflingUtil.stopShuffler(BOB, string);
        TestAutomatedShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        for (n2 = 0; n2 < 5; ++n2) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        for (n2 = 0; n2 < 5; ++n2) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ShufflingUtil.stopShuffler(ALICE, string);
        ShufflingUtil.stopShuffler(DAVE, string);
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        String string2 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.cancel(string, CHUCK, string2, 0L);
        TestAutomatedShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        String string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string3);
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        for (n = 0; n < 5; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        for (n = 0; n < 15; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string3);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNotNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void cancelAfterVerifyChuckInvalidKeys() {
        int n;
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        for (n = 0; n < 5; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        for (n = 0; n < 5; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        String string2 = (String)jO2.get("shufflingStateHash");
        JSONObject jSONObject = ShufflingUtil.cancel(string, CHUCK, string2, 0L, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"keySeeds");
        String string3 = (String)jSONArray.get(0);
        jSONArray.set(0, (Object)("0000000000" + string3.substring(10)));
        ShufflingUtil.broadcast(jSONObject2, CHUCK);
        TestAutomatedShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        String string4 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string4);
        for (int i = 0; i < 15; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string4 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string4);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNotNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void cancelAfterVerifyChuckInvalidKeysAlice() {
        int n;
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        for (n = 0; n < 2; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        for (n = 0; n < 5; ++n) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        String string2 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.verify(string, ALICE, string2);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.cancel(string, CHUCK, string2, 0L);
        TestAutomatedShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        string2 = (String)jO2.get("shufflingStateHash");
        String string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string3);
        JSONObject jSONObject = ShufflingUtil.cancel(string, ALICE, string2, CHUCK.getId(), false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"keySeeds");
        String string4 = (String)jSONArray.get(0);
        jSONArray.set(0, (Object)("0000000000" + string4.substring(10)));
        ShufflingUtil.broadcast(jSONObject2, ALICE);
        for (int i = 0; i < 15; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string3);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNotNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void badProcessDataAlice() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JSONObject jSONObject = ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"data");
        String string2 = (String)jSONArray.get(0);
        jSONArray.set(0, (Object)("8080808080" + string2.substring(10)));
        ShufflingUtil.broadcast(jSONObject2, ALICE);
        for (int i = 0; i < 15; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        String string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string3);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void modifiedProcessDataBob() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        for (int i = 0; i < 3; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JSONObject jSONObject = ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"data");
        String string2 = (String)jSONArray.get(0);
        jSONArray.set(0, (Object)("8080808080" + string2.substring(10)));
        ShufflingUtil.broadcast(jSONObject2, BOB);
        TestAutomatedShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        for (int i = 0; i < 5; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.BLAME.getCode(), (Object)jO2.get("stage"));
        String string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string3);
        String string4 = (String)jO2.get("shufflingStateHash");
        JSONObject jSONObject3 = ShufflingUtil.cancel(string, BOB, string4, CHUCK.getId());
        boolean bl = jSONObject3.get((Object)"error") != null;
        for (int i = 0; i < 15; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(BOB.getId()), (Object)string3);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + (bl ? ShufflingUtil.SHUFFLING_PROCESSING_FEE : 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE))), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + (bl ? ShufflingUtil.SHUFFLING_PROCESSING_FEE : 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE))), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 3L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + (bl ? ShufflingUtil.SHUFFLING_PROCESSING_FEE : 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 3L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + (bl ? ShufflingUtil.SHUFFLING_PROCESSING_FEE : 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void duplicateProcessDataBob() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        for (int i = 0; i < 3; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JSONObject jSONObject = ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"data");
        byte[] byArray = Convert.parseHexString((String)string);
        byte[] byArray2 = ShufflingUtil.BOB_RECIPIENT.getPublicKey();
        byte[] byArray3 = Convert.parseHexString((String)string);
        byArray3[0] = (byte)(byArray3[0] ^ 1);
        byArray2 = AnonymouslyEncryptedData.encrypt((byte[])byArray2, (String)BOB.getSecretPhrase(), (byte[])DAVE.getPublicKey(), (byte[])byArray).getBytes();
        byte[] byArray4 = AnonymouslyEncryptedData.encrypt((byte[])byArray2, (String)BOB.getSecretPhrase(), (byte[])CHUCK.getPublicKey(), (byte[])byArray).getBytes();
        byte[] byArray5 = AnonymouslyEncryptedData.encrypt((byte[])byArray2, (String)BOB.getSecretPhrase(), (byte[])CHUCK.getPublicKey(), (byte[])byArray3).getBytes();
        if (Convert.byteArrayComparator.compare(byArray4, byArray5) < 0) {
            jSONArray.set(0, (Object)Convert.toHexString((byte[])byArray4));
            jSONArray.set(1, (Object)Convert.toHexString((byte[])byArray5));
        } else {
            jSONArray.set(0, (Object)Convert.toHexString((byte[])byArray5));
            jSONArray.set(1, (Object)Convert.toHexString((byte[])byArray4));
        }
        ShufflingUtil.broadcast(jSONObject2, BOB);
        TestAutomatedShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        for (int i = 0; i < 10; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.BLAME.getCode(), (Object)jO2.get("stage"));
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        String string3 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.cancel(string, BOB, string3, CHUCK.getId());
        for (int i = 0; i < 15; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(BOB.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 5L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 5L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void modifiedProcessDataChuck() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        for (int i = 0; i < 3; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JSONObject jSONObject = ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"data");
        String string2 = (String)jSONArray.get(0);
        jSONArray.set(0, (Object)("8080808080" + string2.substring(10)));
        ShufflingUtil.broadcast(jSONObject2, CHUCK);
        TestAutomatedShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        for (int i = 0; i < 5; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.BLAME.getCode(), (Object)jO2.get("stage"));
        String string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(DAVE.getId()), (Object)string3);
        String string4 = (String)jO2.get("shufflingStateHash");
        JSONObject jSONObject3 = ShufflingUtil.cancel(string, CHUCK, string4, DAVE.getId());
        boolean bl = jSONObject3.get((Object)"error") != null;
        for (int i = 0; i < 15; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string3);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + (bl ? ShufflingUtil.SHUFFLING_PROCESSING_FEE : 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE))), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + (bl ? ShufflingUtil.SHUFFLING_PROCESSING_FEE : 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE))), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + (bl ? ShufflingUtil.SHUFFLING_PROCESSING_FEE : 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + (bl ? ShufflingUtil.SHUFFLING_PROCESSING_FEE : 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void modifiedRecipientKeysDave() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        for (int i = 0; i < 5; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JSONObject jSONObject = ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"recipientPublicKeys");
        String string2 = (String)jSONArray.get(0);
        if (!string2.equals(ShufflingUtil.DAVE_RECIPIENT.getPublicKeyStr())) {
            jSONArray.set(0, (Object)("0000000000" + string2.substring(10)));
        } else {
            string2 = (String)jSONArray.get(1);
            jSONArray.set(1, (Object)("0000000000" + string2.substring(10)));
        }
        ShufflingUtil.broadcast(jSONObject2, DAVE);
        for (int i = 0; i < 15; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        String string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(DAVE.getId()), (Object)string3);
        Assert.assertEquals((long)(-(2L * (ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)(ALICE.getChainBalanceDiff(chainId) + BOB.getChainBalanceDiff(chainId) + CHUCK.getChainBalanceDiff(chainId)));
        Assert.assertEquals((long)ALICE.getChainBalanceDiff(chainId), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)BOB.getChainBalanceDiff(chainId), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)CHUCK.getChainBalanceDiff(chainId), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertTrue((ShufflingUtil.ALICE_RECIPIENT.getAccount() == null || ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.ALICE_RECIPIENT.getAccount() == null || ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.BOB_RECIPIENT.getAccount() == null || ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.BOB_RECIPIENT.getAccount() == null || ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.CHUCK_RECIPIENT.getAccount() == null || ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.CHUCK_RECIPIENT.getAccount() == null || ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.DAVE_RECIPIENT.getAccount() == null || ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.DAVE_RECIPIENT.getAccount() == null || ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(chainId) == 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)(2L * (ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(2L * (ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void duplicateRecipientKeysDave() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.CHUCK_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        for (int i = 0; i < 5; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JSONObject jSONObject = ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"recipientPublicKeys");
        String string2 = (String)jSONArray.get(0);
        jSONArray.set(1, (Object)string2);
        JSONObject jSONObject3 = ShufflingUtil.broadcast(jSONObject2, DAVE);
        Assert.assertTrue((jSONObject3.get((Object)"error") != null ? 1 : 0) != 0);
        for (int i = 0; i < 15; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        String string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(DAVE.getId()), (Object)string3);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 3L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 3L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void duplicateProcessDataChuck() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(DAVE, ShufflingUtil.DAVE_RECIPIENT, string);
        for (int i = 0; i < 3; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JSONObject jSONObject = ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"data");
        String string2 = (String)jSONArray.get(0);
        jSONArray.set(1, (Object)string2);
        JSONObject jSONObject3 = ShufflingUtil.broadcast(jSONObject2, CHUCK);
        Assert.assertTrue((jSONObject3.get((Object)"error") != null ? 1 : 0) != 0);
        for (int i = 0; i < 15; ++i) {
            TestAutomatedShuffling.generateBlock();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        String string3 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string3);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)CHUCK.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(chainId));
    }

    @Test
    public void duplicateRecipientsBobChuck() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(ALICE, ShufflingUtil.ALICE_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.startShuffler(BOB, ShufflingUtil.BOB_RECIPIENT, string);
        TestAutomatedShuffling.generateBlock();
        JSONObject jSONObject = ShufflingUtil.startShuffler(CHUCK, ShufflingUtil.BOB_RECIPIENT, string);
        Assert.assertTrue((boolean)((String)jSONObject.get((Object)"errorDescription")).startsWith("Incorrect \"recipientPublicKey\""));
    }

    @Test
    public void maxShufflingSize() {
        Object object2;
        Block block;
        int n = 30;
        Tester[] testerArray = new Tester[n];
        Tester[] testerArray2 = new Tester[n];
        testerArray[0] = ALICE;
        testerArray2[0] = ShufflingUtil.ALICE_RECIPIENT;
        for (int i = 1; i < n; ++i) {
            testerArray[i] = new Tester("tester " + i);
            ShufflingUtil.sendMoney(ALICE, testerArray[i], 100L);
            testerArray2[i] = new Tester("recipient " + i);
        }
        TestAutomatedShuffling.generateBlock();
        JO jO = ShufflingUtil.create(ALICE, n);
        String string = (String)jO.get("fullHash");
        TestAutomatedShuffling.generateBlock();
        for (int i = 0; i < n - 1; ++i) {
            ShufflingUtil.startShuffler(testerArray[i], testerArray2[i], string);
        }
        TestAutomatedShuffling.generateBlock();
        ShufflingUtil.register(string, testerArray[n - 1]);
        TestAutomatedShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n + 5; ++i) {
            TestAutomatedShuffling.generateBlock();
            block = Nxt.getBlockchain().getLastBlock();
            Logger.logMessage((String)("Block tx count " + block.getFxtTransactions().size()));
            for (Object object2 : block.getFxtTransactions()) {
                if (object2.getType() == ShufflingTransactionType.SHUFFLING_PROCESSING) {
                    if (object2.getFullSize() > n2) {
                        n2 = object2.getFullSize();
                    }
                    if (object2.getJSONObject().toString().length() > n4) {
                        n4 = object2.getJSONObject().toString().length();
                    }
                }
                if (object2.getType() != ShufflingTransactionType.SHUFFLING_CANCELLATION) continue;
                if (object2.getFullSize() > n2) {
                    n3 = object2.getFullSize();
                }
                if (object2.getJSONObject().toString().length() <= n5) continue;
                n5 = object2.getJSONObject().toString().length();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JSONObject jSONObject = ShufflingUtil.process(string, testerArray[n - 1], testerArray2[n - 1], false);
        block = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray = (JSONArray)((JSONObject)block.get((Object)"attachment")).get((Object)"recipientPublicKeys");
        object2 = (String)jSONArray.get(0);
        if (!((String)object2).equals(testerArray2[n - 1].getPublicKeyStr())) {
            jSONArray.set(0, (Object)("0000000000" + ((String)object2).substring(10)));
        } else {
            object2 = (String)jSONArray.get(1);
            jSONArray.set(1, (Object)("0000000000" + ((String)object2).substring(10)));
        }
        ShufflingUtil.broadcast((JSONObject)block, testerArray[n - 1]);
        TestAutomatedShuffling.generateBlock();
        for (int i = 0; i < n + 20; ++i) {
            TestAutomatedShuffling.generateBlock();
            Block block2 = Nxt.getBlockchain().getLastBlock();
            Logger.logMessage((String)("Block tx count " + block2.getFxtTransactions().size()));
            for (Transaction transaction : block2.getFxtTransactions()) {
                if (transaction.getType() == ShufflingTransactionType.SHUFFLING_PROCESSING) {
                    if (transaction.getFullSize() > n2) {
                        n2 = transaction.getFullSize();
                    }
                    if (transaction.getJSONObject().toString().length() > n4) {
                        n4 = transaction.getJSONObject().toString().length();
                    }
                }
                if (transaction.getType() != ShufflingTransactionType.SHUFFLING_CANCELLATION) continue;
                if (transaction.getFullSize() > n2) {
                    n3 = transaction.getFullSize();
                }
                if (transaction.getJSONObject().toString().length() <= n5) continue;
                n5 = transaction.getJSONObject().toString().length();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(testerArray[n - 1].getId()), (Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE) + 100L * ChildChain.IGNIS.ONE_COIN), (long)testerArray[n - 1].getChainBalanceDiff(chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE) + 100L * ChildChain.IGNIS.ONE_COIN), (long)testerArray[n - 1].getChainUnconfirmedBalanceDiff(chainId));
        Logger.logMessage((String)("Max process transaction full size " + n2));
        Logger.logMessage((String)("Max cancel transaction full size " + n3));
        Logger.logMessage((String)("Max process transaction json size " + n4));
        Logger.logMessage((String)("Max cancel transaction json size " + n5));
    }
}

