/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.shuffling;

import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.addons.JO;
import nxt.blockchain.ChildChain;
import nxt.http.shuffling.ShufflingUtil;
import nxt.shuffling.ShufflingStage;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestShuffling
extends BlockchainTest {
    @Test
    public void successfulShuffling() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)ALICE.getChainBalanceDiff(2));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        String string3 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.verify(string, ALICE, string3);
        ShufflingUtil.verify(string, BOB, string3);
        ShufflingUtil.verify(string, CHUCK, string3);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.DONE.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertNull((Object)string2);
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(1500000000L + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)1500000000L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void successfulAssetShuffling() {
        JSONObject jSONObject = ShufflingUtil.createAssetShuffling(ALICE);
        String string = (String)jSONObject.get((Object)"fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO.get("stage"));
        JO jO2 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO2.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        TestShuffling.generateBlock();
        jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO.get("stage"));
        String string3 = (String)jO.get("shufflingStateHash");
        ShufflingUtil.verify(string, ALICE, string3);
        ShufflingUtil.verify(string, BOB, string3);
        ShufflingUtil.verify(string, CHUCK, string3);
        TestShuffling.generateBlock();
        jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.DONE.getCode(), (Object)jO.get("stage"));
        string2 = (String)jO.get("assignee");
        Assert.assertNull((Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + 1003L * ChildChain.IGNIS.ONE_COIN)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + 1003L * ChildChain.IGNIS.ONE_COIN)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE + 1003L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE + 1003L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.ALICE_RECIPIENT.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.ALICE_RECIPIENT.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.BOB_RECIPIENT.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.BOB_RECIPIENT.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.DAVE_RECIPIENT.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.DAVE_RECIPIENT.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)660000L, (long)ALICE.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)660000L, (long)ALICE.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)60000L, (long)BOB.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)60000L, (long)BOB.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)60000L, (long)CHUCK.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)60000L, (long)CHUCK.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)60000L, (long)DAVE.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)60000L, (long)DAVE.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
    }

    @Test
    public void successfulCurrencyShuffling() {
        JSONObject jSONObject = ShufflingUtil.createCurrencyShuffling(ALICE);
        String string = (String)jSONObject.get((Object)"fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO.get("stage"));
        JO jO2 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO2.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        TestShuffling.generateBlock();
        jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO.get("stage"));
        String string3 = (String)jO.get("shufflingStateHash");
        ShufflingUtil.verify(string, ALICE, string3);
        ShufflingUtil.verify(string, BOB, string3);
        ShufflingUtil.verify(string, CHUCK, string3);
        TestShuffling.generateBlock();
        jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.DONE.getCode(), (Object)jO.get("stage"));
        string2 = (String)jO.get("assignee");
        Assert.assertNull((Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN)), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN)), (long)ALICE.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_TOTAL_FEE + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.ALICE_RECIPIENT.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.ALICE_RECIPIENT.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.BOB_RECIPIENT.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.BOB_RECIPIENT.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.CHUCK_RECIPIENT.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.DAVE_RECIPIENT.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)40000L, (long)ShufflingUtil.DAVE_RECIPIENT.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)9660000L, (long)ALICE.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)9660000L, (long)ALICE.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)60000L, (long)BOB.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)60000L, (long)BOB.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)60000L, (long)CHUCK.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)60000L, (long)CHUCK.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)60000L, (long)DAVE.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)60000L, (long)DAVE.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
    }

    @Test
    public void registrationNotFinished() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        for (int i = 0; i < 9; ++i) {
            TestShuffling.generateBlock();
        }
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)2L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertNull((Object)string2);
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertEquals((long)(2L * ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(2L * ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void registrationNotFinishedAsset() {
        JSONObject jSONObject = ShufflingUtil.createAssetShuffling(ALICE);
        String string = (String)jSONObject.get((Object)"fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        for (int i = 0; i < 9; ++i) {
            TestShuffling.generateBlock();
        }
        JO jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO.get("stage"));
        JO jO2 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO2.get("participants");
        Assert.assertEquals((long)2L, (long)jSONArray.size());
        String string2 = (String)jO.get("assignee");
        Assert.assertNull((Object)string2);
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE - 1003L * ChildChain.IGNIS.ONE_COIN), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE - 1003L * ChildChain.IGNIS.ONE_COIN), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertEquals((long)700000L, (long)ALICE.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)700000L, (long)ALICE.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)100000L, (long)BOB.getAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)100000L, (long)BOB.getUnconfirmedAssetQuantityDiff(ShufflingUtil.shufflingAsset));
        Assert.assertEquals((long)(2L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 1003L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(2L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 1003L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void processingNotStarted() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        for (int i = 0; i < 10; ++i) {
            TestShuffling.generateBlock();
        }
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)ALICE.getStrId(), (Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void processingNotStartedCurrency() {
        JSONObject jSONObject = ShufflingUtil.createCurrencyShuffling(ALICE);
        String string = (String)jSONObject.get((Object)"fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        for (int i = 0; i < 10; ++i) {
            TestShuffling.generateBlock();
        }
        JO jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO.get("stage"));
        JO jO2 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO2.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO.get("assignee");
        Assert.assertEquals((Object)ALICE.getStrId(), (Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN)), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN)), (long)ALICE.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)9700000L, (long)ALICE.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)9700000L, (long)ALICE.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)100000L, (long)BOB.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)100000L, (long)BOB.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)100000L, (long)CHUCK.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)100000L, (long)CHUCK.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)100000L, (long)DAVE.getCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)100000L, (long)DAVE.getUnconfirmedCurrencyUnitsDiff(ShufflingUtil.shufflingCurrency));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + 3L * ChildChain.IGNIS.ONE_COIN + 1000L * ChildChain.IGNIS.ONE_COIN), (long)FORGY.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void tooManyParticipants() {
        JO jO = ShufflingUtil.create(ALICE, 3);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        ShufflingUtil.register(string, CHUCK);
        ShufflingUtil.register(string, DAVE);
        ShufflingUtil.register(string, FORGY);
        for (int i = 0; i < 10; ++i) {
            TestShuffling.generateBlock();
        }
        Nxt.getTransactionProcessor().clearUnconfirmedTransactions();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)3L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)ALICE.getStrId(), (Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
    }

    @Test
    public void processingNotFinished() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        for (int i = 0; i < 10; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(DAVE.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(3L * (ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * (ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ShufflingUtil.SHUFFLING_REGISTER_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void verifyNotStarted() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNotNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * (ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ShufflingUtil.SHUFFLING_TOTAL_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * (ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ShufflingUtil.SHUFFLING_TOTAL_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void verifyNotFinished() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        String string3 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.verify(string, ALICE, string3);
        ShufflingUtil.verify(string, BOB, string3);
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNotNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void cancelAfterVerifyChuck() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        String string3 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.verify(string, ALICE, string3);
        ShufflingUtil.verify(string, BOB, string3);
        ShufflingUtil.cancel(string, CHUCK, string3, 0L);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        string3 = (String)jO2.get("shufflingStateHash");
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        ShufflingUtil.cancel(string, ALICE, string3, CHUCK.getId());
        ShufflingUtil.cancel(string, BOB, string3, CHUCK.getId());
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNotNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(2L * (ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(2L * (ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void cancelAfterVerifyChuckInvalidKeys() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        String string3 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.verify(string, ALICE, string3);
        ShufflingUtil.verify(string, BOB, string3);
        JSONObject jSONObject = ShufflingUtil.cancel(string, CHUCK, string3, 0L, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray2 = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"keySeeds");
        String string4 = (String)jSONArray2.get(0);
        jSONArray2.set(0, (Object)("0000000000" + string4.substring(10)));
        ShufflingUtil.broadcast(jSONObject2, CHUCK);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        string3 = (String)jO2.get("shufflingStateHash");
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        ShufflingUtil.cancel(string, ALICE, string3, CHUCK.getId());
        ShufflingUtil.cancel(string, BOB, string3, CHUCK.getId());
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNotNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void cancelAfterVerifyChuckInvalidKeysAlice() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        String string3 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.verify(string, ALICE, string3);
        ShufflingUtil.verify(string, BOB, string3);
        ShufflingUtil.cancel(string, CHUCK, string3, 0L);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        string3 = (String)jO2.get("shufflingStateHash");
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        JSONObject jSONObject = ShufflingUtil.cancel(string, ALICE, string3, CHUCK.getId(), false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray2 = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"keySeeds");
        String string4 = (String)jSONArray2.get(0);
        jSONArray2.set(0, (Object)("0000000000" + string4.substring(10)));
        ShufflingUtil.broadcast(jSONObject2, ALICE);
        TestShuffling.generateBlock();
        ShufflingUtil.cancel(string, BOB, string3, CHUCK.getId());
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNotNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void cancelAfterVerifyChuckInvalidKeysAlice2() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        String string3 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.verify(string, ALICE, string3);
        ShufflingUtil.verify(string, BOB, string3);
        ShufflingUtil.cancel(string, CHUCK, string3, 0L);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        string3 = (String)jO2.get("shufflingStateHash");
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        JSONObject jSONObject = ShufflingUtil.cancel(string, ALICE, string3, CHUCK.getId(), false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray2 = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"keySeeds");
        String string4 = (String)jSONArray2.get(1);
        jSONArray2.set(1, (Object)("0000000000" + string4.substring(10)));
        ShufflingUtil.broadcast(jSONObject2, ALICE);
        TestShuffling.generateBlock();
        ShufflingUtil.cancel(string, BOB, string3, CHUCK.getId());
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNotNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNotNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)0L, (long)ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_TOTAL_FEE + ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void badProcessDataAlice() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        JSONObject jSONObject = ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray2 = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"data");
        String string3 = (String)jSONArray2.get(0);
        jSONArray2.set(0, (Object)("8080808080" + string3.substring(10)));
        ShufflingUtil.broadcast(jSONObject2, ALICE);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.BLAME.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(BOB.getId()), (Object)string2);
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void modifiedProcessDataBob() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        JSONObject jSONObject = ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray2 = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"data");
        String string3 = (String)jSONArray2.get(0);
        jSONArray2.set(0, (Object)("8080808080" + string3.substring(10)));
        ShufflingUtil.broadcast(jSONObject2, BOB);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.BLAME.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        String string4 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.cancel(string, ALICE, string4, CHUCK.getId());
        JSONObject jSONObject3 = ShufflingUtil.cancel(string, BOB, string4, CHUCK.getId());
        boolean bl = jSONObject3.get((Object)"error") != null;
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(BOB.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + (bl ? ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE : ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE))), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + (bl ? ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE : ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE))), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 3L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + (bl ? ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE : ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 3L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + (bl ? ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE : ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void modifiedProcessDataChuck() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        JSONObject jSONObject = ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray2 = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"data");
        String string3 = (String)jSONArray2.get(0);
        jSONArray2.set(0, (Object)("8080808080" + string3.substring(10)));
        ShufflingUtil.broadcast(jSONObject2, CHUCK);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.BLAME.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(DAVE.getId()), (Object)string2);
        String string4 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.cancel(string, ALICE, string4, DAVE.getId());
        ShufflingUtil.cancel(string, BOB, string4, DAVE.getId());
        JSONObject jSONObject3 = ShufflingUtil.cancel(string, CHUCK, string4, DAVE.getId());
        boolean bl = jSONObject3.get((Object)"error") != null;
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + (bl ? ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE : ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE))), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + (bl ? ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE : ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE))), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(2L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + (bl ? ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE : ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(2L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 4L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + (bl ? ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE : ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE) + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void modifiedRecipientKeysDave() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        JSONObject jSONObject = ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray2 = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"recipientPublicKeys");
        String string3 = (String)jSONArray2.get(0);
        if (!string3.equals(ShufflingUtil.DAVE_RECIPIENT.getPublicKeyStr())) {
            jSONArray2.set(0, (Object)("0000000000" + string3.substring(10)));
        } else {
            string3 = (String)jSONArray2.get(1);
            jSONArray2.set(1, (Object)("0000000000" + string3.substring(10)));
        }
        ShufflingUtil.broadcast(jSONObject2, DAVE);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO2.get("stage"));
        String string4 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.cancel(string, ALICE, string4, 0L);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        string4 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.cancel(string, BOB, string4, ALICE.getId());
        ShufflingUtil.cancel(string, CHUCK, string4, ALICE.getId());
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(DAVE.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_TOTAL_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertTrue((ShufflingUtil.ALICE_RECIPIENT.getAccount() == null || ShufflingUtil.ALICE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.ALICE_RECIPIENT.getAccount() == null || ShufflingUtil.ALICE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.BOB_RECIPIENT.getAccount() == null || ShufflingUtil.BOB_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.BOB_RECIPIENT.getAccount() == null || ShufflingUtil.BOB_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.CHUCK_RECIPIENT.getAccount() == null || ShufflingUtil.CHUCK_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.CHUCK_RECIPIENT.getAccount() == null || ShufflingUtil.CHUCK_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.DAVE_RECIPIENT.getAccount() == null || ShufflingUtil.DAVE_RECIPIENT.getChainBalanceDiff(ShufflingUtil.chainId) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((ShufflingUtil.DAVE_RECIPIENT.getAccount() == null || ShufflingUtil.DAVE_RECIPIENT.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId) == 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 6L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 6L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void duplicateRecipientKeysDave() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        JSONObject jSONObject = ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray2 = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"recipientPublicKeys");
        String string3 = (String)jSONArray2.get(0);
        jSONArray2.set(1, (Object)string3);
        JSONObject jSONObject3 = ShufflingUtil.broadcast(jSONObject2, DAVE);
        Assert.assertTrue((jSONObject3.get((Object)"error") != null ? 1 : 0) != 0);
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(DAVE.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 3L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 3L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void duplicateProcessDataChuck() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        JSONObject jSONObject = ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT, false);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        JSONArray jSONArray2 = (JSONArray)((JSONObject)jSONObject2.get((Object)"attachment")).get((Object)"data");
        String string3 = (String)jSONArray2.get(0);
        jSONArray2.set(1, (Object)string3);
        JSONObject jSONObject3 = ShufflingUtil.broadcast(jSONObject2, CHUCK);
        Assert.assertTrue((jSONObject3.get((Object)"error") != null ? 1 : 0) != 0);
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + ShufflingUtil.SHUFFLING_REGISTER_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_REGISTER_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(4L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void duplicateRecipientsBobChuck() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.BOB_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.BLAME.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(DAVE.getId()), (Object)string2);
        String string3 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.cancel(string, ALICE, string3, DAVE.getId());
        ShufflingUtil.cancel(string, BOB, string3, DAVE.getId());
        ShufflingUtil.cancel(string, CHUCK, string3, DAVE.getId());
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(CHUCK.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + (ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE))), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + (ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE))), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 6L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 6L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }

    @Test
    public void duplicateRecipientsAliceBob() {
        JO jO = ShufflingUtil.create(ALICE);
        String string = (String)jO.get("fullHash");
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, BOB);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, CHUCK);
        TestShuffling.generateBlock();
        ShufflingUtil.register(string, DAVE);
        TestShuffling.generateBlock();
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.PROCESSING.getCode(), (Object)jO2.get("stage"));
        JO jO3 = ShufflingUtil.getShufflingParticipants(string);
        JSONArray jSONArray = (JSONArray)jO3.get("participants");
        Assert.assertEquals((long)4L, (long)jSONArray.size());
        String string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(ALICE.getId()), (Object)string2);
        ShufflingUtil.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, BOB, ShufflingUtil.ALICE_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TestShuffling.generateBlock();
        ShufflingUtil.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        TestShuffling.generateBlock();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.BLAME.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(DAVE.getId()), (Object)string2);
        String string3 = (String)jO2.get("shufflingStateHash");
        ShufflingUtil.cancel(string, ALICE, string3, DAVE.getId());
        ShufflingUtil.cancel(string, BOB, string3, DAVE.getId());
        ShufflingUtil.cancel(string, CHUCK, string3, DAVE.getId());
        for (int i = 0; i < 14; ++i) {
            TestShuffling.generateBlock();
        }
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.CANCELLED.getCode(), (Object)jO2.get("stage"));
        string2 = (String)jO2.get("assignee");
        Assert.assertEquals((Object)Long.toUnsignedString(BOB.getId()), (Object)string2);
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)ALICE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + (ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE))), (long)BOB.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT + (ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE))), (long)BOB.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-(ShufflingUtil.SHUFFLING_REGISTER_FEE + 2L * ShufflingUtil.SHUFFLING_PROCESSING_FEE)), (long)CHUCK.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(-ShufflingUtil.SHUFFLING_TOTAL_FEE), (long)DAVE.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
        Assert.assertNull((Object)ShufflingUtil.ALICE_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.BOB_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.CHUCK_RECIPIENT.getAccount());
        Assert.assertNull((Object)ShufflingUtil.DAVE_RECIPIENT.getAccount());
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 6L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainBalanceDiff(ShufflingUtil.chainId));
        Assert.assertEquals((long)(3L * ShufflingUtil.SHUFFLING_REGISTER_FEE + 6L * ShufflingUtil.SHUFFLING_PROCESSING_FEE + ShufflingUtil.SHUFFLING_TOTAL_FEE + ChildChain.IGNIS.SHUFFLING_DEPOSIT_NQT), (long)FORGY.getChainUnconfirmedBalanceDiff(ShufflingUtil.chainId));
    }
}

