/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.twophased;

import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.blockchain.ChildChain;
import nxt.crypto.HashFunction;
import nxt.http.APICall;
import nxt.http.accountControl.ACTestUtils;
import nxt.http.twophased.TestCreateTwoPhased;
import nxt.util.JSONAssert;
import nxt.util.Logger;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestApproveTransaction
extends BlockchainTest {
    @Test
    public void validVoteCasting() {
        int n = 10;
        APICall aPICall = new TestCreateTwoPhased.TwoPhasedMoneyTransferBuilder().finishHeight(Nxt.getBlockchain().getHeight() + n).build();
        JSONObject jSONObject = TestCreateTwoPhased.issueCreateTwoPhased(aPICall, false);
        TestApproveTransaction.generateBlock();
        aPICall = new APICall.Builder("approveTransaction").param("secretPhrase", CHUCK.getSecretPhrase()).param("phasedTransaction", ChildChain.IGNIS.getId() + ":" + jSONObject.get((Object)"fullHash")).param("feeNQT", ChildChain.IGNIS.ONE_COIN).build();
        JSONObject jSONObject2 = aPICall.invoke();
        Logger.logMessage((String)("approvePhasedTransactionResponse:" + jSONObject2.toJSONString()));
        Assert.assertNotNull((Object)jSONObject2.get((Object)"fullHash"));
        TestApproveTransaction.generateBlocks(n);
        Assert.assertEquals((long)(-50L * ChildChain.IGNIS.ONE_COIN - 2L * ChildChain.IGNIS.ONE_COIN), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(50L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-ChildChain.IGNIS.ONE_COIN), (long)CHUCK.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void invalidVoteCasting() {
        int n = 10;
        APICall aPICall = new TestCreateTwoPhased.TwoPhasedMoneyTransferBuilder().finishHeight(Nxt.getBlockchain().getHeight() + n).build();
        JSONObject jSONObject = TestCreateTwoPhased.issueCreateTwoPhased(aPICall, false);
        TestApproveTransaction.generateBlock();
        aPICall = new APICall.Builder("approveTransaction").param("secretPhrase", DAVE.getSecretPhrase()).param("phasedTransaction", ChildChain.IGNIS.getId() + ":" + jSONObject.get((Object)"fullHash")).param("feeNQT", ChildChain.IGNIS.ONE_COIN).build();
        JSONObject jSONObject2 = aPICall.invoke();
        Assert.assertNotNull((Object)jSONObject2.get((Object)"error"));
        TestApproveTransaction.generateBlock();
        Assert.assertEquals((String)"ALICE balance: ", (long)(-2L * ChildChain.IGNIS.ONE_COIN), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((String)"BOB balance: ", (long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((String)"CHUCK balance: ", (long)0L, (long)CHUCK.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((String)"DAVE balance: ", (long)0L, (long)DAVE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        TestApproveTransaction.generateBlocks(n);
        Assert.assertEquals((String)"ALICE balance: ", (long)(-2L * ChildChain.IGNIS.ONE_COIN), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((String)"BOB balance: ", (long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((String)"CHUCK balance: ", (long)0L, (long)CHUCK.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((String)"DAVE balance: ", (long)0L, (long)DAVE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void sendMoneyPhasedNoVoting() {
        long l = 2L * ChildChain.IGNIS.ONE_COIN;
        JSONObject jSONObject = new APICall.Builder("sendMoney").param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).param("amountNQT", 100L * ChildChain.IGNIS.ONE_COIN).param("feeNQT", l).param("phased", "true").param("phasingFinishHeight", 3).param("phasingVotingModel", -1).build().invoke();
        Logger.logDebugMessage((String)("sendMoney: " + jSONObject));
        TestApproveTransaction.generateBlock();
        Assert.assertEquals((long)l, (long)FORGY.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)l, (long)FORGY.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-l), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)ALICE.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)0L, (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        TestApproveTransaction.generateBlock();
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)ALICE.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void sendMoneyPhasedByTransactionHash() {
        JSONObject jSONObject = TestApproveTransaction.getSignedBytes();
        Logger.logDebugMessage((String)("signedSendMessage: " + jSONObject));
        String string = (String)jSONObject.get((Object)"fullHash");
        Assert.assertEquals((long)64L, (long)string.length());
        String string2 = (String)jSONObject.get((Object)"transactionBytes");
        long l = 3L * ChildChain.IGNIS.ONE_COIN;
        jSONObject = new APICall.Builder("sendMoney").param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).param("amountNQT", 100L * ChildChain.IGNIS.ONE_COIN).param("feeNQT", l).param("phased", "true").param("phasingFinishHeight", 4).param("phasingVotingModel", 4).param("phasingLinkedTransaction", ChildChain.IGNIS.getId() + ":" + string).param("phasingQuorum", 1).build().invoke();
        Logger.logDebugMessage((String)("sendMoney: " + jSONObject));
        TestApproveTransaction.generateBlock();
        Assert.assertEquals((long)(-l), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)ALICE.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)0L, (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        jSONObject = new APICall.Builder("broadcastTransaction").param("transactionBytes", string2).build().invoke();
        Logger.logDebugMessage((String)("broadcastTransaction: " + jSONObject));
        TestApproveTransaction.generateBlock();
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)ALICE.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void sendMoneyPhasedByTransactionHash2of3() {
        JSONObject jSONObject = TestApproveTransaction.getSignedBytes();
        Logger.logDebugMessage((String)("signedSendMessage: " + jSONObject));
        String string = (String)jSONObject.get((Object)"fullHash");
        Assert.assertEquals((long)64L, (long)string.length());
        String string2 = (String)jSONObject.get((Object)"transactionBytes");
        jSONObject = TestApproveTransaction.getSignedBytes();
        Logger.logDebugMessage((String)("signedSendMessage: " + jSONObject));
        String string3 = (String)jSONObject.get((Object)"fullHash");
        Assert.assertEquals((long)64L, (long)string3.length());
        jSONObject = TestApproveTransaction.getSignedBytes();
        Logger.logDebugMessage((String)("signedSendMessage: " + jSONObject));
        String string4 = (String)jSONObject.get((Object)"fullHash");
        Assert.assertEquals((long)64L, (long)string4.length());
        String string5 = (String)jSONObject.get((Object)"transactionBytes");
        String string6 = ChildChain.IGNIS.getId() + ":";
        long l = 5L * ChildChain.IGNIS.ONE_COIN;
        jSONObject = new APICall.Builder("sendMoney").param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).param("amountNQT", 100L * ChildChain.IGNIS.ONE_COIN).param("feeNQT", l).param("phased", "true").param("phasingFinishHeight", 3).param("phasingVotingModel", 4).param("phasingLinkedTransaction", new String[]{string6 + string, string6 + string3, string6 + string4}).param("phasingQuorum", 2).build().invoke();
        Logger.logDebugMessage((String)("sendMoney: " + jSONObject));
        TestApproveTransaction.generateBlock();
        Assert.assertEquals((long)(-l), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)ALICE.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)0L, (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        jSONObject = new APICall.Builder("broadcastTransaction").param("transactionBytes", string2).build().invoke();
        Logger.logDebugMessage((String)("broadcastTransaction: " + jSONObject));
        jSONObject = new APICall.Builder("broadcastTransaction").param("transactionBytes", string5).build().invoke();
        Logger.logDebugMessage((String)("broadcastTransaction: " + jSONObject));
        TestApproveTransaction.generateBlock();
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)ALICE.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void sendMoneyPhasedByTransactionHashNotApplied() {
        long l = 3L * ChildChain.IGNIS.ONE_COIN;
        JSONObject jSONObject = new APICall.Builder("sendMoney").param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).param("amountNQT", 100L * ChildChain.IGNIS.ONE_COIN).param("feeNQT", l).param("phased", "true").param("phasingFinishHeight", 3).param("phasingVotingModel", 4).param("phasingLinkedTransaction", ChildChain.IGNIS.getId() + ":a13bbe67211fea8d59b2621f1e0118bb242dc5000d428a23a8bd47491a05d681").param("phasingQuorum", 1).build().invoke();
        Logger.logDebugMessage((String)("sendMoney: " + jSONObject));
        TestApproveTransaction.generateBlock();
        Assert.assertEquals((long)(-l), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)ALICE.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)0L, (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        TestApproveTransaction.generateBlock();
        Assert.assertEquals((long)(-l), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-l), (long)ALICE.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)0L, (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void setAliasPhasedByTransactionHashInvalid() {
        JSONObject jSONObject = TestApproveTransaction.getSignedBytes();
        Logger.logDebugMessage((String)("signedSendMessage: " + jSONObject));
        String string = (String)jSONObject.get((Object)"fullHash");
        Assert.assertEquals((long)64L, (long)string.length());
        String string2 = (String)jSONObject.get((Object)"transactionBytes");
        long l = 2L * ChildChain.IGNIS.ONE_COIN;
        String string3 = "alias" + System.currentTimeMillis();
        jSONObject = new APICall.Builder("setAlias").param("secretPhrase", ALICE.getSecretPhrase()).param("aliasName", string3).param("feeNQT", l).param("phased", "true").param("phasingFinishHeight", 5).param("phasingVotingModel", 4).param("phasingLinkedTransaction", string).param("phasingQuorum", 1).build().invoke();
        Logger.logDebugMessage((String)("setAlias: " + jSONObject));
        TestApproveTransaction.generateBlock();
        jSONObject = new APICall.Builder("getAlias").param("aliasName", string3).build().invoke();
        Logger.logDebugMessage((String)("getAlias: " + jSONObject));
        Assert.assertEquals((Object)5L, (Object)jSONObject.get((Object)"errorCode"));
        jSONObject = new APICall.Builder("broadcastTransaction").param("transactionBytes", string2).build().invoke();
        Logger.logDebugMessage((String)("broadcastTransaction: " + jSONObject));
        TestApproveTransaction.generateBlock();
        jSONObject = new APICall.Builder("setAlias").param("secretPhrase", BOB.getSecretPhrase()).param("aliasName", string3).param("feeNQT", l).build().invoke();
        Logger.logDebugMessage((String)("setSameAlias: " + jSONObject));
        TestApproveTransaction.generateBlock();
        jSONObject = new APICall.Builder("getAlias").param("aliasName", string3).build().invoke();
        Logger.logDebugMessage((String)("getAlias: " + jSONObject));
        Assert.assertEquals((Object)BOB.getStrId(), (Object)jSONObject.get((Object)"account"));
        TestApproveTransaction.generateBlock();
        jSONObject = new APICall.Builder("getAlias").param("aliasName", string3).build().invoke();
        Logger.logDebugMessage((String)("getAlias: " + jSONObject));
        Assert.assertEquals((Object)BOB.getStrId(), (Object)jSONObject.get((Object)"account"));
    }

    @Test
    public void testInvalidHash() {
        long l = 100L * ChildChain.IGNIS.ONE_COIN;
        String string = "abc";
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        phasingBuilder.param("recipient", BOB.getStrId()).param("amountNQT", l);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.HASH).hashedSecret(string, HashFunction.SHA256).quorum(1);
        String string2 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        APICall.Builder builder = ACTestUtils.approveBuilder(string2, BOB, "wrong secret");
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        Assert.assertEquals((Object)String.format("Hashed secret(s) in phased transaction %s:%s do not match any of the revealed secrets", ChildChain.IGNIS.getId(), string2), (Object)jSONAssert.str("errorDescription"));
    }

    @Test
    public void testApproveTwoTransactionsWithOneSecret() {
        long l = 100L * ChildChain.IGNIS.ONE_COIN;
        String string = "abc";
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        phasingBuilder.param("recipient", BOB.getStrId()).param("amountNQT", l);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.HASH).hashedSecret(string, HashFunction.SHA256).quorum(1);
        String string2 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        String string3 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        APICall.Builder builder = ACTestUtils.approveBuilder(string2, BOB, string);
        builder.param("phasedTransaction", new String[]{ChildChain.IGNIS.getId() + ":" + string2, ChildChain.IGNIS.getId() + ":" + string3});
        new JSONAssert(builder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        Assert.assertEquals((long)(2L * l - ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testApproveTwoTransactionsWithTwoSecrets() {
        long l = 100L * ChildChain.IGNIS.ONE_COIN;
        String string = "abc111";
        String string2 = "abc222";
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        phasingBuilder.param("recipient", BOB.getStrId()).param("amountNQT", l);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.HASH).hashedSecret(string, HashFunction.SHA256).quorum(1);
        String string3 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        phasingBuilder.hashedSecret(string2, HashFunction.SHA256);
        String string4 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        APICall.Builder builder = ACTestUtils.approveBuilder(string3, BOB, "");
        builder.param("phasedTransaction", new String[]{ChildChain.IGNIS.getId() + ":" + string3, ChildChain.IGNIS.getId() + ":" + string4});
        builder.param("revealedSecretText", new String[]{string, string2});
        new JSONAssert(builder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        Assert.assertEquals((long)(2L * l - ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testApproveTransactionsWithTwoSecretsWithoutFullhash() {
        long l = 100L * ChildChain.IGNIS.ONE_COIN;
        String string = "abc111";
        String string2 = "abc222";
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        phasingBuilder.param("recipient", BOB.getStrId()).param("amountNQT", l);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.HASH).hashedSecret(string, HashFunction.SHA256).quorum(1);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        phasingBuilder.hashedSecret(string2, HashFunction.SHA256);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        APICall.Builder builder = ACTestUtils.approveBuilder(null, BOB, "");
        builder.param("revealedSecretText", new String[]{string, string2});
        new JSONAssert(builder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        Assert.assertEquals((long)(2L * l - ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testApproveUnusedSecret() {
        long l = 100L * ChildChain.IGNIS.ONE_COIN;
        String string = "abc111";
        String string2 = "abc222";
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        phasingBuilder.param("recipient", BOB.getStrId()).param("amountNQT", l);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.HASH).hashedSecret(string, HashFunction.SHA256).quorum(1);
        String string3 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        APICall.Builder builder = ACTestUtils.approveBuilder(string3, BOB, "");
        builder.param("revealedSecretText", new String[]{string, string2});
        Assert.assertEquals((Object)"Revealed secret with index 1 is not used", (Object)new JSONAssert(builder.build().invoke()).str("errorDescription"));
    }

    @Test
    public void testInvalidHashInOneOfTheTransactions() {
        long l = 100L * ChildChain.IGNIS.ONE_COIN;
        String string = "abc";
        String string2 = "wrong secret";
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        phasingBuilder.param("recipient", BOB.getStrId()).param("amountNQT", l);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.HASH).hashedSecret(string, HashFunction.SHA256).quorum(1);
        String string3 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        phasingBuilder.hashedSecret(string2, HashFunction.SHA256);
        String string4 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestApproveTransaction.generateBlock();
        APICall.Builder builder = ACTestUtils.approveBuilder(string3, BOB, string);
        builder.param("phasedTransaction", new String[]{ChildChain.IGNIS.getId() + ":" + string3, ChildChain.IGNIS.getId() + ":" + string4});
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        Assert.assertEquals((Object)String.format("Hashed secret(s) in phased transaction %s:%s do not match any of the revealed secrets", ChildChain.IGNIS.getId(), string4), (Object)jSONAssert.str("errorDescription"));
    }

    static JSONObject getSignedBytes() {
        JSONObject jSONObject = new APICall.Builder("sendMessage").param("publicKey", CHUCK.getPublicKeyStr()).param("recipient", ALICE.getStrId()).param("message", "approval notice").param("feeNQT", ChildChain.IGNIS.ONE_COIN).build().invoke();
        Logger.logDebugMessage((String)("sendMessage not broadcasted: " + jSONObject));
        jSONObject = new APICall.Builder("signTransaction").param("secretPhrase", CHUCK.getSecretPhrase()).param("unsignedTransactionBytes", (String)jSONObject.get((Object)"unsignedTransactionBytes")).build().invoke();
        return jSONObject;
    }
}

