/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.twophased;

import nxt.BlockchainTest;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.twophased.TestCreateTwoPhased;
import nxt.http.twophased.TwoPhasedSuite;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestGetAssetPhasedTransactions
extends BlockchainTest {
    static APICall phasedTransactionsApiCall(String string) {
        return new APICall.Builder("getAssetPhasedTransactions").param("asset", string).param("firstIndex", 0).param("lastIndex", 10).build();
    }

    private APICall byAssetApiCall(String string) {
        return new TestCreateTwoPhased.TwoPhasedMoneyTransferBuilder().votingModel(VoteWeighting.VotingModel.ASSET.getCode()).holding(Convert.parseUnsignedLong((String)string)).minBalance(1L, VoteWeighting.MinBalanceModel.ASSET.getCode()).fee(21L * ChildChain.IGNIS.ONE_COIN).build();
    }

    @Test
    public void simpleTransactionLookup() {
        String string = this.issueTestAsset();
        JSONObject jSONObject = TestCreateTwoPhased.issueCreateTwoPhased(this.byAssetApiCall(string), false);
        JSONObject jSONObject2 = TestGetAssetPhasedTransactions.phasedTransactionsApiCall(string).invoke();
        Logger.logMessage((String)("getAssetPhasedTransactionsResponse:" + jSONObject2.toJSONString()));
        JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"transactions");
        Assert.assertTrue((boolean)TwoPhasedSuite.searchForTransactionId(jSONArray, (String)jSONObject.get((Object)"fullHash")));
    }

    @Test
    public void sorting() {
        String string = this.issueTestAsset();
        for (int i = 0; i < 15; ++i) {
            TestCreateTwoPhased.issueCreateTwoPhased(this.byAssetApiCall(string), false);
        }
        JSONObject jSONObject = TestGetAssetPhasedTransactions.phasedTransactionsApiCall(string).invoke();
        Logger.logMessage((String)("getAssetPhasedTransactionsResponse:" + jSONObject.toJSONString()));
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"transactions");
        int n = Integer.MAX_VALUE;
        for (Object e : jSONArray) {
            JSONObject jSONObject2 = (JSONObject)e;
            int n2 = ((Long)jSONObject2.get((Object)"height")).intValue();
            Assert.assertTrue((n2 <= n ? 1 : 0) != 0);
            n = n2;
        }
    }

    private String issueTestAsset() {
        String string = "lz1cdqGYD";
        APICall aPICall = new APICall.Builder("issueAsset").param("secretPhrase", RIKER.getSecretPhrase()).param("name", string).param("description", "asset testing").param("quantityQNT", 10000000).param("decimals", 4).param("feeNQT", 1000L * ChildChain.IGNIS.ONE_COIN).param("deadline", 1440).build();
        aPICall.invoke();
        BlockchainTest.generateBlock();
        aPICall = new APICall.Builder("searchAssets").param("query", string).build();
        JSONObject jSONObject = aPICall.invoke();
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"assets");
        return (String)((JSONObject)jSONArray.get(0)).get((Object)"asset");
    }
}

