/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.twophased;

import nxt.BlockchainTest;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import nxt.http.twophased.TestCreateTwoPhased;
import nxt.http.twophased.TwoPhasedSuite;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestGetCurrencyPhasedTransactions
extends BlockchainTest {
    static APICall phasedTransactionsApiCall(String string) {
        return new APICall.Builder("getCurrencyPhasedTransactions").param("currency", string).param("firstIndex", 0).param("lastIndex", 20).build();
    }

    private APICall byCurrencyApiCall(String string) {
        return new TestCreateTwoPhased.TwoPhasedMoneyTransferBuilder().votingModel(VoteWeighting.VotingModel.CURRENCY.getCode()).holding(Convert.parseUnsignedLong((String)string)).minBalance(1L, VoteWeighting.MinBalanceModel.CURRENCY.getCode()).fee(21L * ChildChain.IGNIS.ONE_COIN).build();
    }

    @Test
    public void simpleTransactionLookup() {
        String string = this.issueTestCurrency();
        JSONObject jSONObject = TestCreateTwoPhased.issueCreateTwoPhased(this.byCurrencyApiCall(string), false);
        JSONObject jSONObject2 = TestGetCurrencyPhasedTransactions.phasedTransactionsApiCall(string).invoke();
        Logger.logMessage((String)("getCurrencyPhasedTransactionsResponse:" + jSONObject2.toJSONString()));
        JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"transactions");
        Assert.assertTrue((boolean)TwoPhasedSuite.searchForTransactionId(jSONArray, (String)jSONObject.get((Object)"fullHash")));
    }

    @Test
    public void sorting() {
        String string = this.issueTestCurrency();
        for (int i = 0; i < 15; ++i) {
            TestCreateTwoPhased.issueCreateTwoPhased(this.byCurrencyApiCall(string), false);
        }
        JSONObject jSONObject = TestGetCurrencyPhasedTransactions.phasedTransactionsApiCall(string).invoke();
        Logger.logMessage((String)("getCurrencyPhasedTransactionsResponse:" + jSONObject.toJSONString()));
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"transactions");
        int n = Integer.MAX_VALUE;
        for (Object e : jSONArray) {
            JSONObject jSONObject2 = (JSONObject)e;
            int n2 = ((Long)jSONObject2.get((Object)"height")).intValue();
            Assert.assertTrue((n2 <= n ? 1 : 0) != 0);
            n = n2;
        }
    }

    private String issueTestCurrency() {
        String string = "JUTST";
        APICall aPICall = new TestCurrencyIssuance.Builder().naming("JUnitTest", string, "tests currency").build();
        aPICall.invoke();
        BlockchainTest.generateBlock();
        aPICall = new APICall.Builder("getCurrency").param("code", string).build();
        JSONObject jSONObject = aPICall.invoke();
        return (String)jSONObject.get((Object)"currency");
    }
}

