/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.votingsystem;

import nxt.BlockchainTest;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.votingsystem.TestCreatePoll;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestCastVote
extends BlockchainTest {
    private String getResult(JSONArray jSONArray, int n) {
        return (String)((JSONObject)jSONArray.get(n)).get((Object)"result");
    }

    @Test
    public void validVoteCasting() {
        APICall aPICall = new TestCreatePoll.CreatePollBuilder().build();
        String string = TestCreatePoll.issueCreatePoll(aPICall, false);
        TestCastVote.generateBlock();
        aPICall = new APICall.Builder("castVote").param("secretPhrase", ALICE.getSecretPhrase()).param("poll", string).param("vote00", 1).param("vote01", 0).param("feeNQT", ChildChain.IGNIS.ONE_COIN).build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("voteCasting:" + jSONObject.toJSONString()));
        Assert.assertNull((Object)jSONObject.get((Object)"error"));
        TestCastVote.generateBlock();
        aPICall = new APICall.Builder("getPollResult").param("poll", string).build();
        JSONObject jSONObject2 = aPICall.invoke();
        Logger.logMessage((String)("getPollResultResponse:" + jSONObject2.toJSONString()));
        JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"results");
        long l = Long.parseLong(this.getResult(jSONArray, 0));
        Assert.assertEquals((long)1L, (long)l);
        long l2 = Long.parseLong(this.getResult(jSONArray, 1));
        Assert.assertEquals((long)0L, (long)l2);
        Assert.assertEquals((Object)"", (Object)this.getResult(jSONArray, 2));
    }

    @Test
    public void invalidVoteCasting() {
        APICall aPICall = new TestCreatePoll.CreatePollBuilder().build();
        String string = TestCreatePoll.issueCreatePoll(aPICall, false);
        TestCastVote.generateBlock();
        aPICall = new APICall.Builder("castVote").setParamValidation(false).param("secretPhrase", ALICE.getSecretPhrase()).param("poll", string).param("vote1", 1).param("vote2", 1).param("vote3", 1).param("feeNQT", ChildChain.IGNIS.ONE_COIN).build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("voteCasting:" + jSONObject.toJSONString()));
        Assert.assertNotNull((Object)jSONObject.get((Object)"error"));
    }
}

