/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.io.File;
import java.net.URISyntaxException;
import java.util.HashMap;
import nxt.BlockchainTest;
import nxt.DeleteFileRule;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.db.TransactionalDb;
import nxt.http.APICall;
import nxt.http.client.SetAccountPropertyBuilder;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import nxt.ms.Currency;
import nxt.ms.CurrencyFreezeMonitor;
import nxt.ms.CurrencyMigrateMonitor;
import nxt.ms.CurrencySnapshot;
import nxt.util.JSONAssert;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CurrencyMigrateMonitorTest
extends BlockchainTest {
    @Rule
    public final DeleteFileRule deleteFileRule = new DeleteFileRule();
    private final ChildChain targetChain = ChildChain.AEUR;
    private final long chuckQnt = 3L;
    private final long bobQnt = 2L;
    private Tester currencyOwner;

    @Before
    public void setUp() {
        this.currencyOwner = TestCurrencyIssuance.Builder.creator;
    }

    @Test
    public void migratesCurrencyToChildChainWithoutSnapshot() {
        Currency currency = this.createCurrencyWithBalances();
        CurrencyMigrateMonitorTest.generateBlock();
        int n = this.getHeight();
        this.setCurrencyFreezeHeight(currency, n);
        this.setCurrencyMigrationHeight(currency, this.getHeight() + 1);
        CurrencyMigrateMonitorTest.generateBlock();
        this.assertTokensDistributed();
    }

    @Test
    public void migratesCurrencyToChildChainTriggeredByAlias() {
        Currency currency = this.createCurrencyWithBalances();
        CurrencyMigrateMonitorTest.generateBlock();
        int n = this.getHeight();
        this.setCurrencyFreezeHeight(currency, n);
        this.setCurrencyMigrationHeight(currency, 0);
        this.setCurrencyMigrationHeightAccountProperty(currency, n + 2);
        CurrencyMigrateMonitorTest.generateBlock();
        CurrencyMigrateMonitorTest.generateBlock();
        this.assertTokensDistributed();
    }

    private void setCurrencyMigrationHeightAccountProperty(Currency currency, int n) {
        String string = "Migrate" + Long.toUnsignedString(currency.getId());
        String string2 = Integer.toString(n);
        ChildChain childChain = ChildChain.IGNIS;
        new SetAccountPropertyBuilder(ALICE, string, string2).setFeeNQT(childChain.ONE_COIN).invokeNoError();
    }

    @Test
    public void migratesCurrencyToChildChainUsingSnapshot() throws URISyntaxException {
        Currency currency = this.createCurrency();
        CurrencyMigrateMonitorTest.generateBlock();
        int n = this.getHeight();
        this.setCurrencyFreezeHeight(currency, n);
        this.createFakeSnapshot(currency, n);
        this.setCurrencyMigrationHeight(currency, this.getHeight() + 1);
        CurrencyMigrateMonitorTest.generateBlock();
        this.assertTokensDistributed();
    }

    private void createFakeSnapshot(Currency currency, int n) throws URISyntaxException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put(Long.toUnsignedString(BOB.getId()), 2L);
        hashMap.put(Long.toUnsignedString(CHUCK.getId()), 3L);
        File file = new CurrencySnapshot().writeSnapshot(hashMap, currency.getId(), n);
        this.deleteFileRule.addFile(file);
        this.deleteFileRule.moveToTestClasspath(file);
    }

    private void assertTokensDistributed() {
        Assert.assertEquals((long)2L, (long)BOB.getChainBalanceDiff(this.targetChain.getId()));
        Assert.assertEquals((long)3L, (long)CHUCK.getChainBalanceDiff(this.targetChain.getId()));
    }

    private void setCurrencyMigrationHeight(Currency currency, int n) {
        TransactionalDb.runInDbTransaction(() -> CurrencyMigrateMonitor.enableMigration((long)currency.getId(), (ChildChain)this.targetChain, (int)0, (int)n));
    }

    private APICall createTransferCurrencyCall(Tester tester, Currency currency, long l) {
        return new APICall.Builder("transferCurrency").param("secretPhrase", this.currencyOwner.getSecretPhrase()).param("currency", Long.toUnsignedString(currency.getId())).param("recipient", tester.getStrId()).param("unitsQNT", l).feeNQT(ChildChain.IGNIS.ONE_COIN).build();
    }

    private JSONObject getOffers(String string, Currency currency) {
        return new APICall.Builder(string).param("currency", Long.toUnsignedString(currency.getId())).build().invokeNoError();
    }

    private void setCurrencyFreezeHeight(Currency currency, int n) {
        TransactionalDb.runInDbTransaction(() -> CurrencyFreezeMonitor.enableFreeze((long)currency.getId(), (int)1, (int)n));
    }

    private Currency createCurrencyWithBalances() {
        Currency currency = this.createCurrency();
        this.distributeCurrency(currency);
        return currency;
    }

    private void distributeCurrency(Currency currency) {
        this.createTransferCurrencyCall(BOB, currency, 2L).invokeNoError();
        this.createTransferCurrencyCall(CHUCK, currency, 3L).invokeNoError();
        CurrencyMigrateMonitorTest.generateBlock();
    }

    private Currency createCurrency() {
        JSONObject jSONObject = new TestCurrencyIssuance.Builder().build().invokeNoError();
        String string = Tester.hexFullHashToStringId(new JSONAssert(jSONObject).str("fullHash"));
        CurrencyMigrateMonitorTest.generateBlock();
        return Currency.getCurrency((long)Long.parseUnsignedLong(string));
    }
}

