/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import nxt.util.BooleanExpression;
import nxt.util.Logger;
import org.junit.Assert;
import org.junit.Test;

public class BooleanExpressionTest {
    @Test
    public void testAnd() throws BooleanExpression.BadSyntaxException {
        BooleanExpression booleanExpression = this.parseExpression("A & B", null);
        Assert.assertEquals((Object)BooleanExpression.Value.TRUE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.TRUE), BooleanExpressionTest.val("B", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.FALSE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.FALSE), BooleanExpressionTest.val("B", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.FALSE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.TRUE), BooleanExpressionTest.val("B", BooleanExpression.Value.FALSE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.FALSE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.FALSE), BooleanExpressionTest.val("B", BooleanExpression.Value.FALSE)).collect(BooleanExpressionTest.valuesToMap())));
    }

    @Test
    public void testOr() throws BooleanExpression.BadSyntaxException {
        BooleanExpression booleanExpression = this.parseExpression("A | B", null);
        Assert.assertEquals((Object)BooleanExpression.Value.TRUE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.TRUE), BooleanExpressionTest.val("B", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.TRUE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.FALSE), BooleanExpressionTest.val("B", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.TRUE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.TRUE), BooleanExpressionTest.val("B", BooleanExpression.Value.FALSE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.FALSE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.FALSE), BooleanExpressionTest.val("B", BooleanExpression.Value.FALSE)).collect(BooleanExpressionTest.valuesToMap())));
    }

    @Test
    public void testNot() throws BooleanExpression.BadSyntaxException {
        BooleanExpression booleanExpression = this.parseExpression("!A", null);
        Assert.assertEquals((Object)BooleanExpression.Value.FALSE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.TRUE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.FALSE)).collect(BooleanExpressionTest.valuesToMap())));
    }

    @Test
    public void testTwoOccurrencesOfVariable() throws BooleanExpression.BadSyntaxException {
        BooleanExpression booleanExpression = this.parseExpression("A1 & B2 | !C3 & A1", null);
        Assert.assertEquals((Object)BooleanExpression.Value.FALSE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A1", BooleanExpression.Value.FALSE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.TRUE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A1", BooleanExpression.Value.TRUE), BooleanExpressionTest.val("B2", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.TRUE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A1", BooleanExpression.Value.TRUE), BooleanExpressionTest.val("C3", BooleanExpression.Value.FALSE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.UNKNOWN, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("B2", BooleanExpression.Value.TRUE), BooleanExpressionTest.val("C3", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
    }

    @Test
    public void testComplexExpression() throws BooleanExpression.BadSyntaxException {
        BooleanExpression booleanExpression = this.parseExpression("A & !C | !A & B", null);
        Assert.assertEquals((Object)BooleanExpression.Value.UNKNOWN, (Object)booleanExpression.evaluate(Collections.emptyMap()));
        Assert.assertEquals((Object)BooleanExpression.Value.UNKNOWN, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.FALSE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.UNKNOWN, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("B", BooleanExpression.Value.FALSE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.UNKNOWN, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("C", BooleanExpression.Value.FALSE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.UNKNOWN, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.UNKNOWN, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("B", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.UNKNOWN, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("C", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.UNKNOWN, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("B", BooleanExpression.Value.TRUE), BooleanExpressionTest.val("C", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.UNKNOWN, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.FALSE), BooleanExpressionTest.val("C", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.FALSE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.TRUE), BooleanExpressionTest.val("C", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.TRUE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.TRUE), BooleanExpressionTest.val("C", BooleanExpression.Value.FALSE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.FALSE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.FALSE), BooleanExpressionTest.val("B", BooleanExpression.Value.FALSE)).collect(BooleanExpressionTest.valuesToMap())));
        Assert.assertEquals((Object)BooleanExpression.Value.TRUE, (Object)booleanExpression.evaluate(Stream.of(BooleanExpressionTest.val("A", BooleanExpression.Value.FALSE), BooleanExpressionTest.val("B", BooleanExpression.Value.TRUE)).collect(BooleanExpressionTest.valuesToMap())));
    }

    @Test
    public void testInfixOperators() {
        this.parseExpression("A &", (BooleanExpression.BooleanExpressionException)new BooleanExpression.BadSyntaxException(3, BooleanExpression.SyntaxError.LITERAL_EXPECTED, new Object[0]));
        this.parseExpression("A & B | & C", (BooleanExpression.BooleanExpressionException)new BooleanExpression.BadSyntaxException(8, BooleanExpression.SyntaxError.LITERAL_EXPECTED, new Object[0]));
        this.parseExpression("A & B C", (BooleanExpression.BooleanExpressionException)new BooleanExpression.BadSyntaxException(6, BooleanExpression.SyntaxError.OPERATOR_OR_AND_EXPECTED, new Object[0]));
    }

    @Test
    public void testNegation() {
        this.parseExpression("A & ! &", (BooleanExpression.BooleanExpressionException)new BooleanExpression.BadSyntaxException(6, BooleanExpression.SyntaxError.VARIABLE_EXPECTED, new Object[0]));
        this.parseExpression("A & B ! | C", (BooleanExpression.BooleanExpressionException)new BooleanExpression.BadSyntaxException(6, BooleanExpression.SyntaxError.UNEXPECTED_NEGATION, new Object[0]));
    }

    @Test
    public void testVariable() {
        this.parseExpression("A & !0", (BooleanExpression.BooleanExpressionException)new BooleanExpression.BadSyntaxException(5, BooleanExpression.SyntaxError.DIGIT_AT_VARIABLE_START, new Object[0]));
        this.parseExpression("A & (!A)", (BooleanExpression.BooleanExpressionException)new BooleanExpression.BadSyntaxException(4, BooleanExpression.SyntaxError.ILLEGAL_CHARACTER, new Object[]{Character.valueOf('('), 40}));
    }

    @Test
    public void testDuplicateLiterals() {
        this.checkOptimality("B | A & A & A", new BooleanExpression.SemanticWarning(7, BooleanExpression.SemanticWarningType.DUPLICATE_LITERAL, new Object[]{" A ", " A & A & A"}));
        this.checkOptimality("A | A | B", new BooleanExpression.SemanticWarning(0, BooleanExpression.SemanticWarningType.ABSORPTION_2_POSSIBLE, new Object[]{"A ", " A ", 3}));
    }

    @Test
    public void testPreEvaluations() {
        this.checkOptimality("C1 | A & !A & F | B", new BooleanExpression.SemanticWarning(8, BooleanExpression.SemanticWarningType.CONJUNCTION_ALWAYS_FALSE, new Object[]{" A & !A & F ", "A"}));
        this.checkOptimality("A | !A | B", new BooleanExpression.SemanticWarning(3, BooleanExpression.SemanticWarningType.DISJUNCTION_ALWAYS_TRUE, new Object[]{"A"}));
    }

    @Test
    public void testAbsorptionLaw() {
        this.checkOptimality("E & F | !A & B & !C | B & !C", new BooleanExpression.SemanticWarning(7, BooleanExpression.SemanticWarningType.ABSORPTION_2_POSSIBLE, new Object[]{" !A & B & !C ", " B & !C", 21}));
        this.checkOptimality("E & F | !A & B & C | B & !C", null);
    }

    @Test
    public void testDistributionOfOr() {
        this.checkOptimality("A | !A & B & !C | D", new BooleanExpression.SemanticWarning(3, BooleanExpression.SemanticWarningType.DISTRIBUTIVITY_OF_OR_POSSIBLE, new Object[]{"A", "!A & B & !C", "B & !C"}));
        this.checkOptimality("!A & B & !C | !B | D", new BooleanExpression.SemanticWarning(0, BooleanExpression.SemanticWarningType.DISTRIBUTIVITY_OF_OR_POSSIBLE, new Object[]{"!B", "!A & B & !C", "!A & !C"}));
    }

    @Test
    public void testImplicationCheck() throws BooleanExpression.BadSyntaxException {
        Assert.assertTrue((boolean)BooleanExpression.fastImplicationCheck((BooleanExpression)this.parseExpression("A & B & C & X & !Z"), (BooleanExpression)this.parseExpression("A & B & C")));
        Assert.assertFalse((boolean)BooleanExpression.fastImplicationCheck((BooleanExpression)this.parseExpression("A & B & C"), (BooleanExpression)this.parseExpression("A & B & C & D")));
        Assert.assertTrue((boolean)BooleanExpression.fastImplicationCheck((BooleanExpression)this.parseExpression("A & B & C"), (BooleanExpression)this.parseExpression("A & B | D")));
        Assert.assertFalse((boolean)BooleanExpression.fastImplicationCheck((BooleanExpression)this.parseExpression("A & B | C"), (BooleanExpression)this.parseExpression("A & B")));
        Assert.assertTrue((boolean)BooleanExpression.fastImplicationCheck((BooleanExpression)this.parseExpression("A & !B & !X | C & Y"), (BooleanExpression)this.parseExpression("A & !B | C")));
        Assert.assertFalse((boolean)BooleanExpression.fastImplicationCheck((BooleanExpression)this.parseExpression("A & !B & !X | C & Y"), (BooleanExpression)this.parseExpression("A & !B | !C")));
        Assert.assertFalse((boolean)BooleanExpression.fastImplicationCheck((BooleanExpression)this.parseExpression("A & !A"), (BooleanExpression)this.parseExpression("B")));
        Assert.assertFalse((boolean)BooleanExpression.fastImplicationCheck((BooleanExpression)this.parseExpression("A"), (BooleanExpression)this.parseExpression("B | !B")));
        Assert.assertFalse((boolean)BooleanExpression.fastImplicationCheck((BooleanExpression)this.parseExpression("A"), (BooleanExpression)this.parseExpression("B & C | B & !C | !B & C | !B & !C")));
        Assert.assertFalse((boolean)BooleanExpression.fastImplicationCheck((BooleanExpression)this.parseExpression("B | C"), (BooleanExpression)this.parseExpression("B & C | B & !C | !B & C")));
    }

    private BooleanExpression parseExpression(String string) {
        return this.parseExpression(string, null);
    }

    private BooleanExpression parseExpression(String string, BooleanExpression.BooleanExpressionException booleanExpressionException) {
        BooleanExpression booleanExpression = new BooleanExpression(string);
        BooleanExpression.BadSyntaxException badSyntaxException = booleanExpression.getSyntaxException();
        if (badSyntaxException == null) {
            if (booleanExpressionException != null) {
                Assert.fail((String)"BooleanException expected but not thrown");
            }
        } else {
            Logger.logMessage((String)("BooleanException " + badSyntaxException.getMessage() + " at position " + badSyntaxException.getPosition()));
            Logger.logMessage((String)string);
            Logger.logMessage((String)(IntStream.range(0, badSyntaxException.getPosition()).boxed().map(n -> "-").collect(Collectors.joining()) + "^"));
            if (booleanExpressionException == null) {
                throw new AssertionError("Unexpected error at position " + badSyntaxException.getPosition(), (Throwable)badSyntaxException);
            }
            Assert.assertEquals((String)"Message mismatch", (Object)booleanExpressionException.getMessage(), (Object)badSyntaxException.getMessage());
            Assert.assertEquals((String)"Position mismatch", (long)booleanExpressionException.getPosition(), (long)badSyntaxException.getPosition());
            return null;
        }
        return booleanExpression;
    }

    private void checkOptimality(String string, BooleanExpression.SemanticWarning semanticWarning) {
        BooleanExpression booleanExpression = new BooleanExpression(string);
        if (booleanExpression.getSemanticWarnings().isEmpty()) {
            if (semanticWarning != null) {
                throw new AssertionError((Object)("Expected semantic warning not thrown: " + semanticWarning));
            }
        } else {
            BooleanExpression.SemanticWarning semanticWarning2 = (BooleanExpression.SemanticWarning)booleanExpression.getSemanticWarnings().get(0);
            Assert.assertEquals((Object)semanticWarning, (Object)semanticWarning2);
        }
    }

    private static <K, V> Map.Entry<K, V> val(K k, V v) {
        return new AbstractMap.SimpleEntry<K, V>(k, v);
    }

    private static <K, U> Collector<Map.Entry<K, U>, ?, Map<K, U>> valuesToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }
}

