/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;
import nxt.util.Convert;
import nxt.util.Logger;
import org.junit.Assert;
import org.junit.Test;

public class ConvertTest {
    private static final int ITERATIONS = 100000000;

    @Test
    public void testLongValueExact() {
        BigInteger bigInteger = new BigInteger("9223372036854775807");
        BigInteger bigInteger2 = new BigInteger("-9223372036854775808");
        BigInteger bigInteger3 = BigInteger.ZERO;
        Assert.assertEquals((long)bigInteger3.longValueExact(), (long)this.androidLongValueExact(bigInteger3));
        bigInteger3 = BigInteger.ONE;
        Assert.assertEquals((long)bigInteger3.longValueExact(), (long)this.androidLongValueExact(bigInteger3));
        bigInteger3 = BigInteger.ZERO.subtract(BigInteger.ONE);
        Assert.assertEquals((long)bigInteger3.longValueExact(), (long)this.androidLongValueExact(bigInteger3));
        bigInteger3 = bigInteger;
        Assert.assertEquals((long)bigInteger3.longValueExact(), (long)this.androidLongValueExact(bigInteger3));
        bigInteger3 = bigInteger2;
        Assert.assertEquals((long)bigInteger3.longValueExact(), (long)this.androidLongValueExact(bigInteger3));
        bigInteger3 = new BigInteger("-2147483648");
        Assert.assertEquals((long)bigInteger3.longValueExact(), (long)this.androidLongValueExact(bigInteger3));
        bigInteger3 = new BigInteger("-2147483648").subtract(BigInteger.ONE);
        Assert.assertEquals((long)bigInteger3.longValueExact(), (long)this.androidLongValueExact(bigInteger3));
        bigInteger3 = new BigInteger("2147483647");
        Assert.assertEquals((long)bigInteger3.longValueExact(), (long)this.androidLongValueExact(bigInteger3));
        bigInteger3 = new BigInteger("2147483647").add(BigInteger.ONE);
        Assert.assertEquals((long)bigInteger3.longValueExact(), (long)this.androidLongValueExact(bigInteger3));
        Assert.assertEquals((Object)this.isLongValueExactOverflow(BigInteger.ONE), (Object)this.isAndroidLongValueExactOverflow(BigInteger.ONE));
        Assert.assertEquals((Object)this.isLongValueExactOverflow(bigInteger.add(BigInteger.ONE)), (Object)this.isAndroidLongValueExactOverflow(bigInteger.add(BigInteger.ONE)));
        Assert.assertEquals((Object)this.isLongValueExactOverflow(bigInteger.multiply(bigInteger)), (Object)this.isAndroidLongValueExactOverflow(bigInteger.multiply(bigInteger)));
        Assert.assertEquals((Object)this.isLongValueExactOverflow(bigInteger2.subtract(BigInteger.ONE)), (Object)this.isAndroidLongValueExactOverflow(bigInteger2.subtract(BigInteger.ONE)));
        Assert.assertEquals((Object)this.isLongValueExactOverflow(bigInteger2.multiply(bigInteger2)), (Object)this.isAndroidLongValueExactOverflow(bigInteger2.multiply(bigInteger2)));
        Assert.assertEquals((Object)this.isLongValueExactOverflow(bigInteger2.multiply(bigInteger)), (Object)this.isAndroidLongValueExactOverflow(bigInteger2.multiply(bigInteger)));
    }

    private long androidLongValueExact(BigInteger bigInteger) {
        long l = bigInteger.longValue();
        if (BigInteger.valueOf(l).equals(bigInteger)) {
            return l;
        }
        throw new ArithmeticException("BigInteger out of long range");
    }

    private boolean isLongValueExactOverflow(BigInteger bigInteger) {
        try {
            bigInteger.longValueExact();
            return false;
        }
        catch (ArithmeticException arithmeticException) {
            return true;
        }
    }

    private boolean isAndroidLongValueExactOverflow(BigInteger bigInteger) {
        try {
            this.androidLongValueExact(bigInteger);
            return false;
        }
        catch (ArithmeticException arithmeticException) {
            return true;
        }
    }

    @Test
    public void fullHashToIdOptimization() {
        Random random = new Random();
        byte[] byArray = new byte[32];
        random.nextBytes(byArray);
        long l = System.nanoTime();
        long l2 = 0L;
        for (int i = 0; i < 100000000; ++i) {
            l2 += Convert.fullHashToId((byte[])byArray);
        }
        long l3 = System.nanoTime() - l;
        l = System.nanoTime();
        long l4 = 0L;
        for (int i = 0; i < 100000000; ++i) {
            l4 += ConvertTest.fullHashToIdOld(byArray);
        }
        long l5 = System.nanoTime() - l;
        Assert.assertEquals((long)l2, (long)l4);
        Logger.logInfoMessage((String)"fullHashToIdOptimization new time %f old time %f factor %f", (Object[])new Object[]{Float.valueOf((float)l3 / 1.0E9f), Float.valueOf((float)l5 / 1.0E9f), Float.valueOf((float)l5 / (float)l3)});
    }

    private static long fullHashToIdOld(byte[] byArray) {
        if (byArray == null || byArray.length < 8) {
            throw new IllegalArgumentException("Invalid hash: " + Arrays.toString(byArray));
        }
        BigInteger bigInteger = new BigInteger(1, new byte[]{byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0]});
        return bigInteger.longValue();
    }
}

