/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import nxt.Constants;
import nxt.util.Convert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class EpochTimeTest {
    private static final int testTime = 1333920;

    @Test
    public void testFromEpochTimeProd() {
        Assume.assumeFalse((boolean)Constants.isTestnet);
        long l = Convert.fromEpochTime((int)1333920);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Assert.assertEquals((Object)"16/01/2018 10:31:59", (Object)simpleDateFormat.format(new Date(l)));
    }

    @Test
    public void testFromToEpochTimeRoundTrip() {
        long l = Convert.fromEpochTime((int)1333920);
        Assert.assertEquals((long)1333920L, (long)Convert.toEpochTime((long)l));
    }

    @Test
    public void testFromEpochTimeTestNet() {
        Assume.assumeTrue((boolean)Constants.isTestnet);
        long l = Convert.fromEpochTime((int)1333920);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Assert.assertEquals((Object)"11/01/2018 12:31:59", (Object)simpleDateFormat.format(new Date(l)));
    }
}

