/*
 * Copyright © 2016-2019 Jelurida IP B.V.
 *
 * See the LICENSE.txt file at the top-level directory of this distribution
 * for licensing information.
 *
 * Unless otherwise agreed in a custom licensing agreement with Jelurida B.V.,
 * no part of this software, including this file, may be copied, modified,
 * propagated, or distributed except according to the terms contained in the
 * LICENSE.txt file.
 *
 * Removal or modification of this copyright notice is prohibited.
 *
 */

package com.jelurida.ardor.contracts;

import nxt.addons.JO;
import nxt.http.callers.SetAccountPropertyCall;
import org.junit.Test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ForgingRewardTest extends AbstractContractTest {

    @Test
    public void forgingReward() {
        JO setupParams = new JO();
        setupParams.put("interval", 5);
        setupParams.put("isRewardNxt", "false");
        ContractTestHelper.deployContract(ForgingReward.class, setupParams, false);
        ContractTestHelper.deployContract(DistributedRandomNumberGenerator.class);

        // Forgy applies for the reward
        SetAccountPropertyCall.create(2).property("ForgingReward").secretPhrase(FORGY.getSecretPhrase()).feeNQT(100000000).call();
        generateBlock(RIKER);
        generateBlock(FORGY);
        generateBlock(RIKER); // Reward is submitted now (genesis block generated by RIKER and block 1 by FORGY when deploying the contract
        generateBlock(FORGY); // This block includes the reward (already counted toward next reward)

        // Check that a reward transaction was credited to forgy
        ContractTestHelper.testChildTransaction(2, 0, 0, 498000000, 2000000, ALICE.getAccount().getId(), Collections.singletonList(FORGY.getId()));

        // Riker applies for the reward
        SetAccountPropertyCall.create(2).property("ForgingReward").secretPhrase(RIKER.getSecretPhrase()).feeNQT(100000000).call();
        generateBlock(FORGY);
        generateBlock(RIKER);
        generateBlock(FORGY);
        generateBlock(RIKER); // Reward is submitted now
        generateBlock(RIKER); // This block includes the reward

        // Check that a reward transaction was credited to forgy or riker
        List<Long> recipients = new ArrayList<>(Arrays.asList(RIKER.getId(), FORGY.getId()));
        ContractTestHelper.testChildTransaction(2, 0, 0, 498000000, 2000000, ALICE.getAccount().getId(), recipients);
    }

}
