/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;
import org.languagetool.synthesis.ManualSynthesizer;
import org.languagetool.synthesis.Soros;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.SynthesizerTools;

public class BaseSynthesizer
implements Synthesizer {
    public final String SPELLNUMBER_TAG = "_spell_number_";
    protected volatile List<String> possibleTags;
    private final String tagFileName;
    private final String resourceFileName;
    private final IStemmer stemmer;
    private final ManualSynthesizer manualSynthesizer;
    private final ManualSynthesizer removalSynthesizer;
    private final ManualSynthesizer removalSynthesizer2;
    private final String sorosFileName;
    private final Soros numberSpeller;
    private volatile Dictionary dictionary;

    public BaseSynthesizer(String sorosFileName, String resourceFileName, String tagFileName, Language lang) {
        block43: {
            this.SPELLNUMBER_TAG = "_spell_number_";
            this.resourceFileName = resourceFileName;
            this.tagFileName = tagFileName;
            this.stemmer = this.createStemmer();
            this.sorosFileName = sorosFileName;
            this.numberSpeller = this.createNumberSpeller(lang.getShortCode());
            try {
                String path = "/" + lang.getShortCode() + "/added.txt";
                if (JLanguageTool.getDataBroker().resourceExists(path)) {
                    try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(path);){
                        this.manualSynthesizer = new ManualSynthesizer(stream);
                    }
                } else {
                    this.manualSynthesizer = null;
                }
                String removalPath = "/" + lang.getShortCode() + "/removed.txt";
                if (JLanguageTool.getDataBroker().resourceExists(removalPath)) {
                    try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(removalPath);){
                        this.removalSynthesizer = new ManualSynthesizer(stream);
                    }
                } else {
                    this.removalSynthesizer = null;
                }
                String removalPath2 = "/" + lang.getShortCode() + "/do-not-synthesize.txt";
                if (JLanguageTool.getDataBroker().resourceExists(removalPath2)) {
                    try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(removalPath2);){
                        this.removalSynthesizer2 = new ManualSynthesizer(stream);
                        break block43;
                    }
                }
                this.removalSynthesizer2 = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public BaseSynthesizer(String resourceFileName, String tagFileName, Language lang) {
        this(null, resourceFileName, tagFileName, lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dictionary getDictionary() throws IOException {
        Dictionary dict = this.dictionary;
        if (dict == null) {
            BaseSynthesizer baseSynthesizer = this;
            synchronized (baseSynthesizer) {
                dict = this.dictionary;
                if (dict == null) {
                    this.dictionary = dict = MorfologikSpeller.getDictionaryWithCaching(this.resourceFileName);
                }
            }
        }
        return dict;
    }

    protected IStemmer createStemmer() {
        try {
            return new DictionaryLookup(this.getDictionary());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load dictionary", e);
        }
    }

    private Soros createNumberSpeller(String langcode) {
        Soros s;
        try {
            String line;
            URL url = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(this.sorosFileName);
            BufferedReader f = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            StringBuffer st = new StringBuffer();
            while ((line = f.readLine()) != null) {
                st.append(line);
                st.append('\n');
            }
            s = new Soros(new String(st), langcode);
        }
        catch (Exception e) {
            return null;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> lookup(String lemma, String posTag) {
        List<String> removeForms;
        List<String> manualForms;
        ArrayList<String> results = new ArrayList<String>();
        BaseSynthesizer baseSynthesizer = this;
        synchronized (baseSynthesizer) {
            List wordForms = this.stemmer.lookup((CharSequence)(lemma + "|" + posTag));
            for (WordData wd : wordForms) {
                results.add(wd.getStem().toString());
            }
        }
        if (this.manualSynthesizer != null && (manualForms = this.manualSynthesizer.lookup(lemma, posTag)) != null) {
            results.addAll(manualForms);
        }
        if (this.removalSynthesizer != null && (removeForms = this.removalSynthesizer.lookup(lemma, posTag)) != null) {
            results.removeAll(removeForms);
        }
        if (this.removalSynthesizer2 != null && (removeForms = this.removalSynthesizer2.lookup(lemma, posTag)) != null) {
            results.removeAll(removeForms);
        }
        return results;
    }

    @Override
    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        if (posTag.equals("_spell_number_")) {
            return new String[]{this.getSpelledNumber(token.getToken())};
        }
        List<String> wordForms = this.lookup(token.getLemma(), posTag);
        return this.removeExceptions(wordForms.toArray(new String[0]));
    }

    @Override
    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        if (posTagRegExp) {
            try {
                Pattern p = Pattern.compile(posTag);
                return this.synthesizeForPosTags(token.getLemma(), tag -> p.matcher((CharSequence)tag).matches());
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException("Error trying to synthesize POS tag " + posTag + " (posTagRegExp: " + posTagRegExp + ") from token " + token.getToken(), e);
            }
        }
        return this.removeExceptions(this.synthesize(token, posTag));
    }

    public String[] synthesizeForPosTags(String lemma, Predicate<String> acceptTag) throws IOException {
        this.initPossibleTags();
        ArrayList<String> results = new ArrayList<String>();
        for (String tag : this.possibleTags) {
            if (!acceptTag.test(tag)) continue;
            results.addAll(this.lookup(lemma, tag));
        }
        return this.removeExceptions(results.toArray(new String[0]));
    }

    @Override
    public String getPosTagCorrection(String posTag) {
        return posTag;
    }

    public IStemmer getStemmer() {
        return this.stemmer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPossibleTags() throws IOException {
        if (this.possibleTags == null) {
            BaseSynthesizer baseSynthesizer = this;
            synchronized (baseSynthesizer) {
                if (this.possibleTags == null) {
                    this.possibleTags = this.loadTags();
                }
            }
        }
    }

    private List<String> loadTags() throws IOException {
        List<String> tags;
        try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(this.tagFileName);){
            tags = SynthesizerTools.loadWords(stream);
        }
        if (this.manualSynthesizer != null) {
            for (String tag : this.manualSynthesizer.getPossibleTags()) {
                if (tags.contains(tag)) continue;
                tags.add(tag);
            }
        }
        return tags;
    }

    @Override
    public String getSpelledNumber(String arabicNumeral) {
        if (this.numberSpeller != null) {
            return this.numberSpeller.run(arabicNumeral);
        }
        return arabicNumeral;
    }

    protected boolean isException(String w) {
        return false;
    }

    protected String[] removeExceptions(String[] words) {
        ArrayList<String> results = new ArrayList<String>();
        for (String word : words) {
            if (this.isException(word)) continue;
            results.add(word);
        }
        return results.toArray(new String[0]);
    }
}

