/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import nxt.Attachment;
import nxt.Currency;
import nxt.CurrencyMinting;
import nxt.MonetarySystem;
import nxt.NxtException;
import nxt.ShufflingTransaction;
import nxt.Transaction;
import nxt.crypto.HashFunction;

public enum CurrencyType {
    EXCHANGEABLE(1){

        @Override
        void validate(Currency currency, Transaction transaction, Set<CurrencyType> set) {
        }

        @Override
        void validateMissing(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.NotValidException {
            if (transaction.getType() == MonetarySystem.CURRENCY_ISSUANCE && !set.contains((Object)CLAIMABLE)) {
                throw new NxtException.NotValidException("Currency is not exchangeable and not claimable");
            }
            if (transaction.getType() instanceof MonetarySystem.MonetarySystemExchange || transaction.getType() == MonetarySystem.PUBLISH_EXCHANGE_OFFER) {
                throw new NxtException.NotValidException("Currency is not exchangeable");
            }
        }
    }
    ,
    CONTROLLABLE(2){

        @Override
        void validate(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.NotValidException {
            if (transaction.getType() == MonetarySystem.CURRENCY_TRANSFER && (currency == null || currency.getAccountId() != transaction.getSenderId() && currency.getAccountId() != transaction.getRecipientId())) {
                throw new NxtException.NotValidException("Controllable currency can only be transferred to/from issuer account");
            }
            if (transaction.getType() == MonetarySystem.PUBLISH_EXCHANGE_OFFER && (currency == null || currency.getAccountId() != transaction.getSenderId())) {
                throw new NxtException.NotValidException("Only currency issuer can publish an exchange offer for controllable currency");
            }
        }

        @Override
        void validateMissing(Currency currency, Transaction transaction, Set<CurrencyType> set) {
        }
    }
    ,
    RESERVABLE(4){

        @Override
        void validate(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.ValidationException {
            Attachment.AbstractAttachment abstractAttachment;
            if (transaction.getType() == MonetarySystem.CURRENCY_ISSUANCE) {
                int n;
                abstractAttachment = (Attachment.MonetarySystemCurrencyIssuance)transaction.getAttachment();
                int n2 = ((Attachment.MonetarySystemCurrencyIssuance)abstractAttachment).getIssuanceHeight();
                if (n2 <= (n = abstractAttachment.getFinishValidationHeight(transaction))) {
                    throw new NxtException.NotCurrentlyValidException(String.format("Reservable currency activation height %d not higher than transaction apply height %d", n2, n));
                }
                if (((Attachment.MonetarySystemCurrencyIssuance)abstractAttachment).getMinReservePerUnitNQT() <= 0L) {
                    throw new NxtException.NotValidException("Minimum reserve per unit must be > 0");
                }
                if (Math.multiplyExact(((Attachment.MonetarySystemCurrencyIssuance)abstractAttachment).getMinReservePerUnitNQT(), ((Attachment.MonetarySystemCurrencyIssuance)abstractAttachment).getReserveSupply()) > 100000000000000000L) {
                    throw new NxtException.NotValidException("Minimum reserve per unit is too large");
                }
                if (((Attachment.MonetarySystemCurrencyIssuance)abstractAttachment).getReserveSupply() <= ((Attachment.MonetarySystemCurrencyIssuance)abstractAttachment).getInitialSupply()) {
                    throw new NxtException.NotValidException("Reserve supply must exceed initial supply");
                }
                if (!set.contains((Object)MINTABLE) && ((Attachment.MonetarySystemCurrencyIssuance)abstractAttachment).getReserveSupply() < ((Attachment.MonetarySystemCurrencyIssuance)abstractAttachment).getMaxSupply()) {
                    throw new NxtException.NotValidException("Max supply must not exceed reserve supply for reservable and non-mintable currency");
                }
            }
            if (transaction.getType() == MonetarySystem.RESERVE_INCREASE) {
                abstractAttachment = (Attachment.MonetarySystemReserveIncrease)transaction.getAttachment();
                if (currency != null && currency.getIssuanceHeight() <= abstractAttachment.getFinishValidationHeight(transaction)) {
                    throw new NxtException.NotCurrentlyValidException("Cannot increase reserve for active currency");
                }
            }
        }

        @Override
        void validateMissing(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.NotValidException {
            if (transaction.getType() == MonetarySystem.RESERVE_INCREASE) {
                throw new NxtException.NotValidException("Cannot increase reserve since currency is not reservable");
            }
            if (transaction.getType() == MonetarySystem.CURRENCY_ISSUANCE) {
                Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance = (Attachment.MonetarySystemCurrencyIssuance)transaction.getAttachment();
                if (monetarySystemCurrencyIssuance.getIssuanceHeight() != 0) {
                    throw new NxtException.NotValidException("Issuance height for non-reservable currency must be 0");
                }
                if (monetarySystemCurrencyIssuance.getMinReservePerUnitNQT() > 0L) {
                    throw new NxtException.NotValidException("Minimum reserve per unit for non-reservable currency must be 0 ");
                }
                if (monetarySystemCurrencyIssuance.getReserveSupply() > 0L) {
                    throw new NxtException.NotValidException("Reserve supply for non-reservable currency must be 0");
                }
                if (!set.contains((Object)MINTABLE) && monetarySystemCurrencyIssuance.getInitialSupply() < monetarySystemCurrencyIssuance.getMaxSupply()) {
                    throw new NxtException.NotValidException("Initial supply for non-reservable and non-mintable currency must be equal to max supply");
                }
            }
        }
    }
    ,
    CLAIMABLE(8){

        @Override
        void validate(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.ValidationException {
            if (transaction.getType() == MonetarySystem.CURRENCY_ISSUANCE) {
                Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance = (Attachment.MonetarySystemCurrencyIssuance)transaction.getAttachment();
                if (!set.contains((Object)RESERVABLE)) {
                    throw new NxtException.NotValidException("Claimable currency must be reservable");
                }
                if (set.contains((Object)MINTABLE)) {
                    throw new NxtException.NotValidException("Claimable currency cannot be mintable");
                }
                if (monetarySystemCurrencyIssuance.getInitialSupply() > 0L) {
                    throw new NxtException.NotValidException("Claimable currency must have initial supply 0");
                }
            }
            if (!(transaction.getType() != MonetarySystem.RESERVE_CLAIM || currency != null && currency.isActive())) {
                throw new NxtException.NotCurrentlyValidException("Cannot claim reserve since currency is not yet active");
            }
        }

        @Override
        void validateMissing(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.NotValidException {
            if (transaction.getType() == MonetarySystem.RESERVE_CLAIM) {
                throw new NxtException.NotValidException("Cannot claim reserve since currency is not claimable");
            }
        }
    }
    ,
    MINTABLE(16){

        @Override
        void validate(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.NotValidException {
            if (transaction.getType() == MonetarySystem.CURRENCY_ISSUANCE) {
                Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance = (Attachment.MonetarySystemCurrencyIssuance)transaction.getAttachment();
                try {
                    HashFunction hashFunction = HashFunction.getHashFunction(monetarySystemCurrencyIssuance.getAlgorithm());
                    if (!CurrencyMinting.acceptedHashFunctions.contains((Object)hashFunction)) {
                        throw new NxtException.NotValidException("Invalid minting algorithm " + (Object)((Object)hashFunction));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new NxtException.NotValidException("Illegal algorithm code specified", illegalArgumentException);
                }
                if (monetarySystemCurrencyIssuance.getMinDifficulty() < 1 || monetarySystemCurrencyIssuance.getMaxDifficulty() > 255 || monetarySystemCurrencyIssuance.getMaxDifficulty() < monetarySystemCurrencyIssuance.getMinDifficulty()) {
                    throw new NxtException.NotValidException(String.format("Invalid minting difficulties min %d max %d, difficulty must be between 1 and 255, max larger than min", monetarySystemCurrencyIssuance.getMinDifficulty(), monetarySystemCurrencyIssuance.getMaxDifficulty()));
                }
                if (monetarySystemCurrencyIssuance.getMaxSupply() <= monetarySystemCurrencyIssuance.getReserveSupply()) {
                    throw new NxtException.NotValidException("Max supply for mintable currency must exceed reserve supply");
                }
            }
        }

        @Override
        void validateMissing(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.NotValidException {
            Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance;
            if (transaction.getType() == MonetarySystem.CURRENCY_ISSUANCE && ((monetarySystemCurrencyIssuance = (Attachment.MonetarySystemCurrencyIssuance)transaction.getAttachment()).getMinDifficulty() != 0 || monetarySystemCurrencyIssuance.getMaxDifficulty() != 0 || monetarySystemCurrencyIssuance.getAlgorithm() != 0)) {
                throw new NxtException.NotValidException("Non mintable currency should not specify algorithm or difficulty");
            }
            if (transaction.getType() == MonetarySystem.CURRENCY_MINTING) {
                throw new NxtException.NotValidException("Currency is not mintable");
            }
        }
    }
    ,
    NON_SHUFFLEABLE(32){

        @Override
        void validate(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.ValidationException {
            if (transaction.getType() == ShufflingTransaction.SHUFFLING_CREATION) {
                throw new NxtException.NotValidException("Shuffling is not allowed for this currency");
            }
        }

        @Override
        void validateMissing(Currency currency, Transaction transaction, Set<CurrencyType> set) {
        }
    };

    private final int code;

    private CurrencyType(int n2) {
        this.code = n2;
    }

    public int getCode() {
        return this.code;
    }

    abstract void validate(Currency var1, Transaction var2, Set<CurrencyType> var3) throws NxtException.ValidationException;

    abstract void validateMissing(Currency var1, Transaction var2, Set<CurrencyType> var3) throws NxtException.ValidationException;

    public static CurrencyType get(int n) {
        for (CurrencyType currencyType : CurrencyType.values()) {
            if (currencyType.getCode() != n) continue;
            return currencyType;
        }
        return null;
    }

    static void validate(Currency currency, Transaction transaction) throws NxtException.ValidationException {
        if (currency == null) {
            throw new NxtException.NotCurrentlyValidException("Unknown currency: " + transaction.getAttachment().getJSONObject());
        }
        CurrencyType.validate(currency, currency.getType(), transaction);
    }

    static void validate(int n, Transaction transaction) throws NxtException.ValidationException {
        CurrencyType.validate(null, n, transaction);
    }

    private static void validate(Currency currency, int n, Transaction transaction) throws NxtException.ValidationException {
        if (transaction.getAmountNQT() != 0L) {
            throw new NxtException.NotValidException("Currency transaction NXT amount must be 0");
        }
        EnumSet<CurrencyType> enumSet = EnumSet.noneOf(CurrencyType.class);
        for (CurrencyType currencyType : CurrencyType.values()) {
            if ((currencyType.getCode() & n) == 0) continue;
            enumSet.add(currencyType);
        }
        if (enumSet.isEmpty()) {
            throw new NxtException.NotValidException("Currency type not specified");
        }
        for (CurrencyType currencyType : CurrencyType.values()) {
            if ((currencyType.getCode() & n) != 0) {
                currencyType.validate(currency, transaction, enumSet);
                continue;
            }
            currencyType.validateMissing(currency, transaction, enumSet);
        }
    }

    static void validateCurrencyNaming(long l, Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance) throws NxtException.ValidationException {
        int n;
        String string = monetarySystemCurrencyIssuance.getName();
        String string2 = monetarySystemCurrencyIssuance.getCode();
        String string3 = monetarySystemCurrencyIssuance.getDescription();
        if (!(string.length() >= 3 && Attachment.MonetarySystemCurrencyIssuance.NAME_RW.validate(string) && string.length() >= string2.length() && string2.length() >= 3 && Attachment.MonetarySystemCurrencyIssuance.CODE_RW.validate(string2) && Attachment.MonetarySystemCurrencyIssuance.DESCRIPTION_RW.validate(string3))) {
            throw new NxtException.NotValidException(String.format("Invalid currency name %s code %s or description %s", string, string2, string3));
        }
        String string4 = string.toLowerCase(Locale.ROOT);
        for (n = 0; n < string4.length(); ++n) {
            if ("0123456789abcdefghijklmnopqrstuvwxyz".indexOf(string4.charAt(n)) >= 0) continue;
            throw new NxtException.NotValidException("Invalid currency name: " + string4);
        }
        for (n = 0; n < string2.length(); ++n) {
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(string2.charAt(n)) >= 0) continue;
            throw new NxtException.NotValidException("Invalid currency code: " + string2 + " code must be all upper case");
        }
        if (string2.contains("NXT") || string2.contains("NEXT") || "nxt".equals(string4) || "next".equals(string4)) {
            throw new NxtException.NotValidException("Currency name already used");
        }
        Currency currency = Currency.getCurrencyByName(string4);
        if (currency != null && !currency.canBeDeletedBy(l)) {
            throw new NxtException.NotCurrentlyValidException("Currency name already used: " + string4);
        }
        currency = Currency.getCurrencyByCode(string);
        if (currency != null && !currency.canBeDeletedBy(l)) {
            throw new NxtException.NotCurrentlyValidException("Currency name already used as code: " + string4);
        }
        currency = Currency.getCurrencyByCode(string2);
        if (currency != null && !currency.canBeDeletedBy(l)) {
            throw new NxtException.NotCurrentlyValidException("Currency code already used: " + string2);
        }
        currency = Currency.getCurrencyByName(string2);
        if (currency != null && !currency.canBeDeletedBy(l)) {
            throw new NxtException.NotCurrentlyValidException("Currency code already used as name: " + string2);
        }
    }
}

