/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nxt.Account;
import nxt.Attachment;
import nxt.Block;
import nxt.BlockDb;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Currency;
import nxt.CurrencyFounder;
import nxt.CurrencyMint;
import nxt.CurrencyType;
import nxt.DigitalGoodsStore;
import nxt.Exchange;
import nxt.Nxt;
import nxt.Order;
import nxt.Shuffling;
import nxt.ShufflingParticipant;
import nxt.Trade;
import nxt.Transaction;
import nxt.TransactionImpl;
import nxt.TransactionProcessor;
import nxt.db.DbIterator;
import nxt.util.Convert;
import nxt.util.Logger;

public final class DebugTrace {
    static final String QUOTE = Nxt.getStringProperty("nxt.debugTraceQuote", "\"");
    static final String SEPARATOR = Nxt.getStringProperty("nxt.debugTraceSeparator", "\t");
    static final boolean LOG_UNCONFIRMED = Nxt.getBooleanProperty("nxt.debugLogUnconfirmed");
    private static final String[] columns = new String[]{"height", "event", "account", "asset", "currency", "balance", "unconfirmed balance", "asset balance", "unconfirmed asset balance", "currency balance", "unconfirmed currency balance", "transaction amount", "transaction fee", "generation fee", "effective balance", "dividend", "order", "order price", "order quantity", "order cost", "offer", "buy rate", "sell rate", "buy units", "sell units", "buy cost", "sell cost", "trade price", "trade quantity", "trade cost", "exchange rate", "exchange quantity", "exchange cost", "currency cost", "crowdfunding", "claim", "mint", "asset quantity", "currency units", "transaction", "lessee", "lessor guaranteed balance", "purchase", "purchase price", "purchase quantity", "purchase cost", "discount", "refund", "shuffling", "sender", "recipient", "block", "timestamp"};
    private static final Map<String, String> headers = new HashMap<String, String>();
    private final Set<Long> accountIds;
    private final String logName;
    private PrintWriter log;

    static void init() {
        List<String> list = Nxt.getStringListProperty("nxt.debugTraceAccounts");
        String string = Nxt.getStringProperty("nxt.debugTraceLog");
        if (list.isEmpty() || string == null) {
            return;
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        for (String string2 : list) {
            if ("*".equals(string2)) {
                hashSet.clear();
                break;
            }
            hashSet.add(Convert.parseAccountId(string2));
        }
        DebugTrace debugTrace = DebugTrace.addDebugTrace(hashSet, string);
        Nxt.getBlockchainProcessor().addListener(block -> debugTrace.resetLog(), BlockchainProcessor.Event.RESCAN_BEGIN);
        Logger.logDebugMessage("Debug tracing of " + (list.contains("*") ? "ALL" : String.valueOf(hashSet.size())) + " accounts enabled");
    }

    public static DebugTrace addDebugTrace(Set<Long> set, String string) {
        DebugTrace debugTrace = new DebugTrace(set, string);
        Trade.addListener(debugTrace::trace, Trade.Event.TRADE);
        Exchange.addListener(debugTrace::trace, Exchange.Event.EXCHANGE);
        Currency.addListener(debugTrace::crowdfunding, Currency.Event.BEFORE_DISTRIBUTE_CROWDFUNDING);
        Currency.addListener(debugTrace::undoCrowdfunding, Currency.Event.BEFORE_UNDO_CROWDFUNDING);
        Currency.addListener(debugTrace::delete, Currency.Event.BEFORE_DELETE);
        CurrencyMint.addListener(debugTrace::currencyMint, CurrencyMint.Event.CURRENCY_MINT);
        Account.addListener(account -> debugTrace.trace((Account)account, false), Account.Event.BALANCE);
        if (LOG_UNCONFIRMED) {
            Account.addListener(account -> debugTrace.trace((Account)account, true), Account.Event.UNCONFIRMED_BALANCE);
        }
        Account.addAssetListener(accountAsset -> debugTrace.trace((Account.AccountAsset)accountAsset, false), Account.Event.ASSET_BALANCE);
        if (LOG_UNCONFIRMED) {
            Account.addAssetListener(accountAsset -> debugTrace.trace((Account.AccountAsset)accountAsset, true), Account.Event.UNCONFIRMED_ASSET_BALANCE);
        }
        Account.addCurrencyListener(accountCurrency -> debugTrace.trace((Account.AccountCurrency)accountCurrency, false), Account.Event.CURRENCY_BALANCE);
        if (LOG_UNCONFIRMED) {
            Account.addCurrencyListener(accountCurrency -> debugTrace.trace((Account.AccountCurrency)accountCurrency, true), Account.Event.UNCONFIRMED_CURRENCY_BALANCE);
        }
        Account.addLeaseListener(accountLease -> debugTrace.trace((Account.AccountLease)accountLease, true), Account.Event.LEASE_STARTED);
        Account.addLeaseListener(accountLease -> debugTrace.trace((Account.AccountLease)accountLease, false), Account.Event.LEASE_ENDED);
        Nxt.getBlockchainProcessor().addListener(debugTrace::traceBeforeAccept, BlockchainProcessor.Event.BEFORE_BLOCK_ACCEPT);
        Nxt.getBlockchainProcessor().addListener(debugTrace::trace, BlockchainProcessor.Event.BEFORE_BLOCK_APPLY);
        Nxt.getTransactionProcessor().addListener(list -> debugTrace.traceRelease((Transaction)list.get(0)), TransactionProcessor.Event.RELEASE_PHASED_TRANSACTION);
        Shuffling.addListener(debugTrace::traceShufflingDistribute, Shuffling.Event.SHUFFLING_DONE);
        Shuffling.addListener(debugTrace::traceShufflingCancel, Shuffling.Event.SHUFFLING_CANCELLED);
        return debugTrace;
    }

    private DebugTrace(Set<Long> set, String string) {
        this.accountIds = set;
        this.logName = string;
        this.resetLog();
    }

    void resetLog() {
        if (this.log != null) {
            this.log.close();
        }
        try {
            this.log = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.logName))), true);
        }
        catch (IOException iOException) {
            Logger.logDebugMessage("Debug tracing to " + this.logName + " not possible", iOException);
            throw new RuntimeException(iOException);
        }
        this.log(headers);
    }

    private boolean include(long l) {
        return l != 0L && (this.accountIds.isEmpty() || this.accountIds.contains(l));
    }

    private void trace(Trade trade) {
        long l = Order.Ask.getAskOrder(trade.getAskOrderId()).getAccountId();
        long l2 = Order.Bid.getBidOrder(trade.getBidOrderId()).getAccountId();
        if (this.include(l)) {
            this.log(this.getValues(l, trade, true));
        }
        if (this.include(l2)) {
            this.log(this.getValues(l2, trade, false));
        }
    }

    private void trace(Exchange exchange) {
        long l = exchange.getSellerId();
        long l2 = exchange.getBuyerId();
        if (this.include(l)) {
            this.log(this.getValues(l, exchange, true));
        }
        if (this.include(l2)) {
            this.log(this.getValues(l2, exchange, false));
        }
    }

    private void trace(Account account, boolean bl) {
        if (this.include(account.getId())) {
            this.log(this.getValues(account.getId(), bl));
        }
    }

    private void trace(Account.AccountAsset accountAsset, boolean bl) {
        if (!this.include(accountAsset.getAccountId())) {
            return;
        }
        this.log(this.getValues(accountAsset.getAccountId(), accountAsset, bl));
    }

    private void trace(Account.AccountCurrency accountCurrency, boolean bl) {
        if (!this.include(accountCurrency.getAccountId())) {
            return;
        }
        this.log(this.getValues(accountCurrency.getAccountId(), accountCurrency, bl));
    }

    private void trace(Account.AccountLease accountLease, boolean bl) {
        if (!this.include(accountLease.getCurrentLesseeId()) && !this.include(accountLease.getLessorId())) {
            return;
        }
        this.log(this.getValues(accountLease.getLessorId(), accountLease, bl));
    }

    private void traceBeforeAccept(Block block) {
        long l = block.getGeneratorId();
        if (this.include(l)) {
            this.log(this.getValues(l, block));
        }
        for (long l2 : this.accountIds) {
            Account account = Account.getAccount(l2);
            if (account == null) continue;
            DbIterator<Account> dbIterator = account.getLessors();
            Throwable throwable = null;
            try {
                while (dbIterator.hasNext()) {
                    this.log(this.lessorGuaranteedBalance(dbIterator.next(), l2));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dbIterator == null) continue;
                if (throwable != null) {
                    try {
                        dbIterator.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dbIterator.close();
            }
        }
    }

    private void trace(Block block) {
        for (Transaction transaction : block.getTransactions()) {
            long l = transaction.getSenderId();
            if (((TransactionImpl)transaction).attachmentIsPhased()) {
                if (!this.include(l)) continue;
                this.log(this.getValues(l, transaction, false, true, false));
                continue;
            }
            if (this.include(l)) {
                this.log(this.getValues(l, transaction, false, true, true));
                this.log(this.getValues(l, transaction, transaction.getAttachment(), false));
            }
            long l2 = transaction.getRecipientId();
            if (transaction.getAmountNQT() > 0L && l2 == 0L) {
                l2 = 1739068987193023818L;
            }
            if (!this.include(l2)) continue;
            this.log(this.getValues(l2, transaction, true, true, true));
            this.log(this.getValues(l2, transaction, transaction.getAttachment(), true));
        }
    }

    private void traceRelease(Transaction transaction) {
        long l;
        long l2 = transaction.getSenderId();
        if (this.include(l2)) {
            this.log(this.getValues(l2, transaction, false, false, true));
            this.log(this.getValues(l2, transaction, transaction.getAttachment(), false));
        }
        if (this.include(l = transaction.getRecipientId())) {
            this.log(this.getValues(l, transaction, true, false, true));
            this.log(this.getValues(l, transaction, transaction.getAttachment(), true));
        }
    }

    private void traceShufflingDistribute(Shuffling shuffling) {
        ShufflingParticipant.getParticipants(shuffling.getId()).forEach(shufflingParticipant -> {
            if (this.include(shufflingParticipant.getAccountId())) {
                this.log(this.getValues(shufflingParticipant.getAccountId(), shuffling, false));
            }
        });
        for (byte[] byArray : shuffling.getRecipientPublicKeys()) {
            long l = Account.getId(byArray);
            if (!this.include(l)) continue;
            this.log(this.getValues(l, shuffling, true));
        }
    }

    private void traceShufflingCancel(Shuffling shuffling) {
        long l = shuffling.getAssigneeAccountId();
        if (l != 0L && this.include(l)) {
            Map<String, String> map = this.getValues(l, false);
            map.put("transaction fee", String.valueOf(-Constants.SHUFFLING_DEPOSIT_NQT));
            map.put("event", "shuffling blame");
            this.log(map);
            long l2 = Constants.SHUFFLING_DEPOSIT_NQT / 4L;
            int n = Nxt.getBlockchain().getHeight();
            for (int i = 0; i < 3; ++i) {
                long l3 = BlockDb.findBlockAtHeight(n - i - 1).getGeneratorId();
                if (!this.include(l3)) continue;
                Map<String, String> map2 = this.getValues(l3, false);
                map2.put("generation fee", String.valueOf(l2));
                map2.put("event", "shuffling blame");
                this.log(map2);
            }
            l2 = Constants.SHUFFLING_DEPOSIT_NQT - 3L * l2;
            long l4 = Nxt.getBlockchain().getLastBlock().getGeneratorId();
            if (this.include(l4)) {
                Map<String, String> map3 = this.getValues(l4, false);
                map3.put("generation fee", String.valueOf(l2));
                map3.put("event", "shuffling blame");
                this.log(map3);
            }
        }
    }

    private Map<String, String> lessorGuaranteedBalance(Account account, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("account", Long.toUnsignedString(account.getId()));
        hashMap.put("lessor guaranteed balance", String.valueOf(account.getGuaranteedBalanceNQT()));
        hashMap.put("lessee", Long.toUnsignedString(l));
        hashMap.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
        hashMap.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
        hashMap.put("event", "lessor guaranteed balance");
        return hashMap;
    }

    private void crowdfunding(Currency currency) {
        long l = 0L;
        long l2 = 0L;
        long l3 = currency.getReserveSupply() - currency.getInitialSupply();
        ArrayList<CurrencyFounder> arrayList = new ArrayList<CurrencyFounder>();
        Throwable object22 = null;
        try (Object object = CurrencyFounder.getCurrencyFounders(currency.getId(), 0, Integer.MAX_VALUE);){
            Iterator<CurrencyFounder> l4 = ((DbIterator)object).iterator();
            while (l4.hasNext()) {
                CurrencyFounder currencyFounder = l4.next();
                l += currencyFounder.getAmountPerUnitNQT();
                arrayList.add(currencyFounder);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
        for (CurrencyFounder currencyFounder : arrayList) {
            long l4 = Math.multiplyExact(l3, currencyFounder.getAmountPerUnitNQT()) / l;
            Map<String, String> map = this.getValues(currencyFounder.getAccountId(), false);
            map.put("currency", Long.toUnsignedString(currency.getId()));
            map.put("currency units", String.valueOf(l4));
            map.put("event", "distribution");
            this.log(map);
            l2 += l4;
        }
        object = this.getValues(currency.getAccountId(), false);
        object.put("currency", Long.toUnsignedString(currency.getId()));
        object.put("crowdfunding", String.valueOf(currency.getReserveSupply()));
        object.put("currency units", String.valueOf(l3 - l2));
        if (!currency.is(CurrencyType.CLAIMABLE)) {
            object.put("currency cost", String.valueOf(Math.multiplyExact(currency.getReserveSupply(), currency.getCurrentReservePerUnitNQT())));
        }
        object.put("event", "crowdfunding");
        this.log((Map<String, String>)object);
    }

    private void undoCrowdfunding(Currency currency) {
        try (Object object = CurrencyFounder.getCurrencyFounders(currency.getId(), 0, Integer.MAX_VALUE);){
            Iterator<CurrencyFounder> iterator = ((DbIterator)object).iterator();
            while (iterator.hasNext()) {
                CurrencyFounder currencyFounder = iterator.next();
                Map<String, String> map = this.getValues(currencyFounder.getAccountId(), false);
                map.put("currency", Long.toUnsignedString(currency.getId()));
                map.put("currency cost", String.valueOf(Math.multiplyExact(currency.getReserveSupply(), currencyFounder.getAmountPerUnitNQT())));
                map.put("event", "undo distribution");
                this.log(map);
            }
        }
        object = this.getValues(currency.getAccountId(), false);
        object.put("currency", Long.toUnsignedString(currency.getId()));
        object.put("currency units", String.valueOf(-currency.getInitialSupply()));
        object.put("event", "undo crowdfunding");
        this.log((Map<String, String>)object);
    }

    private void delete(Currency currency) {
        Object object;
        Object object2;
        Object object3;
        long l;
        long l2;
        block33: {
            if (!currency.isActive()) {
                l2 = currency.getAccountId();
                l = currency.getCurrentSupply();
            } else {
                object3 = Account.getCurrencyAccounts(currency.getId(), 0, -1);
                object2 = null;
                try {
                    if (((DbIterator)object3).hasNext()) {
                        object = (Account.AccountCurrency)((DbIterator)object3).next();
                        l2 = ((Account.AccountCurrency)object).getAccountId();
                        l = ((Account.AccountCurrency)object).getUnits();
                        break block33;
                    }
                    return;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    if (object3 != null) {
                        if (object2 != null) {
                            try {
                                ((DbIterator)object3).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                        } else {
                            ((DbIterator)object3).close();
                        }
                    }
                }
            }
        }
        object3 = this.getValues(l2, false);
        object3.put("currency", Long.toUnsignedString(currency.getId()));
        if (currency.is(CurrencyType.RESERVABLE)) {
            if (currency.is(CurrencyType.CLAIMABLE) && currency.isActive()) {
                object3.put("currency cost", String.valueOf(Math.multiplyExact(l, currency.getCurrentReservePerUnitNQT())));
            }
            if (!currency.isActive()) {
                object2 = CurrencyFounder.getCurrencyFounders(currency.getId(), 0, Integer.MAX_VALUE);
                object = null;
                try {
                    Iterator iterator = ((DbIterator)object2).iterator();
                    while (iterator.hasNext()) {
                        CurrencyFounder currencyFounder = (CurrencyFounder)iterator.next();
                        Map<String, String> map = this.getValues(currencyFounder.getAccountId(), false);
                        map.put("currency", Long.toUnsignedString(currency.getId()));
                        map.put("currency cost", String.valueOf(Math.multiplyExact(currency.getReserveSupply(), currencyFounder.getAmountPerUnitNQT())));
                        map.put("event", "undo distribution");
                        this.log(map);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((DbIterator)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((DbIterator)object2).close();
                        }
                    }
                }
            }
        }
        object3.put("currency units", String.valueOf(-l));
        object3.put("event", "currency delete");
        this.log((Map<String, String>)object3);
    }

    private void currencyMint(CurrencyMint.Mint mint) {
        if (!this.include(mint.accountId)) {
            return;
        }
        Map<String, String> map = this.getValues(mint.accountId, false);
        map.put("currency", Long.toUnsignedString(mint.currencyId));
        map.put("currency units", String.valueOf(mint.units));
        map.put("event", "currency mint");
        this.log(map);
    }

    private Map<String, String> getValues(long l, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("account", Long.toUnsignedString(l));
        Account account = Account.getAccount(l);
        hashMap.put("balance", String.valueOf(account != null ? account.getBalanceNQT() : 0L));
        hashMap.put("unconfirmed balance", String.valueOf(account != null ? account.getUnconfirmedBalanceNQT() : 0L));
        hashMap.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
        hashMap.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
        hashMap.put("event", bl ? "unconfirmed balance" : "balance");
        return hashMap;
    }

    private Map<String, String> getValues(long l, Trade trade, boolean bl) {
        Map<String, String> map = this.getValues(l, false);
        map.put("asset", Long.toUnsignedString(trade.getAssetId()));
        map.put("trade quantity", String.valueOf(bl ? -trade.getQuantityQNT() : trade.getQuantityQNT()));
        map.put("trade price", String.valueOf(trade.getPriceNQT()));
        long l2 = Math.multiplyExact(trade.getQuantityQNT(), trade.getPriceNQT());
        map.put("trade cost", String.valueOf(bl ? l2 : -l2));
        map.put("event", "trade");
        return map;
    }

    private Map<String, String> getValues(long l, Exchange exchange, boolean bl) {
        Map<String, String> map = this.getValues(l, false);
        map.put("currency", Long.toUnsignedString(exchange.getCurrencyId()));
        map.put("exchange quantity", String.valueOf(bl ? -exchange.getUnits() : exchange.getUnits()));
        map.put("exchange rate", String.valueOf(exchange.getRate()));
        long l2 = Math.multiplyExact(exchange.getUnits(), exchange.getRate());
        map.put("exchange cost", String.valueOf(bl ? l2 : -l2));
        map.put("event", "exchange");
        return map;
    }

    private Map<String, String> getValues(long l, Shuffling shuffling, boolean bl) {
        Map<String, String> map = this.getValues(l, false);
        map.put("shuffling", Long.toUnsignedString(shuffling.getId()));
        String string = String.valueOf(bl ? shuffling.getAmount() : -shuffling.getAmount());
        String string2 = String.valueOf(bl ? Constants.SHUFFLING_DEPOSIT_NQT : -Constants.SHUFFLING_DEPOSIT_NQT);
        switch (shuffling.getHoldingType()) {
            case NXT: {
                map.put("transaction amount", string);
                break;
            }
            case ASSET: {
                map.put("asset quantity", string);
                map.put("asset", Long.toUnsignedString(shuffling.getHoldingId()));
                map.put("transaction amount", string2);
                break;
            }
            case CURRENCY: {
                map.put("currency units", string);
                map.put("currency", Long.toUnsignedString(shuffling.getHoldingId()));
                map.put("transaction amount", string2);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported holding type " + (Object)((Object)shuffling.getHoldingType()));
            }
        }
        map.put("event", "shuffling distribute");
        return map;
    }

    private Map<String, String> getValues(long l, Transaction transaction, boolean bl, boolean bl2, boolean bl3) {
        long l2 = transaction.getAmountNQT();
        long l3 = transaction.getFeeNQT();
        if (bl) {
            l3 = 0L;
        } else {
            l2 = -l2;
            l3 = -l3;
        }
        if (l3 == 0L && l2 == 0L) {
            return Collections.emptyMap();
        }
        Map<String, String> map = this.getValues(l, false);
        if (bl3) {
            map.put("transaction amount", String.valueOf(l2));
        }
        if (bl2) {
            map.put("transaction fee", String.valueOf(l3));
        }
        map.put("transaction", transaction.getStringId());
        if (bl) {
            map.put("sender", Long.toUnsignedString(transaction.getSenderId()));
        } else {
            map.put("recipient", Long.toUnsignedString(transaction.getRecipientId()));
        }
        map.put("event", "transaction");
        return map;
    }

    private Map<String, String> getValues(long l, Block block) {
        Object object;
        long l2 = block.getTotalFeeNQT();
        if (l2 == 0L) {
            return Collections.emptyMap();
        }
        long l3 = 0L;
        if (block.getHeight() > Constants.SHUFFLING_BLOCK) {
            object = new long[3];
            for (Transaction transaction : block.getTransactions()) {
                long[] lArray = ((TransactionImpl)transaction).getBackFees();
                for (int i = 0; i < lArray.length; ++i) {
                    Object object2 = object;
                    int n = i;
                    object2[n] = object2[n] + lArray[i];
                }
            }
            for (int i = 0; i < ((Object)object).length && object[i] != 0L; ++i) {
                l3 += object[i];
                long l4 = BlockDb.findBlockAtHeight(block.getHeight() - i - 1).getGeneratorId();
                if (!this.include(l4)) continue;
                Map<String, String> map = this.getValues(l4, false);
                map.put("effective balance", String.valueOf(Account.getAccount(l4).getEffectiveBalanceNXT()));
                map.put("generation fee", String.valueOf((long)object[i]));
                map.put("block", block.getStringId());
                map.put("event", "block");
                map.put("timestamp", String.valueOf(block.getTimestamp()));
                map.put("height", String.valueOf(block.getHeight()));
                this.log(map);
            }
        }
        object = this.getValues(l, false);
        object.put("effective balance", String.valueOf(Account.getAccount(l).getEffectiveBalanceNXT()));
        object.put("generation fee", String.valueOf(l2 - l3));
        object.put("block", block.getStringId());
        object.put("event", "block");
        object.put("timestamp", String.valueOf(block.getTimestamp()));
        object.put("height", String.valueOf(block.getHeight()));
        return object;
    }

    private Map<String, String> getValues(long l, Account.AccountAsset accountAsset, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("account", Long.toUnsignedString(l));
        hashMap.put("asset", Long.toUnsignedString(accountAsset.getAssetId()));
        if (bl) {
            hashMap.put("unconfirmed asset balance", String.valueOf(accountAsset.getUnconfirmedQuantityQNT()));
        } else {
            hashMap.put("asset balance", String.valueOf(accountAsset.getQuantityQNT()));
        }
        hashMap.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
        hashMap.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
        hashMap.put("event", "asset balance");
        return hashMap;
    }

    private Map<String, String> getValues(long l, Account.AccountCurrency accountCurrency, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("account", Long.toUnsignedString(l));
        hashMap.put("currency", Long.toUnsignedString(accountCurrency.getCurrencyId()));
        if (bl) {
            hashMap.put("unconfirmed currency balance", String.valueOf(accountCurrency.getUnconfirmedUnits()));
        } else {
            hashMap.put("currency balance", String.valueOf(accountCurrency.getUnits()));
        }
        hashMap.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
        hashMap.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
        hashMap.put("event", "currency balance");
        return hashMap;
    }

    private Map<String, String> getValues(long l, Account.AccountLease accountLease, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("account", Long.toUnsignedString(l));
        hashMap.put("event", bl ? "lease begin" : "lease end");
        hashMap.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
        hashMap.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
        hashMap.put("lessee", Long.toUnsignedString(accountLease.getCurrentLesseeId()));
        return hashMap;
    }

    private Map<String, String> getValues(long l, Transaction transaction, Attachment attachment, boolean bl) {
        Map<String, String> map = this.getValues(l, false);
        if (attachment instanceof Attachment.ColoredCoinsOrderPlacement) {
            if (bl) {
                return Collections.emptyMap();
            }
            Attachment.ColoredCoinsOrderPlacement coloredCoinsOrderPlacement = (Attachment.ColoredCoinsOrderPlacement)attachment;
            boolean bl2 = coloredCoinsOrderPlacement instanceof Attachment.ColoredCoinsAskOrderPlacement;
            map.put("asset", Long.toUnsignedString(coloredCoinsOrderPlacement.getAssetId()));
            map.put("order", transaction.getStringId());
            map.put("order price", String.valueOf(coloredCoinsOrderPlacement.getPriceNQT()));
            long l2 = coloredCoinsOrderPlacement.getQuantityQNT();
            if (bl2) {
                l2 = -l2;
            }
            map.put("order quantity", String.valueOf(l2));
            BigInteger bigInteger = BigInteger.valueOf(coloredCoinsOrderPlacement.getPriceNQT()).multiply(BigInteger.valueOf(coloredCoinsOrderPlacement.getQuantityQNT()));
            if (!bl2) {
                bigInteger = bigInteger.negate();
            }
            map.put("order cost", bigInteger.toString());
            String string = (bl2 ? "ask" : "bid") + " order";
            map.put("event", string);
        } else if (attachment instanceof Attachment.ColoredCoinsAssetIssuance) {
            if (bl) {
                return Collections.emptyMap();
            }
            Attachment.ColoredCoinsAssetIssuance coloredCoinsAssetIssuance = (Attachment.ColoredCoinsAssetIssuance)attachment;
            map.put("asset", transaction.getStringId());
            map.put("asset quantity", String.valueOf(coloredCoinsAssetIssuance.getQuantityQNT()));
            map.put("event", "asset issuance");
        } else if (attachment instanceof Attachment.ColoredCoinsAssetTransfer) {
            Attachment.ColoredCoinsAssetTransfer coloredCoinsAssetTransfer = (Attachment.ColoredCoinsAssetTransfer)attachment;
            map.put("asset", Long.toUnsignedString(coloredCoinsAssetTransfer.getAssetId()));
            long l3 = coloredCoinsAssetTransfer.getQuantityQNT();
            if (!bl) {
                l3 = -l3;
            }
            map.put("asset quantity", String.valueOf(l3));
            map.put("event", "asset transfer");
        } else if (attachment instanceof Attachment.ColoredCoinsAssetDelete) {
            if (bl) {
                return Collections.emptyMap();
            }
            Attachment.ColoredCoinsAssetDelete coloredCoinsAssetDelete = (Attachment.ColoredCoinsAssetDelete)attachment;
            map.put("asset", Long.toUnsignedString(coloredCoinsAssetDelete.getAssetId()));
            long l4 = coloredCoinsAssetDelete.getQuantityQNT();
            map.put("asset quantity", String.valueOf(-l4));
            map.put("event", "asset quantity change");
        } else if (attachment instanceof Attachment.ColoredCoinsAssetIncrease) {
            if (bl) {
                return Collections.emptyMap();
            }
            Attachment.ColoredCoinsAssetIncrease coloredCoinsAssetIncrease = (Attachment.ColoredCoinsAssetIncrease)attachment;
            map.put("asset", Long.toUnsignedString(coloredCoinsAssetIncrease.getAssetId()));
            long l5 = coloredCoinsAssetIncrease.getQuantityQNT();
            map.put("asset quantity", String.valueOf(l5));
            map.put("event", "asset quantity change");
        } else if (attachment instanceof Attachment.ColoredCoinsOrderCancellation) {
            Attachment.ColoredCoinsOrderCancellation coloredCoinsOrderCancellation = (Attachment.ColoredCoinsOrderCancellation)attachment;
            map.put("order", Long.toUnsignedString(coloredCoinsOrderCancellation.getOrderId()));
            map.put("event", "order cancel");
        } else if (attachment instanceof Attachment.DigitalGoodsPurchase) {
            Attachment.DigitalGoodsPurchase digitalGoodsPurchase = (Attachment.DigitalGoodsPurchase)transaction.getAttachment();
            if (bl) {
                map = this.getValues(DigitalGoodsStore.Goods.getGoods(digitalGoodsPurchase.getGoodsId()).getSellerId(), false);
            }
            map.put("event", "purchase");
            map.put("purchase", transaction.getStringId());
        } else if (attachment instanceof Attachment.DigitalGoodsDelivery) {
            Attachment.DigitalGoodsDelivery digitalGoodsDelivery = (Attachment.DigitalGoodsDelivery)transaction.getAttachment();
            DigitalGoodsStore.Purchase purchase = DigitalGoodsStore.Purchase.getPurchase(digitalGoodsDelivery.getPurchaseId());
            if (bl) {
                map = this.getValues(purchase.getBuyerId(), false);
            }
            map.put("event", "delivery");
            map.put("purchase", Long.toUnsignedString(digitalGoodsDelivery.getPurchaseId()));
            long l6 = digitalGoodsDelivery.getDiscountNQT();
            map.put("purchase price", String.valueOf(purchase.getPriceNQT()));
            map.put("purchase quantity", String.valueOf(purchase.getQuantity()));
            long l7 = Math.multiplyExact(purchase.getPriceNQT(), (long)purchase.getQuantity());
            if (bl) {
                l7 = -l7;
            }
            map.put("purchase cost", String.valueOf(l7));
            if (!bl) {
                l6 = -l6;
            }
            map.put("discount", String.valueOf(l6));
        } else if (attachment instanceof Attachment.DigitalGoodsRefund) {
            Attachment.DigitalGoodsRefund digitalGoodsRefund = (Attachment.DigitalGoodsRefund)transaction.getAttachment();
            if (bl) {
                map = this.getValues(DigitalGoodsStore.Purchase.getPurchase(digitalGoodsRefund.getPurchaseId()).getBuyerId(), false);
            }
            map.put("event", "refund");
            map.put("purchase", Long.toUnsignedString(digitalGoodsRefund.getPurchaseId()));
            long l8 = digitalGoodsRefund.getRefundNQT();
            if (!bl) {
                l8 = -l8;
            }
            map.put("refund", String.valueOf(l8));
        } else if (attachment == Attachment.ARBITRARY_MESSAGE) {
            map = new HashMap<String, String>();
            map.put("account", Long.toUnsignedString(l));
            map.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
            map.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
            map.put("event", attachment == Attachment.ARBITRARY_MESSAGE ? "message" : "encrypted message");
            if (bl) {
                map.put("sender", Long.toUnsignedString(transaction.getSenderId()));
            } else {
                map.put("recipient", Long.toUnsignedString(transaction.getRecipientId()));
            }
        } else if (attachment instanceof Attachment.MonetarySystemPublishExchangeOffer) {
            Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)attachment;
            map.put("currency", Long.toUnsignedString(monetarySystemPublishExchangeOffer.getCurrencyId()));
            map.put("offer", transaction.getStringId());
            map.put("buy rate", String.valueOf(monetarySystemPublishExchangeOffer.getBuyRateNQT()));
            map.put("sell rate", String.valueOf(monetarySystemPublishExchangeOffer.getSellRateNQT()));
            long l9 = monetarySystemPublishExchangeOffer.getInitialBuySupply();
            map.put("buy units", String.valueOf(l9));
            long l10 = monetarySystemPublishExchangeOffer.getInitialSellSupply();
            map.put("sell units", String.valueOf(l10));
            BigInteger bigInteger = BigInteger.valueOf(monetarySystemPublishExchangeOffer.getBuyRateNQT()).multiply(BigInteger.valueOf(l9));
            map.put("buy cost", bigInteger.toString());
            BigInteger bigInteger2 = BigInteger.valueOf(monetarySystemPublishExchangeOffer.getSellRateNQT()).multiply(BigInteger.valueOf(l10));
            map.put("sell cost", bigInteger2.toString());
            map.put("event", "offer");
        } else if (attachment instanceof Attachment.MonetarySystemCurrencyIssuance) {
            Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance = (Attachment.MonetarySystemCurrencyIssuance)attachment;
            map.put("currency", transaction.getStringId());
            map.put("currency units", String.valueOf(monetarySystemCurrencyIssuance.getInitialSupply()));
            map.put("event", "currency issuance");
        } else if (attachment instanceof Attachment.MonetarySystemCurrencyTransfer) {
            Attachment.MonetarySystemCurrencyTransfer monetarySystemCurrencyTransfer = (Attachment.MonetarySystemCurrencyTransfer)attachment;
            map.put("currency", Long.toUnsignedString(monetarySystemCurrencyTransfer.getCurrencyId()));
            long l11 = monetarySystemCurrencyTransfer.getUnits();
            if (!bl) {
                l11 = -l11;
            }
            map.put("currency units", String.valueOf(l11));
            map.put("event", "currency transfer");
        } else if (attachment instanceof Attachment.MonetarySystemReserveClaim) {
            Attachment.MonetarySystemReserveClaim monetarySystemReserveClaim = (Attachment.MonetarySystemReserveClaim)attachment;
            map.put("currency", Long.toUnsignedString(monetarySystemReserveClaim.getCurrencyId()));
            Currency currency = Currency.getCurrency(monetarySystemReserveClaim.getCurrencyId());
            map.put("currency units", String.valueOf(-monetarySystemReserveClaim.getUnits()));
            map.put("currency cost", String.valueOf(Math.multiplyExact(monetarySystemReserveClaim.getUnits(), currency.getCurrentReservePerUnitNQT())));
            map.put("event", "currency claim");
        } else if (attachment instanceof Attachment.MonetarySystemReserveIncrease) {
            Attachment.MonetarySystemReserveIncrease monetarySystemReserveIncrease = (Attachment.MonetarySystemReserveIncrease)attachment;
            map.put("currency", Long.toUnsignedString(monetarySystemReserveIncrease.getCurrencyId()));
            Currency currency = Currency.getCurrency(monetarySystemReserveIncrease.getCurrencyId());
            map.put("currency cost", String.valueOf(-Math.multiplyExact(monetarySystemReserveIncrease.getAmountPerUnitNQT(), currency.getReserveSupply())));
            map.put("event", "currency reserve");
        } else if (attachment instanceof Attachment.ColoredCoinsDividendPayment) {
            Attachment.ColoredCoinsDividendPayment coloredCoinsDividendPayment = (Attachment.ColoredCoinsDividendPayment)attachment;
            long l12 = 0L;
            String string = Long.toUnsignedString(coloredCoinsDividendPayment.getAssetId());
            try (DbIterator<Account.AccountAsset> dbIterator = Account.getAssetAccounts(coloredCoinsDividendPayment.getAssetId(), coloredCoinsDividendPayment.getHeight(), 0, -1);){
                while (dbIterator.hasNext()) {
                    Account.AccountAsset accountAsset = dbIterator.next();
                    if (accountAsset.getAccountId() == l || accountAsset.getQuantityQNT() == 0L) continue;
                    long l13 = Math.multiplyExact(accountAsset.getQuantityQNT(), coloredCoinsDividendPayment.getAmountNQTPerQNT());
                    Map<String, String> map2 = this.getValues(accountAsset.getAccountId(), false);
                    map2.put("dividend", String.valueOf(l13));
                    map2.put("asset", string);
                    map2.put("event", "dividend");
                    l12 += l13;
                    this.log(map2);
                }
            }
            map.put("dividend", String.valueOf(-l12));
            map.put("asset", string);
            map.put("event", "dividend");
        } else {
            return Collections.emptyMap();
        }
        return map;
    }

    private void log(Map<String, String> map) {
        if (map.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : columns) {
            if (!LOG_UNCONFIRMED && string.startsWith("unconfirmed")) continue;
            String string2 = map.get(string);
            if (string2 != null) {
                stringBuilder.append(QUOTE).append(string2).append(QUOTE);
            }
            stringBuilder.append(SEPARATOR);
        }
        this.log.println(stringBuilder.toString());
    }

    static {
        for (String string : columns) {
            headers.put(string, string);
        }
    }
}

