/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import nxt.AbstractPoll;
import nxt.Appendix;
import nxt.BlockchainImpl;
import nxt.Db;
import nxt.Nxt;
import nxt.PhasingVote;
import nxt.Transaction;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.VoteWeighting;
import nxt.crypto.HashFunction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.EntityDbTable;
import nxt.db.ValuesDbTable;
import nxt.util.Convert;

public final class PhasingPoll
extends AbstractPoll {
    public static final Set<HashFunction> acceptedHashFunctions = Collections.unmodifiableSet(EnumSet.of(HashFunction.SHA256, HashFunction.RIPEMD160, HashFunction.RIPEMD160_SHA256));
    private static final DbKey.LongKeyFactory<PhasingPoll> phasingPollDbKeyFactory = new DbKey.LongKeyFactory<PhasingPoll>("id"){

        @Override
        public DbKey newKey(PhasingPoll phasingPoll) {
            return phasingPoll.dbKey;
        }
    };
    private static final EntityDbTable<PhasingPoll> phasingPollTable = new EntityDbTable<PhasingPoll>("phasing_poll", phasingPollDbKeyFactory){

        @Override
        protected PhasingPoll load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new PhasingPoll(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, PhasingPoll phasingPoll) throws SQLException {
            phasingPoll.save(connection);
        }

        @Override
        public void trim(int n) {
            super.trim(n);
            try (Connection connection = Db.db.getConnection();
                 DbIterator dbIterator = phasingPollTable.getManyBy(new DbClause.IntClause("finish_height", DbClause.Op.LT, n), 0, -1);
                 PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM phasing_poll WHERE id = ?");
                 PreparedStatement preparedStatement2 = connection.prepareStatement("DELETE FROM phasing_poll_voter WHERE transaction_id = ?");
                 PreparedStatement preparedStatement3 = connection.prepareStatement("DELETE FROM phasing_vote WHERE transaction_id = ?");
                 PreparedStatement preparedStatement4 = connection.prepareStatement("DELETE FROM phasing_poll_linked_transaction WHERE transaction_id = ?");){
                while (dbIterator.hasNext()) {
                    long l = ((PhasingPoll)dbIterator.next()).getId();
                    preparedStatement.setLong(1, l);
                    preparedStatement.executeUpdate();
                    preparedStatement2.setLong(1, l);
                    preparedStatement2.executeUpdate();
                    preparedStatement3.setLong(1, l);
                    preparedStatement3.executeUpdate();
                    preparedStatement4.setLong(1, l);
                    preparedStatement4.executeUpdate();
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
        }
    };
    private static final DbKey.LongKeyFactory<PhasingPoll> votersDbKeyFactory = new DbKey.LongKeyFactory<PhasingPoll>("transaction_id"){

        @Override
        public DbKey newKey(PhasingPoll phasingPoll) {
            return phasingPoll.dbKey == null ? this.newKey(phasingPoll.id) : phasingPoll.dbKey;
        }
    };
    private static final ValuesDbTable<PhasingPoll, Long> votersTable = new ValuesDbTable<PhasingPoll, Long>("phasing_poll_voter", votersDbKeyFactory){

        @Override
        protected Long load(Connection connection, ResultSet resultSet) throws SQLException {
            return resultSet.getLong("voter_id");
        }

        @Override
        protected void save(Connection connection, PhasingPoll phasingPoll, Long l) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_poll_voter (transaction_id, voter_id, height) VALUES (?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, phasingPoll.getId());
                preparedStatement.setLong(++n, l);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    };
    private static final DbKey.LongKeyFactory<PhasingPoll> linkedTransactionDbKeyFactory = new DbKey.LongKeyFactory<PhasingPoll>("transaction_id"){

        @Override
        public DbKey newKey(PhasingPoll phasingPoll) {
            return phasingPoll.dbKey == null ? this.newKey(phasingPoll.id) : phasingPoll.dbKey;
        }
    };
    private static final ValuesDbTable<PhasingPoll, byte[]> linkedTransactionTable = new ValuesDbTable<PhasingPoll, byte[]>("phasing_poll_linked_transaction", linkedTransactionDbKeyFactory){

        @Override
        protected byte[] load(Connection connection, ResultSet resultSet) throws SQLException {
            return resultSet.getBytes("linked_full_hash");
        }

        @Override
        protected void save(Connection connection, PhasingPoll phasingPoll, byte[] byArray) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_poll_linked_transaction (transaction_id, linked_full_hash, linked_transaction_id, height) VALUES (?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, phasingPoll.getId());
                preparedStatement.setBytes(++n, byArray);
                preparedStatement.setLong(++n, Convert.fullHashToId(byArray));
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    };
    private static final DbKey.LongKeyFactory<PhasingPollResult> resultDbKeyFactory = new DbKey.LongKeyFactory<PhasingPollResult>("id"){

        @Override
        public DbKey newKey(PhasingPollResult phasingPollResult) {
            return phasingPollResult.dbKey;
        }
    };
    private static final EntityDbTable<PhasingPollResult> resultTable = new EntityDbTable<PhasingPollResult>("phasing_poll_result", resultDbKeyFactory){

        @Override
        protected PhasingPollResult load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new PhasingPollResult(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, PhasingPollResult phasingPollResult) throws SQLException {
            phasingPollResult.save(connection);
        }
    };
    private final DbKey dbKey;
    private final long[] whitelist;
    private final long quorum;
    private final byte[] hashedSecret;
    private final byte algorithm;

    public static HashFunction getHashFunction(byte by) {
        try {
            HashFunction hashFunction = HashFunction.getHashFunction(by);
            if (acceptedHashFunctions.contains((Object)hashFunction)) {
                return hashFunction;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static PhasingPollResult getResult(long l) {
        return resultTable.get(resultDbKeyFactory.newKey(l));
    }

    public static DbIterator<PhasingPollResult> getApproved(int n) {
        return resultTable.getManyBy(new DbClause.IntClause("height", n).and(new DbClause.BooleanClause("approved", true)), 0, -1, " ORDER BY db_id ASC ");
    }

    public static PhasingPoll getPoll(long l) {
        return phasingPollTable.get(phasingPollDbKeyFactory.newKey(l));
    }

    static DbIterator<TransactionImpl> getFinishingTransactions(int n) {
        Connection connection = null;
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT transaction.* FROM transaction, phasing_poll WHERE phasing_poll.id = transaction.id AND phasing_poll.finish_height = ? ORDER BY transaction.height, transaction.transaction_index");
            preparedStatement.setInt(1, n);
            return BlockchainImpl.getInstance().getTransactions(connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static DbIterator<TransactionImpl> getVoterPhasedTransactions(long l, int n, int n2) {
        Connection connection = null;
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT transaction.* FROM transaction, phasing_poll_voter, phasing_poll LEFT JOIN phasing_poll_result ON phasing_poll.id = phasing_poll_result.id WHERE transaction.id = phasing_poll.id AND phasing_poll.finish_height > ? AND phasing_poll.id = phasing_poll_voter.transaction_id AND phasing_poll_voter.voter_id = ? AND phasing_poll_result.id IS NULL ORDER BY transaction.height DESC, transaction.transaction_index DESC " + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setInt(++n3, Nxt.getBlockchain().getHeight());
            preparedStatement.setLong(++n3, l);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return BlockchainImpl.getInstance().getTransactions(connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static DbIterator<TransactionImpl> getHoldingPhasedTransactions(long l, VoteWeighting.VotingModel votingModel, long l2, boolean bl, int n, int n2) {
        Connection connection = null;
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT transaction.* FROM transaction, phasing_poll WHERE phasing_poll.holding_id = ? AND phasing_poll.voting_model = ? AND phasing_poll.id = transaction.id AND phasing_poll.finish_height > ? " + (l2 != 0L ? "AND phasing_poll.account_id = ? " : "") + (bl ? "AND phasing_poll.whitelist_size = 0 " : "") + "ORDER BY transaction.height DESC, transaction.transaction_index DESC " + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setByte(++n3, votingModel.getCode());
            preparedStatement.setInt(++n3, Nxt.getBlockchain().getHeight());
            if (l2 != 0L) {
                preparedStatement.setLong(++n3, l2);
            }
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return BlockchainImpl.getInstance().getTransactions(connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static DbIterator<TransactionImpl> getAccountPhasedTransactions(long l, int n, int n2) {
        Connection connection = null;
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT transaction.* FROM transaction, phasing_poll  LEFT JOIN phasing_poll_result ON phasing_poll.id = phasing_poll_result.id  WHERE phasing_poll.id = transaction.id AND (transaction.sender_id = ? OR transaction.recipient_id = ?)  AND phasing_poll_result.id IS NULL  AND phasing_poll.finish_height > ? ORDER BY transaction.height DESC, transaction.transaction_index DESC " + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setInt(++n3, Nxt.getBlockchain().getHeight());
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return BlockchainImpl.getInstance().getTransactions(connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    /*
     * Exception decompiling
     */
    public static int getAccountPhasedTransactionCount(long var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static List<? extends Transaction> getLinkedPhasedTransactions(byte[] var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static long getSenderPhasedTransactionFees(long var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void addPoll(Transaction transaction, Appendix.Phasing phasing) {
        PhasingPoll phasingPoll = new PhasingPoll(transaction, phasing);
        phasingPollTable.insert(phasingPoll);
        long[] lArray = phasingPoll.whitelist;
        if (lArray.length > 0) {
            votersTable.insert(phasingPoll, Convert.toList(lArray));
        }
        if (phasing.getLinkedFullHashes().length > 0) {
            ArrayList arrayList = new ArrayList(phasing.getLinkedFullHashes().length);
            Collections.addAll(arrayList, phasing.getLinkedFullHashes());
            linkedTransactionTable.insert(phasingPoll, arrayList);
        }
    }

    static void init() {
    }

    private PhasingPoll(Transaction transaction, Appendix.Phasing phasing) {
        super(transaction.getId(), transaction.getSenderId(), phasing.getFinishHeight(), phasing.getVoteWeighting());
        this.dbKey = phasingPollDbKeyFactory.newKey(this.id);
        this.quorum = phasing.getQuorum();
        this.whitelist = phasing.getWhitelist();
        this.hashedSecret = phasing.getHashedSecret();
        this.algorithm = phasing.getAlgorithm();
    }

    private PhasingPoll(ResultSet resultSet, DbKey dbKey) throws SQLException {
        super(resultSet);
        this.dbKey = dbKey;
        this.quorum = resultSet.getLong("quorum");
        this.whitelist = resultSet.getByte("whitelist_size") == 0 ? Convert.EMPTY_LONG : Convert.toArray(votersTable.get(votersDbKeyFactory.newKey(this)));
        this.hashedSecret = resultSet.getBytes("hashed_secret");
        this.algorithm = resultSet.getByte("algorithm");
    }

    void finish(long l) {
        PhasingPollResult phasingPollResult = new PhasingPollResult(this, l);
        resultTable.insert(phasingPollResult);
    }

    public long[] getWhitelist() {
        return this.whitelist;
    }

    public long getQuorum() {
        return this.quorum;
    }

    public byte[] getFullHash() {
        return TransactionDb.getFullHash(this.id);
    }

    public List<byte[]> getLinkedFullHashes() {
        return linkedTransactionTable.get(linkedTransactionDbKeyFactory.newKey(this));
    }

    public byte[] getHashedSecret() {
        return this.hashedSecret;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public boolean verifySecret(byte[] byArray) {
        HashFunction hashFunction = PhasingPoll.getHashFunction(this.algorithm);
        return hashFunction != null && Arrays.equals(this.hashedSecret, hashFunction.hash(byArray));
    }

    public long countVotes() {
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.NONE) {
            return 0L;
        }
        int n = Math.min(this.finishHeight, Nxt.getBlockchain().getHeight());
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.TRANSACTION) {
            int n2 = 0;
            for (byte[] byArray : this.getLinkedFullHashes()) {
                if (!TransactionDb.hasTransactionByFullHash(byArray, n)) continue;
                ++n2;
            }
            return n2;
        }
        if (this.voteWeighting.isBalanceIndependent()) {
            return PhasingVote.getVoteCount(this.id);
        }
        VoteWeighting.VotingModel votingModel = this.voteWeighting.getVotingModel();
        long l = 0L;
        try (DbIterator<PhasingVote> dbIterator = PhasingVote.getVotes(this.id, 0, Integer.MAX_VALUE);){
            for (PhasingVote phasingVote : dbIterator) {
                l += votingModel.calcWeight(this.voteWeighting, phasingVote.getVoterId(), n);
            }
        }
        return l;
    }

    boolean allowEarlyFinish() {
        return this.voteWeighting.isBalanceIndependent() && (this.whitelist.length > 0 || this.voteWeighting.getVotingModel() != VoteWeighting.VotingModel.ACCOUNT);
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_poll (id, account_id, finish_height, whitelist_size, voting_model, quorum, min_balance, holding_id, min_balance_model, hashed_secret, algorithm, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.accountId);
            preparedStatement.setInt(++n, this.finishHeight);
            preparedStatement.setByte(++n, (byte)this.whitelist.length);
            preparedStatement.setByte(++n, this.voteWeighting.getVotingModel().getCode());
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.quorum);
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.voteWeighting.getMinBalance());
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.voteWeighting.getHoldingId());
            preparedStatement.setByte(++n, this.voteWeighting.getMinBalanceModel().getCode());
            DbUtils.setBytes(preparedStatement, ++n, this.hashedSecret);
            preparedStatement.setByte(++n, this.algorithm);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public static final class PhasingPollResult {
        private final long id;
        private final DbKey dbKey;
        private final long result;
        private final boolean approved;
        private final int height;

        private PhasingPollResult(PhasingPoll phasingPoll, long l) {
            this.id = phasingPoll.getId();
            this.dbKey = resultDbKeyFactory.newKey(this.id);
            this.result = l;
            this.approved = l >= phasingPoll.getQuorum();
            this.height = Nxt.getBlockchain().getHeight();
        }

        private PhasingPollResult(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.result = resultSet.getLong("result");
            this.approved = resultSet.getBoolean("approved");
            this.height = resultSet.getInt("height");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_poll_result (id, result, approved, height) VALUES (?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setLong(++n, this.result);
                preparedStatement.setBoolean(++n, this.approved);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.id;
        }

        public long getResult() {
            return this.result;
        }

        public boolean isApproved() {
            return this.approved;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

