/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nxt.Account;
import nxt.Attachment;
import nxt.BlockchainImpl;
import nxt.BlockchainProcessor;
import nxt.BlockchainProcessorImpl;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Shuffling;
import nxt.ShufflingParticipant;
import nxt.Transaction;
import nxt.TransactionProcessorImpl;
import nxt.UnconfirmedTransaction;
import nxt.crypto.Crypto;
import nxt.db.DbIterator;
import nxt.util.Convert;
import nxt.util.Logger;

public final class Shuffler {
    private static final int MAX_SHUFFLERS = Nxt.getIntProperty("nxt.maxNumberOfShufflers");
    private static final Map<String, Map<Long, Shuffler>> shufflingsMap = new HashMap<String, Map<Long, Shuffler>>();
    private static final Map<Integer, Set<String>> expirations = new HashMap<Integer, Set<String>>();
    private final long accountId;
    private final String secretPhrase;
    private final byte[] recipientPublicKey;
    private final byte[] shufflingFullHash;
    private volatile Transaction failedTransaction;
    private volatile NxtException.NotCurrentlyValidException failureCause;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Shuffler addOrGetShuffler(String string2, byte[] byArray, byte[] byArray2) throws ShufflerException {
        String string3 = Convert.toHexString(byArray2);
        long l = Account.getId(Crypto.getPublicKey(string2));
        BlockchainImpl.getInstance().writeLock();
        try {
            Object object;
            Map map = shufflingsMap.computeIfAbsent(string3, string -> new HashMap());
            Shuffler shuffler = (Shuffler)map.get(l);
            if (byArray == null) {
                Shuffler shuffler2 = shuffler;
                return shuffler2;
            }
            if (shufflingsMap.size() > MAX_SHUFFLERS) {
                throw new ShufflerLimitException("Cannot run more than " + MAX_SHUFFLERS + " shufflers on the same node");
            }
            if (shuffler == null) {
                object = Shuffling.getShuffling(byArray2);
                if (object == null && Account.getAccount(byArray) != null) {
                    throw new InvalidRecipientException("Existing account cannot be used as shuffling recipient");
                }
                if (Shuffler.getRecipientShuffler(Account.getId(byArray)) != null) {
                    throw new InvalidRecipientException("Another shuffler with the same recipient account already running");
                }
                if (map.size() >= (object == null ? 30 : (int)((Shuffling)object).getParticipantCount())) {
                    throw new ShufflerLimitException("Cannot run shufflers for more than " + map.size() + " accounts for this shuffling");
                }
                Account account = Account.getAccount(l);
                if (account != null && account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
                    throw new ControlledAccountException("Cannot run a shuffler for an account under phasing only control");
                }
                shuffler = new Shuffler(string2, byArray, byArray2);
                if (object != null) {
                    shuffler.init((Shuffling)object);
                    Shuffler.clearExpiration((Shuffling)object);
                }
                map.put(l, shuffler);
                Logger.logMessage(String.format("Started shuffler for account %s, shuffling %s", Long.toUnsignedString(l), Long.toUnsignedString(Convert.fullHashToId(byArray2))));
            } else {
                if (!Arrays.equals(shuffler.recipientPublicKey, byArray)) {
                    throw new DuplicateShufflerException("A shuffler with different recipientPublicKey already started");
                }
                if (!Arrays.equals(shuffler.shufflingFullHash, byArray2)) {
                    throw new DuplicateShufflerException("A shuffler with different shufflingFullHash already started");
                }
                Logger.logMessage("Shuffler already started");
            }
            object = shuffler;
            return object;
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    public static List<Shuffler> getAllShufflers() {
        ArrayList<Shuffler> arrayList = new ArrayList<Shuffler>();
        BlockchainImpl.getInstance().readLock();
        try {
            shufflingsMap.values().forEach(map -> arrayList.addAll(map.values()));
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
        return arrayList;
    }

    public static List<Shuffler> getShufflingShufflers(byte[] byArray) {
        ArrayList<Shuffler> arrayList = new ArrayList<Shuffler>();
        BlockchainImpl.getInstance().readLock();
        try {
            Map<Long, Shuffler> map = shufflingsMap.get(Convert.toHexString(byArray));
            if (map != null) {
                arrayList.addAll(map.values());
            }
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
        return arrayList;
    }

    public static List<Shuffler> getAccountShufflers(long l) {
        ArrayList<Shuffler> arrayList = new ArrayList<Shuffler>();
        BlockchainImpl.getInstance().readLock();
        try {
            shufflingsMap.values().forEach(map -> {
                Shuffler shuffler = (Shuffler)map.get(l);
                if (shuffler != null) {
                    arrayList.add(shuffler);
                }
            });
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Shuffler getShuffler(long l, byte[] byArray) {
        BlockchainImpl.getInstance().readLock();
        try {
            Map<Long, Shuffler> map = shufflingsMap.get(Convert.toHexString(byArray));
            if (map != null) {
                Shuffler shuffler = map.get(l);
                return shuffler;
            }
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Shuffler stopShuffler(long l, byte[] byArray) {
        BlockchainImpl.getInstance().writeLock();
        try {
            Map<Long, Shuffler> map = shufflingsMap.get(Convert.toHexString(byArray));
            if (map != null) {
                Shuffler shuffler = map.remove(l);
                return shuffler;
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
        return null;
    }

    public static void stopAllShufflers() {
        BlockchainImpl.getInstance().writeLock();
        try {
            shufflingsMap.clear();
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Shuffler getRecipientShuffler(long l) {
        BlockchainImpl.getInstance().readLock();
        try {
            for (Map<Long, Shuffler> map : shufflingsMap.values()) {
                for (Shuffler shuffler : map.values()) {
                    if (Account.getId(shuffler.recipientPublicKey) != l) continue;
                    Shuffler shuffler2 = shuffler;
                    return shuffler2;
                }
            }
            Iterator<Map<Long, Shuffler>> iterator = null;
            return iterator;
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
    }

    private static Map<Long, Shuffler> getShufflers(Shuffling shuffling) {
        return shufflingsMap.get(Convert.toHexString(shuffling.getFullHash()));
    }

    private static void scheduleExpiration(Shuffling shuffling) {
        int n2 = Nxt.getBlockchain().getHeight() + 720;
        Set set = expirations.computeIfAbsent(n2, n -> new HashSet());
        set.add(Convert.toHexString(shuffling.getFullHash()));
    }

    private static void clearExpiration(Shuffling shuffling) {
        for (Set<String> set : expirations.values()) {
            if (!set.remove(shuffling.getId())) continue;
            return;
        }
    }

    private Shuffler(String string, byte[] byArray, byte[] byArray2) {
        this.secretPhrase = string;
        this.accountId = Account.getId(Crypto.getPublicKey(string));
        this.recipientPublicKey = byArray;
        this.shufflingFullHash = byArray2;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public byte[] getRecipientPublicKey() {
        return this.recipientPublicKey;
    }

    public byte[] getShufflingFullHash() {
        return this.shufflingFullHash;
    }

    public Transaction getFailedTransaction() {
        return this.failedTransaction;
    }

    public NxtException.NotCurrentlyValidException getFailureCause() {
        return this.failureCause;
    }

    private void init(Shuffling shuffling) throws ShufflerException {
        ShufflingParticipant shufflingParticipant = shuffling.getParticipant(this.accountId);
        switch (shuffling.getStage()) {
            case REGISTRATION: {
                if (Account.getAccount(this.recipientPublicKey) != null) {
                    throw new InvalidRecipientException("Existing account cannot be used as shuffling recipient");
                }
                if (shufflingParticipant != null) break;
                this.submitRegister(shuffling);
                break;
            }
            case PROCESSING: {
                if (shufflingParticipant == null) {
                    throw new InvalidStageException("Account has not registered for this shuffling");
                }
                if (Account.getAccount(this.recipientPublicKey) != null) {
                    throw new InvalidRecipientException("Existing account cannot be used as shuffling recipient");
                }
                if (this.accountId != shuffling.getAssigneeAccountId()) break;
                this.submitProcess(shuffling);
                break;
            }
            case VERIFICATION: {
                if (shufflingParticipant == null) {
                    throw new InvalidStageException("Account has not registered for this shuffling");
                }
                if (shufflingParticipant.getState() != ShufflingParticipant.State.PROCESSED) break;
                this.verify(shuffling);
                break;
            }
            case BLAME: {
                if (shufflingParticipant == null) {
                    throw new InvalidStageException("Account has not registered for this shuffling");
                }
                if (shufflingParticipant.getState() == ShufflingParticipant.State.CANCELLED) break;
                this.cancel(shuffling);
                break;
            }
            case DONE: 
            case CANCELLED: {
                Shuffler.scheduleExpiration(shuffling);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported shuffling stage " + (Object)((Object)shuffling.getStage()));
            }
        }
        if (this.failureCause != null) {
            throw new ShufflerException(this.failureCause.getMessage(), this.failureCause);
        }
    }

    private void verify(Shuffling shuffling) {
        ShufflingParticipant shufflingParticipant = shuffling.getParticipant(this.accountId);
        if (shufflingParticipant != null && shufflingParticipant.getIndex() != shuffling.getParticipantCount() - 1) {
            boolean bl = false;
            for (byte[] byArray : shuffling.getRecipientPublicKeys()) {
                if (!Arrays.equals(byArray, this.recipientPublicKey)) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.submitVerify(shuffling);
            } else {
                this.submitCancel(shuffling);
            }
        }
    }

    private void cancel(Shuffling shuffling) {
        if (this.accountId == shuffling.getAssigneeAccountId()) {
            return;
        }
        ShufflingParticipant shufflingParticipant = shuffling.getParticipant(this.accountId);
        if (shufflingParticipant == null || shufflingParticipant.getIndex() == shuffling.getParticipantCount() - 1) {
            return;
        }
        if (ShufflingParticipant.getData(shuffling.getId(), this.accountId) == null) {
            return;
        }
        this.submitCancel(shuffling);
    }

    private void submitRegister(Shuffling shuffling) {
        Logger.logDebugMessage("Account %s registering for shuffling %s", Long.toUnsignedString(this.accountId), Long.toUnsignedString(shuffling.getId()));
        Attachment.ShufflingRegistration shufflingRegistration = new Attachment.ShufflingRegistration(this.shufflingFullHash);
        this.submitTransaction(shufflingRegistration);
    }

    private void submitProcess(Shuffling shuffling) {
        Logger.logDebugMessage("Account %s processing shuffling %s", Long.toUnsignedString(this.accountId), Long.toUnsignedString(shuffling.getId()));
        Attachment.ShufflingAttachment shufflingAttachment = shuffling.process(this.accountId, this.secretPhrase, this.recipientPublicKey);
        this.submitTransaction(shufflingAttachment);
    }

    private void submitVerify(Shuffling shuffling) {
        Logger.logDebugMessage("Account %s verifying shuffling %s", Long.toUnsignedString(this.accountId), Long.toUnsignedString(shuffling.getId()));
        Attachment.ShufflingVerification shufflingVerification = new Attachment.ShufflingVerification(shuffling.getId(), shuffling.getStateHash());
        this.submitTransaction(shufflingVerification);
    }

    private void submitCancel(Shuffling shuffling) {
        Logger.logDebugMessage("Account %s cancelling shuffling %s", Long.toUnsignedString(this.accountId), Long.toUnsignedString(shuffling.getId()));
        Attachment.ShufflingCancellation shufflingCancellation = shuffling.revealKeySeeds(this.secretPhrase, shuffling.getAssigneeAccountId(), shuffling.getStateHash());
        this.submitTransaction(shufflingCancellation);
    }

    private void submitTransaction(Attachment.ShufflingAttachment shufflingAttachment) {
        Object object;
        Object object2;
        if (BlockchainProcessorImpl.getInstance().isProcessingBlock()) {
            if (this.hasUnconfirmedTransaction(shufflingAttachment, TransactionProcessorImpl.getInstance().getWaitingTransactions())) {
                Logger.logDebugMessage("Transaction already submitted");
                return;
            }
        } else {
            object2 = TransactionProcessorImpl.getInstance().getAllUnconfirmedTransactions();
            object = null;
            try {
                if (this.hasUnconfirmedTransaction(shufflingAttachment, (Iterable<UnconfirmedTransaction>)object2)) {
                    Logger.logDebugMessage("Transaction already submitted");
                    return;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((DbIterator)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((DbIterator)object2).close();
                    }
                }
            }
        }
        try {
            object2 = Nxt.newTransactionBuilder(Crypto.getPublicKey(this.secretPhrase), 0L, 0L, (short)1440, shufflingAttachment);
            object2.timestamp(Nxt.getBlockchain().getLastBlockTimestamp());
            object = object2.build(this.secretPhrase);
            this.failedTransaction = null;
            this.failureCause = null;
            Account account = Account.getAccount(this.accountId);
            if (account == null || object.getFeeNQT() > account.getUnconfirmedBalanceNQT()) {
                this.failedTransaction = object;
                this.failureCause = new NxtException.NotCurrentlyValidException("Insufficient balance");
                Logger.logDebugMessage("Error submitting shuffler transaction", this.failureCause);
            }
            try {
                TransactionProcessorImpl.getInstance().broadcast((Transaction)object);
            }
            catch (NxtException.NotCurrentlyValidException notCurrentlyValidException) {
                this.failedTransaction = object;
                this.failureCause = notCurrentlyValidException;
                Logger.logDebugMessage("Error submitting shuffler transaction", notCurrentlyValidException);
            }
        }
        catch (NxtException.ValidationException validationException) {
            Logger.logErrorMessage("Fatal error submitting shuffler transaction", validationException);
        }
    }

    private boolean hasUnconfirmedTransaction(Attachment.ShufflingAttachment shufflingAttachment, Iterable<UnconfirmedTransaction> iterable) {
        for (UnconfirmedTransaction unconfirmedTransaction : iterable) {
            Attachment attachment;
            if (unconfirmedTransaction.getSenderId() != this.accountId || !(attachment = unconfirmedTransaction.getAttachment()).getClass().equals(shufflingAttachment.getClass()) || !Arrays.equals(shufflingAttachment.getShufflingStateHash(), ((Attachment.ShufflingAttachment)attachment).getShufflingStateHash())) continue;
            return true;
        }
        return false;
    }

    static {
        Shuffling.addListener(shuffling -> {
            Map<Long, Shuffler> map = Shuffler.getShufflers(shuffling);
            if (map != null) {
                map.values().forEach(shuffler -> {
                    if (shuffler.accountId != shuffling.getIssuerId()) {
                        try {
                            shuffler.submitRegister((Shuffling)shuffling);
                        }
                        catch (RuntimeException runtimeException) {
                            Logger.logErrorMessage(runtimeException.toString(), runtimeException);
                        }
                    }
                });
                Shuffler.clearExpiration(shuffling);
            }
        }, Shuffling.Event.SHUFFLING_CREATED);
        Shuffling.addListener(shuffling -> {
            Map<Long, Shuffler> map = Shuffler.getShufflers(shuffling);
            if (map != null) {
                Shuffler shuffler = map.get(shuffling.getAssigneeAccountId());
                if (shuffler != null) {
                    try {
                        shuffler.submitProcess((Shuffling)shuffling);
                    }
                    catch (RuntimeException runtimeException) {
                        Logger.logErrorMessage(runtimeException.toString(), runtimeException);
                    }
                }
                Shuffler.clearExpiration(shuffling);
            }
        }, Shuffling.Event.SHUFFLING_PROCESSING_ASSIGNED);
        Shuffling.addListener(shuffling -> {
            Map<Long, Shuffler> map = Shuffler.getShufflers(shuffling);
            if (map != null) {
                map.values().forEach(shuffler -> {
                    try {
                        shuffler.verify((Shuffling)shuffling);
                    }
                    catch (RuntimeException runtimeException) {
                        Logger.logErrorMessage(runtimeException.toString(), runtimeException);
                    }
                });
                Shuffler.clearExpiration(shuffling);
            }
        }, Shuffling.Event.SHUFFLING_PROCESSING_FINISHED);
        Shuffling.addListener(shuffling -> {
            Map<Long, Shuffler> map = Shuffler.getShufflers(shuffling);
            if (map != null) {
                map.values().forEach(shuffler -> {
                    try {
                        shuffler.cancel((Shuffling)shuffling);
                    }
                    catch (RuntimeException runtimeException) {
                        Logger.logErrorMessage(runtimeException.toString(), runtimeException);
                    }
                });
                Shuffler.clearExpiration(shuffling);
            }
        }, Shuffling.Event.SHUFFLING_BLAME_STARTED);
        Shuffling.addListener(Shuffler::scheduleExpiration, Shuffling.Event.SHUFFLING_DONE);
        Shuffling.addListener(Shuffler::scheduleExpiration, Shuffling.Event.SHUFFLING_CANCELLED);
        BlockchainProcessorImpl.getInstance().addListener(block -> {
            Set<String> set = expirations.get(block.getHeight());
            if (set != null) {
                set.forEach(shufflingsMap::remove);
                expirations.remove(block.getHeight());
            }
        }, BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
        BlockchainProcessorImpl.getInstance().addListener(block -> shufflingsMap.values().forEach(map -> map.values().forEach(shuffler -> {
            if (shuffler.failedTransaction != null) {
                try {
                    TransactionProcessorImpl.getInstance().broadcast(shuffler.failedTransaction);
                    shuffler.failedTransaction = null;
                    shuffler.failureCause = null;
                }
                catch (NxtException.ValidationException validationException) {
                    // empty catch block
                }
            }
        })), BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
        BlockchainProcessorImpl.getInstance().addListener(block -> Shuffler.stopAllShufflers(), BlockchainProcessor.Event.RESCAN_BEGIN);
    }

    public static final class InvalidStageException
    extends ShufflerException {
        private InvalidStageException(String string) {
            super(string);
        }
    }

    public static final class ControlledAccountException
    extends ShufflerException {
        private ControlledAccountException(String string) {
            super(string);
        }
    }

    public static final class InvalidRecipientException
    extends ShufflerException {
        private InvalidRecipientException(String string) {
            super(string);
        }
    }

    public static final class DuplicateShufflerException
    extends ShufflerException {
        private DuplicateShufflerException(String string) {
            super(string);
        }
    }

    public static final class ShufflerLimitException
    extends ShufflerException {
        private ShufflerLimitException(String string) {
            super(string);
        }
    }

    public static class ShufflerException
    extends NxtException {
        private ShufflerException(String string) {
            super(string);
        }

        private ShufflerException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

