/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Transaction;
import nxt.TransactionProcessor;
import nxt.TransactionProcessorImpl;
import nxt.util.Filter;
import nxt.util.Logger;

public class TransactionScheduler {
    private static final Map<Transaction, TransactionScheduler> transactionSchedulers = new ConcurrentHashMap<Transaction, TransactionScheduler>();
    private final Transaction transaction;
    private final Filter<Transaction> filter;

    public static void schedule(Filter<Transaction> filter, Transaction transaction) {
        if (transactionSchedulers.size() >= 100) {
            throw new RuntimeException("Cannot schedule more than 100 transactions! Please restart your node if you want to clear existing scheduled transactions.");
        }
        transactionSchedulers.put(transaction, new TransactionScheduler(filter, transaction));
    }

    public static List<Transaction> getScheduledTransactions(long l) {
        ArrayList<Transaction> arrayList = new ArrayList<Transaction>();
        for (Transaction transaction : transactionSchedulers.keySet()) {
            if (l != 0L && transaction.getSenderId() != l) continue;
            arrayList.add(transaction);
        }
        return arrayList;
    }

    public static Transaction deleteScheduledTransaction(long l) {
        Iterator<Transaction> iterator = transactionSchedulers.keySet().iterator();
        while (iterator.hasNext()) {
            Transaction transaction = iterator.next();
            if (transaction.getId() != l) continue;
            iterator.remove();
            return transaction;
        }
        return null;
    }

    private TransactionScheduler(Filter<Transaction> filter, Transaction transaction) {
        this.transaction = transaction;
        this.filter = filter;
    }

    private boolean processEvent(Transaction transaction) {
        if (this.transaction.getExpiration() < Nxt.getEpochTime()) {
            Logger.logInfoMessage("Expired transaction in transaction scheduler " + this.transaction.getSenderId());
            return true;
        }
        if (!this.filter.ok(transaction)) {
            return false;
        }
        try {
            TransactionProcessorImpl.getInstance().broadcast(this.transaction);
            return true;
        }
        catch (NxtException.ValidationException validationException) {
            Logger.logInfoMessage("Failed to broadcast: " + validationException.getMessage());
            return true;
        }
    }

    static {
        TransactionProcessorImpl.getInstance().addListener(list -> {
            Iterator<Map.Entry<Transaction, TransactionScheduler>> iterator = transactionSchedulers.entrySet().iterator();
            block0: while (iterator.hasNext()) {
                Map.Entry<Transaction, TransactionScheduler> entry = iterator.next();
                Transaction transaction = entry.getKey();
                TransactionScheduler transactionScheduler = entry.getValue();
                for (Transaction transaction2 : list) {
                    if (!transactionScheduler.processEvent(transaction2)) continue;
                    iterator.remove();
                    Logger.logInfoMessage("Removed " + transaction.getStringId() + " from transaction scheduler");
                    continue block0;
                }
            }
        }, TransactionProcessor.Event.ADDED_UNCONFIRMED_TRANSACTIONS);
    }
}

