/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import nxt.Appendix;
import nxt.Attachment;
import nxt.Block;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Transaction;
import nxt.TransactionImpl;
import nxt.TransactionType;
import nxt.db.DbKey;
import nxt.util.Filter;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

class UnconfirmedTransaction
implements Transaction {
    private final TransactionImpl transaction;
    private final long arrivalTimestamp;
    private final long feePerByte;

    UnconfirmedTransaction(TransactionImpl transactionImpl, long l) {
        this.transaction = transactionImpl;
        this.arrivalTimestamp = l;
        this.feePerByte = transactionImpl.getFeeNQT() / (long)transactionImpl.getFullSize();
    }

    UnconfirmedTransaction(ResultSet resultSet) throws SQLException {
        try {
            byte[] byArray = resultSet.getBytes("transaction_bytes");
            JSONObject jSONObject = null;
            String string = resultSet.getString("prunable_json");
            if (string != null) {
                jSONObject = (JSONObject)JSONValue.parse((String)string);
            }
            TransactionImpl.BuilderImpl builderImpl = TransactionImpl.newTransactionBuilder(byArray, jSONObject);
            this.transaction = builderImpl.build();
            this.transaction.setHeight(resultSet.getInt("transaction_height"));
            this.arrivalTimestamp = resultSet.getLong("arrival_timestamp");
            this.feePerByte = resultSet.getLong("fee_per_byte");
        }
        catch (NxtException.ValidationException validationException) {
            throw new RuntimeException(validationException.toString(), validationException);
        }
    }

    void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO unconfirmed_transaction (id, transaction_height, fee_per_byte, expiration, transaction_bytes, prunable_json, arrival_timestamp, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.transaction.getId());
            preparedStatement.setInt(++n, this.transaction.getHeight());
            preparedStatement.setLong(++n, this.feePerByte);
            preparedStatement.setInt(++n, this.transaction.getExpiration());
            preparedStatement.setBytes(++n, this.transaction.bytes());
            JSONObject jSONObject = this.transaction.getPrunableAttachmentJSON();
            if (jSONObject != null) {
                preparedStatement.setString(++n, jSONObject.toJSONString());
            } else {
                preparedStatement.setNull(++n, 12);
            }
            preparedStatement.setLong(++n, this.arrivalTimestamp);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    TransactionImpl getTransaction() {
        return this.transaction;
    }

    long getArrivalTimestamp() {
        return this.arrivalTimestamp;
    }

    long getFeePerByte() {
        return this.feePerByte;
    }

    public boolean equals(Object object) {
        return object instanceof UnconfirmedTransaction && this.transaction.equals(((UnconfirmedTransaction)object).getTransaction());
    }

    public int hashCode() {
        return this.transaction.hashCode();
    }

    @Override
    public long getId() {
        return this.transaction.getId();
    }

    DbKey getDbKey() {
        return this.transaction.getDbKey();
    }

    @Override
    public String getStringId() {
        return this.transaction.getStringId();
    }

    @Override
    public long getSenderId() {
        return this.transaction.getSenderId();
    }

    @Override
    public byte[] getSenderPublicKey() {
        return this.transaction.getSenderPublicKey();
    }

    @Override
    public long getRecipientId() {
        return this.transaction.getRecipientId();
    }

    @Override
    public int getHeight() {
        return this.transaction.getHeight();
    }

    @Override
    public long getBlockId() {
        return this.transaction.getBlockId();
    }

    @Override
    public Block getBlock() {
        return this.transaction.getBlock();
    }

    @Override
    public int getTimestamp() {
        return this.transaction.getTimestamp();
    }

    @Override
    public int getBlockTimestamp() {
        return this.transaction.getBlockTimestamp();
    }

    @Override
    public short getDeadline() {
        return this.transaction.getDeadline();
    }

    @Override
    public int getExpiration() {
        return this.transaction.getExpiration();
    }

    @Override
    public long getAmountNQT() {
        return this.transaction.getAmountNQT();
    }

    @Override
    public long getFeeNQT() {
        return this.transaction.getFeeNQT();
    }

    @Override
    public String getReferencedTransactionFullHash() {
        return this.transaction.getReferencedTransactionFullHash();
    }

    @Override
    public byte[] getSignature() {
        return this.transaction.getSignature();
    }

    @Override
    public String getFullHash() {
        return this.transaction.getFullHash();
    }

    @Override
    public TransactionType getType() {
        return this.transaction.getType();
    }

    @Override
    public Attachment getAttachment() {
        return this.transaction.getAttachment();
    }

    @Override
    public boolean verifySignature() {
        return this.transaction.verifySignature();
    }

    @Override
    public void validate() throws NxtException.ValidationException {
        this.transaction.validate();
    }

    @Override
    public byte[] getBytes() {
        return this.transaction.getBytes();
    }

    @Override
    public byte[] getUnsignedBytes() {
        return this.transaction.getUnsignedBytes();
    }

    @Override
    public JSONObject getJSONObject() {
        return this.transaction.getJSONObject();
    }

    @Override
    public JSONObject getPrunableAttachmentJSON() {
        return this.transaction.getPrunableAttachmentJSON();
    }

    @Override
    public byte getVersion() {
        return this.transaction.getVersion();
    }

    @Override
    public int getFullSize() {
        return this.transaction.getFullSize();
    }

    @Override
    public Appendix.Message getMessage() {
        return this.transaction.getMessage();
    }

    @Override
    public Appendix.PrunablePlainMessage getPrunablePlainMessage() {
        return this.transaction.getPrunablePlainMessage();
    }

    @Override
    public Appendix.EncryptedMessage getEncryptedMessage() {
        return this.transaction.getEncryptedMessage();
    }

    @Override
    public Appendix.PrunableEncryptedMessage getPrunableEncryptedMessage() {
        return this.transaction.getPrunableEncryptedMessage();
    }

    @Override
    public Appendix.EncryptToSelfMessage getEncryptToSelfMessage() {
        return this.transaction.getEncryptToSelfMessage();
    }

    @Override
    public Appendix.Phasing getPhasing() {
        return this.transaction.getPhasing();
    }

    @Override
    public List<? extends Appendix> getAppendages() {
        return this.transaction.getAppendages();
    }

    @Override
    public List<? extends Appendix> getAppendages(boolean bl) {
        return this.transaction.getAppendages(bl);
    }

    @Override
    public List<? extends Appendix> getAppendages(Filter<Appendix> filter, boolean bl) {
        return this.transaction.getAppendages(filter, bl);
    }

    @Override
    public int getECBlockHeight() {
        return this.transaction.getECBlockHeight();
    }

    @Override
    public long getECBlockId() {
        return this.transaction.getECBlockId();
    }

    @Override
    public short getIndex() {
        return this.transaction.getIndex();
    }
}

