/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class Scrypt {
    private final Mac mac = Scrypt.createMac();
    private final byte[] H = new byte[32];
    private final byte[] B = new byte[132];
    private final int[] X = new int[32];
    private final int[] V = new int[32768];

    public byte[] hash(byte[] byArray) {
        int n;
        int n2;
        Scrypt.erase(this.H);
        Scrypt.erase(this.B);
        Scrypt.erase(this.X);
        Scrypt.erase(this.V);
        System.arraycopy(byArray, 0, this.B, 0, byArray.length);
        try {
            this.mac.init(new SecretKeySpec(this.B, 0, 40, "HmacSHA256"));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException(invalidKeyException);
        }
        this.B[40] = 0;
        this.B[41] = 0;
        this.B[42] = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            this.B[43] = (byte)(n2 + 1);
            this.mac.update(this.B, 0, 44);
            try {
                this.mac.doFinal(this.H, 0);
            }
            catch (ShortBufferException shortBufferException) {
                throw new IllegalStateException(shortBufferException);
            }
            for (n = 0; n < 8; ++n) {
                this.X[n2 * 8 + n] = (this.H[n * 4 + 0] & 0xFF) << 0 | (this.H[n * 4 + 1] & 0xFF) << 8 | (this.H[n * 4 + 2] & 0xFF) << 16 | (this.H[n * 4 + 3] & 0xFF) << 24;
            }
        }
        for (n2 = 0; n2 < 1024; ++n2) {
            System.arraycopy(this.X, 0, this.V, n2 * 32, 32);
            this.xorSalsa8(0, 16);
            this.xorSalsa8(16, 0);
        }
        for (n2 = 0; n2 < 1024; ++n2) {
            int n3 = (this.X[16] & 0x3FF) * 32;
            for (n = 0; n < 32; ++n) {
                int n4 = n;
                this.X[n4] = this.X[n4] ^ this.V[n3 + n];
            }
            this.xorSalsa8(0, 16);
            this.xorSalsa8(16, 0);
        }
        for (n2 = 0; n2 < 32; ++n2) {
            this.B[n2 * 4 + 0] = (byte)(this.X[n2] >> 0);
            this.B[n2 * 4 + 1] = (byte)(this.X[n2] >> 8);
            this.B[n2 * 4 + 2] = (byte)(this.X[n2] >> 16);
            this.B[n2 * 4 + 3] = (byte)(this.X[n2] >> 24);
        }
        this.B[131] = 1;
        this.mac.update(this.B, 0, 132);
        try {
            this.mac.doFinal(this.H, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalStateException(shortBufferException);
        }
        return this.H;
    }

    private void xorSalsa8(int n, int n2) {
        int n3 = n + 0;
        int n4 = this.X[n3] ^ this.X[n2 + 0];
        this.X[n3] = n4;
        int n5 = n4;
        int n6 = n + 1;
        int n7 = this.X[n6] ^ this.X[n2 + 1];
        this.X[n6] = n7;
        int n8 = n7;
        int n9 = n + 2;
        int n10 = this.X[n9] ^ this.X[n2 + 2];
        this.X[n9] = n10;
        int n11 = n10;
        int n12 = n + 3;
        int n13 = this.X[n12] ^ this.X[n2 + 3];
        this.X[n12] = n13;
        int n14 = n13;
        int n15 = n + 4;
        int n16 = this.X[n15] ^ this.X[n2 + 4];
        this.X[n15] = n16;
        int n17 = n16;
        int n18 = n + 5;
        int n19 = this.X[n18] ^ this.X[n2 + 5];
        this.X[n18] = n19;
        int n20 = n19;
        int n21 = n + 6;
        int n22 = this.X[n21] ^ this.X[n2 + 6];
        this.X[n21] = n22;
        int n23 = n22;
        int n24 = n + 7;
        int n25 = this.X[n24] ^ this.X[n2 + 7];
        this.X[n24] = n25;
        int n26 = n25;
        int n27 = n + 8;
        int n28 = this.X[n27] ^ this.X[n2 + 8];
        this.X[n27] = n28;
        int n29 = n28;
        int n30 = n + 9;
        int n31 = this.X[n30] ^ this.X[n2 + 9];
        this.X[n30] = n31;
        int n32 = n31;
        int n33 = n + 10;
        int n34 = this.X[n33] ^ this.X[n2 + 10];
        this.X[n33] = n34;
        int n35 = n34;
        int n36 = n + 11;
        int n37 = this.X[n36] ^ this.X[n2 + 11];
        this.X[n36] = n37;
        int n38 = n37;
        int n39 = n + 12;
        int n40 = this.X[n39] ^ this.X[n2 + 12];
        this.X[n39] = n40;
        int n41 = n40;
        int n42 = n + 13;
        int n43 = this.X[n42] ^ this.X[n2 + 13];
        this.X[n42] = n43;
        int n44 = n43;
        int n45 = n + 14;
        int n46 = this.X[n45] ^ this.X[n2 + 14];
        this.X[n45] = n46;
        int n47 = n46;
        int n48 = n + 15;
        int n49 = this.X[n48] ^ this.X[n2 + 15];
        this.X[n48] = n49;
        int n50 = n49;
        for (int i = 0; i < 8; i += 2) {
            n29 ^= Integer.rotateLeft((n17 ^= Integer.rotateLeft(n5 + n41, 7)) + n5, 9);
            n5 ^= Integer.rotateLeft((n41 ^= Integer.rotateLeft(n29 + n17, 13)) + n29, 18);
            n44 ^= Integer.rotateLeft((n32 ^= Integer.rotateLeft(n20 + n8, 7)) + n20, 9);
            n20 ^= Integer.rotateLeft((n8 ^= Integer.rotateLeft(n44 + n32, 13)) + n44, 18);
            n11 ^= Integer.rotateLeft((n47 ^= Integer.rotateLeft(n35 + n23, 7)) + n35, 9);
            n35 ^= Integer.rotateLeft((n23 ^= Integer.rotateLeft(n11 + n47, 13)) + n11, 18);
            n26 ^= Integer.rotateLeft((n14 ^= Integer.rotateLeft(n50 + n38, 7)) + n50, 9);
            n50 ^= Integer.rotateLeft((n38 ^= Integer.rotateLeft(n26 + n14, 13)) + n26, 18);
            n11 ^= Integer.rotateLeft((n8 ^= Integer.rotateLeft(n5 + n14, 7)) + n5, 9);
            n5 ^= Integer.rotateLeft((n14 ^= Integer.rotateLeft(n11 + n8, 13)) + n11, 18);
            n26 ^= Integer.rotateLeft((n23 ^= Integer.rotateLeft(n20 + n17, 7)) + n20, 9);
            n20 ^= Integer.rotateLeft((n17 ^= Integer.rotateLeft(n26 + n23, 13)) + n26, 18);
            n29 ^= Integer.rotateLeft((n38 ^= Integer.rotateLeft(n35 + n32, 7)) + n35, 9);
            n35 ^= Integer.rotateLeft((n32 ^= Integer.rotateLeft(n29 + n38, 13)) + n29, 18);
            n44 ^= Integer.rotateLeft((n41 ^= Integer.rotateLeft(n50 + n47, 7)) + n50, 9);
            n50 ^= Integer.rotateLeft((n47 ^= Integer.rotateLeft(n44 + n41, 13)) + n44, 18);
        }
        int n51 = n + 0;
        this.X[n51] = this.X[n51] + n5;
        int n52 = n + 1;
        this.X[n52] = this.X[n52] + n8;
        int n53 = n + 2;
        this.X[n53] = this.X[n53] + n11;
        int n54 = n + 3;
        this.X[n54] = this.X[n54] + n14;
        int n55 = n + 4;
        this.X[n55] = this.X[n55] + n17;
        int n56 = n + 5;
        this.X[n56] = this.X[n56] + n20;
        int n57 = n + 6;
        this.X[n57] = this.X[n57] + n23;
        int n58 = n + 7;
        this.X[n58] = this.X[n58] + n26;
        int n59 = n + 8;
        this.X[n59] = this.X[n59] + n29;
        int n60 = n + 9;
        this.X[n60] = this.X[n60] + n32;
        int n61 = n + 10;
        this.X[n61] = this.X[n61] + n35;
        int n62 = n + 11;
        this.X[n62] = this.X[n62] + n38;
        int n63 = n + 12;
        this.X[n63] = this.X[n63] + n41;
        int n64 = n + 13;
        this.X[n64] = this.X[n64] + n44;
        int n65 = n + 14;
        this.X[n65] = this.X[n65] + n47;
        int n66 = n + 15;
        this.X[n66] = this.X[n66] + n50;
    }

    private static void erase(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    private static void erase(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
    }

    private static Mac createMac() {
        try {
            return Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }
}

