/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import nxt.Constants;
import nxt.Nxt;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.FullTextTrigger;
import nxt.db.TrimmableDbTable;
import nxt.util.Logger;

public abstract class EntityDbTable<T>
extends TrimmableDbTable<T> {
    private final String defaultSort;
    private final String fullTextSearchColumns;

    protected EntityDbTable(String string, DbKey.Factory<T> factory) {
        this(string, factory, false, null);
    }

    protected EntityDbTable(String string, DbKey.Factory<T> factory, String string2) {
        this(string, factory, false, string2);
    }

    EntityDbTable(String string, DbKey.Factory<T> factory, boolean bl, String string2) {
        super(string, factory, bl);
        this.defaultSort = " ORDER BY " + (bl ? factory.getPKColumns() : " height DESC, db_id DESC ");
        this.fullTextSearchColumns = string2;
    }

    protected abstract T load(Connection var1, ResultSet var2, DbKey var3) throws SQLException;

    protected abstract void save(Connection var1, T var2) throws SQLException;

    protected String defaultSort() {
        return this.defaultSort;
    }

    protected void clearCache() {
        db.clearCache(this.table);
    }

    public void checkAvailable(int n) {
        if (this.multiversion) {
            int n2;
            int n3 = n2 = this.isPersistent() && Nxt.getBlockchainProcessor().isScanning() ? Math.max(Nxt.getBlockchainProcessor().getInitialScanHeight() - Constants.MAX_ROLLBACK, 0) : Nxt.getBlockchainProcessor().getMinRollbackHeight();
            if (n < n2) {
                throw new IllegalArgumentException("Historical data as of height " + n + " not available.");
            }
        }
        if (n > Nxt.getBlockchain().getHeight()) {
            throw new IllegalArgumentException("Height " + n + " exceeds blockchain height " + Nxt.getBlockchain().getHeight());
        }
    }

    public final T newEntity(DbKey dbKey) {
        Object object;
        boolean bl = db.isInTransaction();
        if (bl && (object = db.getCache(this.table).get(dbKey)) != null) {
            return object;
        }
        object = this.dbKeyFactory.newEntity(dbKey);
        if (bl) {
            db.getCache(this.table).put(dbKey, object);
        }
        return object;
    }

    public final T get(DbKey dbKey) {
        return this.get(dbKey, true);
    }

    /*
     * Exception decompiling
     */
    public final T get(DbKey var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final T get(DbKey var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final T getBy(DbClause var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final T getBy(DbClause var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private T get(Connection connection, PreparedStatement preparedStatement, boolean bl) throws SQLException {
        boolean bl2 = bl && db.isInTransaction();
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            if (!resultSet.next()) {
                T t = null;
                return t;
            }
            Object object = null;
            DbKey dbKey = null;
            if (bl2) {
                dbKey = this.dbKeyFactory.newKey(resultSet);
                object = db.getCache(this.table).get(dbKey);
            }
            if (object == null) {
                object = this.load(connection, resultSet, dbKey);
                if (bl2) {
                    db.getCache(this.table).put(dbKey, object);
                }
            }
            if (resultSet.next()) {
                throw new RuntimeException("Multiple records found");
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public final DbIterator<T> getManyBy(DbClause dbClause, int n, int n2) {
        return this.getManyBy(dbClause, n, n2, this.defaultSort());
    }

    public final DbIterator<T> getManyBy(DbClause dbClause, int n, int n2, String string) {
        Connection connection = null;
        try {
            connection = db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + " WHERE " + dbClause.getClause() + (this.multiversion ? " AND latest = TRUE " : " ") + string + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            ++n3;
            n3 = dbClause.set(preparedStatement, n3);
            n3 = DbUtils.setLimits(n3, preparedStatement, n, n2);
            return this.getManyBy(connection, preparedStatement, true);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public final DbIterator<T> getManyBy(DbClause dbClause, int n, int n2, int n3) {
        return this.getManyBy(dbClause, n, n2, n3, this.defaultSort());
    }

    public final DbIterator<T> getManyBy(DbClause dbClause, int n, int n2, int n3, String string) {
        if (n < 0 || this.doesNotExceed(n)) {
            return this.getManyBy(dbClause, n2, n3, string);
        }
        this.checkAvailable(n);
        Connection connection = null;
        try {
            connection = db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + " AS a WHERE " + dbClause.getClause() + "AND a.height <= ?" + (this.multiversion ? " AND (a.latest = TRUE OR (a.latest = FALSE AND EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE " + this.dbKeyFactory.getSelfJoinClause() + " AND b.height > ?) AND NOT EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE " + this.dbKeyFactory.getSelfJoinClause() + " AND b.height <= ? AND b.height > a.height))) " : " ") + string + DbUtils.limitsClause(n2, n3));
            int n4 = 0;
            ++n4;
            n4 = dbClause.set(preparedStatement, n4);
            preparedStatement.setInt(n4, n);
            if (this.multiversion) {
                preparedStatement.setInt(++n4, n);
                preparedStatement.setInt(++n4, n);
            }
            ++n4;
            n4 = DbUtils.setLimits(n4, preparedStatement, n2, n3);
            return this.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public final DbIterator<T> getManyBy(Connection connection2, PreparedStatement preparedStatement, boolean bl) {
        boolean bl2 = bl && db.isInTransaction();
        return new DbIterator<Object>(connection2, preparedStatement, (connection, resultSet) -> {
            Object object = null;
            DbKey dbKey = null;
            if (bl2) {
                dbKey = this.dbKeyFactory.newKey(resultSet);
                object = db.getCache(this.table).get(dbKey);
            }
            if (object == null) {
                object = this.load(connection, resultSet, dbKey);
                if (bl2) {
                    db.getCache(this.table).put(dbKey, object);
                }
            }
            return object;
        });
    }

    public final DbIterator<T> search(String string, DbClause dbClause, int n, int n2) {
        return this.search(string, dbClause, n, n2, " ORDER BY ft.score DESC ");
    }

    public final DbIterator<T> search(String string, DbClause dbClause, int n, int n2, String string2) {
        Connection connection = null;
        try {
            connection = db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT " + this.table + ".*, ft.score FROM " + this.table + ", ftl_search('PUBLIC', '" + this.table + "', ?, 2147483647, 0) ft  WHERE " + this.table + ".db_id = ft.keys[1] " + (this.multiversion ? " AND " + this.table + ".latest = TRUE " : " ") + " AND " + dbClause.getClause() + string2 + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setString(++n3, string);
            ++n3;
            n3 = dbClause.set(preparedStatement, n3);
            n3 = DbUtils.setLimits(n3, preparedStatement, n, n2);
            return this.getManyBy(connection, preparedStatement, true);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public final DbIterator<T> getAll(int n, int n2) {
        return this.getAll(n, n2, this.defaultSort());
    }

    public final DbIterator<T> getAll(int n, int n2, String string) {
        Connection connection = null;
        try {
            connection = db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + (this.multiversion ? " WHERE latest = TRUE " : " ") + string + DbUtils.limitsClause(n, n2));
            DbUtils.setLimits(1, preparedStatement, n, n2);
            return this.getManyBy(connection, preparedStatement, true);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public final DbIterator<T> getAll(int n, int n2, int n3) {
        return this.getAll(n, n2, n3, this.defaultSort());
    }

    public final DbIterator<T> getAll(int n, int n2, int n3, String string) {
        if (n < 0 || this.doesNotExceed(n)) {
            return this.getAll(n2, n3, string);
        }
        this.checkAvailable(n);
        Connection connection = null;
        try {
            connection = db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + " AS a WHERE height <= ?" + (this.multiversion ? " AND (latest = TRUE OR (latest = FALSE AND EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE b.height > ? AND " + this.dbKeyFactory.getSelfJoinClause() + ") AND NOT EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE b.height <= ? AND " + this.dbKeyFactory.getSelfJoinClause() + " AND b.height > a.height))) " : " ") + string + DbUtils.limitsClause(n2, n3));
            int n4 = 0;
            preparedStatement.setInt(++n4, n);
            if (this.multiversion) {
                preparedStatement.setInt(++n4, n);
                preparedStatement.setInt(++n4, n);
            }
            ++n4;
            n4 = DbUtils.setLimits(n4, preparedStatement, n2, n3);
            return this.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    /*
     * Exception decompiling
     */
    public final int getCount() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final int getCount(DbClause var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final int getCount(DbClause dbClause, int n) {
        if (n < 0 || this.doesNotExceed(n)) {
            return this.getCount(dbClause);
        }
        this.checkAvailable(n);
        Connection connection = null;
        try {
            connection = db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(*) FROM " + this.table + " AS a WHERE " + dbClause.getClause() + "AND a.height <= ?" + (this.multiversion ? " AND (a.latest = TRUE OR (a.latest = FALSE AND EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE " + this.dbKeyFactory.getSelfJoinClause() + " AND b.height > ?) AND NOT EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE " + this.dbKeyFactory.getSelfJoinClause() + " AND b.height <= ? AND b.height > a.height))) " : " "));
            int n2 = 0;
            ++n2;
            n2 = dbClause.set(preparedStatement, n2);
            preparedStatement.setInt(n2, n);
            if (this.multiversion) {
                preparedStatement.setInt(++n2, n);
                preparedStatement.setInt(++n2, n);
            }
            return this.getCount(preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    /*
     * Exception decompiling
     */
    public final int getRowCount() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getCount(PreparedStatement preparedStatement) throws SQLException {
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            resultSet.next();
            int n = resultSet.getInt(1);
            return n;
        }
    }

    public final void insert(T t) {
        if (!db.isInTransaction()) {
            throw new IllegalStateException("Not in transaction");
        }
        DbKey dbKey = this.dbKeyFactory.newKey(t);
        if (dbKey == null) {
            throw new RuntimeException("DbKey not set");
        }
        Object object = db.getCache(this.table).get(dbKey);
        if (object == null) {
            db.getCache(this.table).put(dbKey, t);
        } else if (t != object) {
            Logger.logDebugMessage("In cache : " + object.toString() + ", inserting " + t.toString());
            throw new IllegalStateException("Different instance found in Db cache, perhaps trying to save an object that was read outside the current transaction");
        }
        try (Connection connection = db.getConnection();){
            if (this.multiversion) {
                try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE " + this.table + " SET latest = FALSE " + this.dbKeyFactory.getPKClause() + " AND latest = TRUE LIMIT 1");){
                    dbKey.setPK(preparedStatement);
                    preparedStatement.executeUpdate();
                }
            }
            this.save(connection, t);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    @Override
    public final void createSearchIndex(Connection connection) throws SQLException {
        if (this.fullTextSearchColumns != null) {
            Logger.logDebugMessage("Creating search index on " + this.table + " (" + this.fullTextSearchColumns + ")");
            FullTextTrigger.createIndex(connection, "PUBLIC", this.table.toUpperCase(Locale.ROOT), this.fullTextSearchColumns.toUpperCase(Locale.ROOT));
        }
    }

    private boolean doesNotExceed(int n) {
        return Nxt.getBlockchain().getHeight() <= n && (!this.isPersistent() || !Nxt.getBlockchainProcessor().isScanning());
    }
}

