/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nxt.Nxt;
import nxt.db.BasicDb;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.FilteredConnection;
import nxt.db.FilteredFactory;
import nxt.db.FilteredPreparedStatement;
import nxt.db.FilteredStatement;
import nxt.util.Logger;

public class TransactionalDb
extends BasicDb {
    private static final DbFactory factory = new DbFactory();
    private static final long stmtThreshold;
    private static final long txThreshold;
    private static final long txInterval;
    private final ThreadLocal<DbConnection> localConnection = new ThreadLocal();
    private final ThreadLocal<Map<String, Map<DbKey, Object>>> transactionCaches = new ThreadLocal();
    private final ThreadLocal<Set<TransactionCallback>> transactionCallback = new ThreadLocal();
    private volatile long txTimes = 0L;
    private volatile long txCount = 0L;
    private volatile long statsTime = 0L;

    public TransactionalDb(BasicDb.DbProperties dbProperties) {
        super(dbProperties);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = this.localConnection.get();
        if (connection != null) {
            return connection;
        }
        return new DbConnection(super.getConnection());
    }

    public boolean isInTransaction() {
        return this.localConnection.get() != null;
    }

    public Connection beginTransaction() {
        if (this.localConnection.get() != null) {
            throw new IllegalStateException("Transaction already in progress");
        }
        try {
            Connection connection = this.getPooledConnection();
            connection.setAutoCommit(false);
            connection = new DbConnection(connection);
            ((DbConnection)connection).txStart = System.currentTimeMillis();
            this.localConnection.set((DbConnection)connection);
            this.transactionCaches.set(new HashMap());
            return connection;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public void commitTransaction() {
        DbConnection dbConnection = this.localConnection.get();
        if (dbConnection == null) {
            throw new IllegalStateException("Not in transaction");
        }
        try {
            dbConnection.doCommit();
            Set<TransactionCallback> set = this.transactionCallback.get();
            if (set != null) {
                set.forEach(TransactionCallback::commit);
                this.transactionCallback.set(null);
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public void rollbackTransaction() {
        DbConnection dbConnection = this.localConnection.get();
        if (dbConnection == null) {
            throw new IllegalStateException("Not in transaction");
        }
        try {
            dbConnection.doRollback();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            this.transactionCaches.get().clear();
            Set<TransactionCallback> set = this.transactionCallback.get();
            if (set != null) {
                set.forEach(TransactionCallback::rollback);
                this.transactionCallback.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        Connection connection = this.localConnection.get();
        if (connection == null) {
            throw new IllegalStateException("Not in transaction");
        }
        this.localConnection.set(null);
        this.transactionCaches.set(null);
        long l = System.currentTimeMillis();
        long l2 = l - ((DbConnection)connection).txStart;
        if (l2 >= txThreshold) {
            TransactionalDb.logThreshold(String.format("Database transaction required %.3f seconds at height %d", (double)l2 / 1000.0, Nxt.getBlockchain().getHeight()));
        } else {
            long l3;
            long l4;
            boolean bl = false;
            TransactionalDb transactionalDb = this;
            synchronized (transactionalDb) {
                l4 = ++this.txCount;
                l3 = this.txTimes += l2;
                if (l - this.statsTime >= txInterval) {
                    bl = true;
                    this.txCount = 0L;
                    this.txTimes = 0L;
                    this.statsTime = l;
                }
            }
            if (bl) {
                Logger.logDebugMessage(String.format("Average database transaction time is %.3f seconds", (double)l3 / 1000.0 / (double)l4));
            }
        }
        DbUtils.close(connection);
    }

    public void registerCallback(TransactionCallback transactionCallback) {
        Set<TransactionCallback> set = this.transactionCallback.get();
        if (set == null) {
            set = new HashSet<TransactionCallback>();
            this.transactionCallback.set(set);
        }
        set.add(transactionCallback);
    }

    Map<DbKey, Object> getCache(String string2) {
        if (!this.isInTransaction()) {
            throw new IllegalStateException("Not in transaction");
        }
        return this.transactionCaches.get().computeIfAbsent(string2, string -> new HashMap());
    }

    void clearCache(String string) {
        Map<DbKey, Object> map = this.transactionCaches.get().get(string);
        if (map != null) {
            map.clear();
        }
    }

    public void clearCache() {
        this.transactionCaches.get().values().forEach(Map::clear);
    }

    private static void logThreshold(String string) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append(string).append('\n');
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        boolean bl = true;
        for (int i = 3; i < stackTraceElementArray.length && (string2 = stackTraceElementArray[i].toString()).startsWith("nxt."); ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append('\n');
            }
            stringBuilder.append("  ").append(string2);
        }
        Logger.logDebugMessage(stringBuilder.toString());
    }

    static {
        long l = Nxt.getIntProperty("nxt.statementLogThreshold");
        stmtThreshold = l != 0L ? l : 1000L;
        l = Nxt.getIntProperty("nxt.transactionLogThreshold");
        txThreshold = l != 0L ? l : 5000L;
        l = Nxt.getIntProperty("nxt.transactionLogInterval");
        txInterval = l != 0L ? l * 60L * 1000L : 900000L;
    }

    public static interface TransactionCallback {
        public void commit();

        public void rollback();
    }

    private static final class DbFactory
    implements FilteredFactory {
        private DbFactory() {
        }

        @Override
        public Statement createStatement(Statement statement) {
            return new DbStatement(statement);
        }

        @Override
        public PreparedStatement createPreparedStatement(PreparedStatement preparedStatement, String string) {
            return new DbPreparedStatement(preparedStatement, string);
        }
    }

    private static final class DbPreparedStatement
    extends FilteredPreparedStatement {
        private DbPreparedStatement(PreparedStatement preparedStatement, String string) {
            super(preparedStatement, string);
        }

        @Override
        public boolean execute() throws SQLException {
            long l = System.currentTimeMillis();
            boolean bl = super.execute();
            long l2 = System.currentTimeMillis() - l;
            if (l2 > stmtThreshold) {
                TransactionalDb.logThreshold(String.format("SQL statement required %.3f seconds at height %d:\n%s", (double)l2 / 1000.0, Nxt.getBlockchain().getHeight(), this.getSQL()));
            }
            return bl;
        }

        @Override
        public ResultSet executeQuery() throws SQLException {
            long l = System.currentTimeMillis();
            ResultSet resultSet = super.executeQuery();
            long l2 = System.currentTimeMillis() - l;
            if (l2 > stmtThreshold) {
                TransactionalDb.logThreshold(String.format("SQL statement required %.3f seconds at height %d:\n%s", (double)l2 / 1000.0, Nxt.getBlockchain().getHeight(), this.getSQL()));
            }
            return resultSet;
        }

        @Override
        public int executeUpdate() throws SQLException {
            long l = System.currentTimeMillis();
            int n = super.executeUpdate();
            long l2 = System.currentTimeMillis() - l;
            if (l2 > stmtThreshold) {
                TransactionalDb.logThreshold(String.format("SQL statement required %.3f seconds at height %d:\n%s", (double)l2 / 1000.0, Nxt.getBlockchain().getHeight(), this.getSQL()));
            }
            return n;
        }
    }

    private static final class DbStatement
    extends FilteredStatement {
        private DbStatement(Statement statement) {
            super(statement);
        }

        @Override
        public boolean execute(String string) throws SQLException {
            long l = System.currentTimeMillis();
            boolean bl = super.execute(string);
            long l2 = System.currentTimeMillis() - l;
            if (l2 > stmtThreshold) {
                TransactionalDb.logThreshold(String.format("SQL statement required %.3f seconds at height %d:\n%s", (double)l2 / 1000.0, Nxt.getBlockchain().getHeight(), string));
            }
            return bl;
        }

        @Override
        public ResultSet executeQuery(String string) throws SQLException {
            long l = System.currentTimeMillis();
            ResultSet resultSet = super.executeQuery(string);
            long l2 = System.currentTimeMillis() - l;
            if (l2 > stmtThreshold) {
                TransactionalDb.logThreshold(String.format("SQL statement required %.3f seconds at height %d:\n%s", (double)l2 / 1000.0, Nxt.getBlockchain().getHeight(), string));
            }
            return resultSet;
        }

        @Override
        public int executeUpdate(String string) throws SQLException {
            long l = System.currentTimeMillis();
            int n = super.executeUpdate(string);
            long l2 = System.currentTimeMillis() - l;
            if (l2 > stmtThreshold) {
                TransactionalDb.logThreshold(String.format("SQL statement required %.3f seconds at height %d:\n%s", (double)l2 / 1000.0, Nxt.getBlockchain().getHeight(), string));
            }
            return n;
        }
    }

    private final class DbConnection
    extends FilteredConnection {
        long txStart;

        private DbConnection(Connection connection) {
            super(connection, factory);
            this.txStart = 0L;
        }

        @Override
        public void setAutoCommit(boolean bl) {
            throw new UnsupportedOperationException("Use Db.beginTransaction() to start a new transaction");
        }

        @Override
        public void commit() throws SQLException {
            if (TransactionalDb.this.localConnection.get() == null) {
                super.commit();
            } else {
                if (this != TransactionalDb.this.localConnection.get()) {
                    throw new IllegalStateException("Previous connection not committed");
                }
                TransactionalDb.this.commitTransaction();
            }
        }

        private void doCommit() throws SQLException {
            super.commit();
        }

        @Override
        public void rollback() throws SQLException {
            if (TransactionalDb.this.localConnection.get() == null) {
                super.rollback();
            } else {
                if (this != TransactionalDb.this.localConnection.get()) {
                    throw new IllegalStateException("Previous connection not committed");
                }
                TransactionalDb.this.rollbackTransaction();
            }
        }

        private void doRollback() throws SQLException {
            super.rollback();
        }

        @Override
        public void close() throws SQLException {
            if (TransactionalDb.this.localConnection.get() == null) {
                super.close();
            } else if (this != TransactionalDb.this.localConnection.get()) {
                throw new IllegalStateException("Previous connection not committed");
            }
        }
    }
}

