/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import nxt.http.APIConnector;
import nxt.util.Logger;
import nxt.util.MultipartUtility;
import nxt.util.TrustAllSSLProvider;

public class APIRemoteConnector
implements APIConnector {
    private final Map<String, List<String>> params;
    private final Map<String, byte[]> parts;
    private final URL url;

    APIRemoteConnector(Map<String, List<String>> map, Map<String, byte[]> map2, URL uRL, boolean bl) {
        this.params = map;
        this.parts = map2;
        this.url = uRL;
        if (uRL.getProtocol().equals("https") && bl) {
            HttpsURLConnection.setDefaultSSLSocketFactory(TrustAllSSLProvider.getSslSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(TrustAllSSLProvider.getHostNameVerifier());
        }
    }

    @Override
    public InputStream getInputStream() {
        if (!this.parts.isEmpty()) {
            return this.sendMultipartRequest();
        }
        return this.sendPostRequest();
    }

    private InputStream sendMultipartRequest() {
        MultipartUtility multipartUtility = new MultipartUtility(this.url, StandardCharsets.UTF_8);
        this.params.forEach((string, list) -> list.forEach(string2 -> multipartUtility.addFormField((String)string, (String)string2)));
        this.parts.forEach((string, byArray) -> multipartUtility.addFilePart((String)string, (String)string, (byte[])byArray));
        return multipartUtility.finish();
    }

    private InputStream sendPostRequest() {
        try {
            byte[] byArray = APIRemoteConnector.paramsToQueryString(this.params).getBytes(StandardCharsets.UTF_8);
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(byArray.length));
            httpURLConnection.setDoOutput(true);
            httpURLConnection.getOutputStream().write(byArray);
            if (httpURLConnection.getResponseCode() == 200) {
                return httpURLConnection.getInputStream();
            }
            Logger.logInfoMessage("response code %d", httpURLConnection.getResponseCode());
            throw new IllegalStateException("Connection failed response code " + httpURLConnection.getResponseCode());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static String paramsToQueryString(Map<String, List<String>> map) {
        return map.entrySet().stream().map(entry -> ((List)entry.getValue()).stream().map(string -> APIRemoteConnector.urlEncode((String)entry.getKey()) + '=' + APIRemoteConnector.urlEncode(string)).collect(Collectors.joining("&"))).collect(Collectors.joining("&"));
    }

    private static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }
}

