/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.DigitalGoodsStore;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class DGSPriceChange
extends CreateTransaction {
    static final DGSPriceChange instance = new DGSPriceChange();

    private DGSPriceChange() {
        super(new APITag[]{APITag.DGS, APITag.CREATE_TRANSACTION}, "goods", "priceNQT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        DigitalGoodsStore.Goods goods = ParameterParser.getGoods(httpServletRequest);
        long l = ParameterParser.getPriceNQT(httpServletRequest);
        if (goods.isDelisted() || goods.getSellerId() != account.getId()) {
            return JSONResponses.UNKNOWN_GOODS;
        }
        Attachment.DigitalGoodsPriceChange digitalGoodsPriceChange = new Attachment.DigitalGoodsPriceChange(goods.getId(), l);
        return this.createTransaction(httpServletRequest, account, digitalGoodsPriceChange);
    }
}

