/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Asset;
import nxt.Attachment;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class DeleteAssetShares
extends CreateTransaction {
    static final DeleteAssetShares instance = new DeleteAssetShares();

    private DeleteAssetShares() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "asset", "quantityQNT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Asset asset = ParameterParser.getAsset(httpServletRequest);
        long l = ParameterParser.getQuantityQNT(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Attachment.ColoredCoinsAssetDelete coloredCoinsAssetDelete = new Attachment.ColoredCoinsAssetDelete(asset.getId(), l);
        try {
            return this.createTransaction(httpServletRequest, account, coloredCoinsAssetDelete);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_ASSETS;
        }
    }
}

