/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.AccountLedger;
import nxt.Block;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Nxt;
import nxt.http.API;
import nxt.http.APIProxy;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.peer.Peer;
import nxt.peer.Peers;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class GetBlockchainStatus
extends APIServlet.APIRequestHandler {
    static final GetBlockchainStatus instance = new GetBlockchainStatus();

    private GetBlockchainStatus() {
        super(new APITag[]{APITag.BLOCKS, APITag.INFO}, new String[0]);
    }

    protected JSONObject processRequest(HttpServletRequest httpServletRequest) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"application", (Object)"NRS");
        jSONObject.put((Object)"version", (Object)"1.12.2");
        jSONObject.put((Object)"time", (Object)Nxt.getEpochTime());
        Block block = Nxt.getBlockchain().getLastBlock();
        jSONObject.put((Object)"lastBlock", (Object)block.getStringId());
        jSONObject.put((Object)"cumulativeDifficulty", (Object)block.getCumulativeDifficulty().toString());
        jSONObject.put((Object)"numberOfBlocks", (Object)(block.getHeight() + 1));
        BlockchainProcessor blockchainProcessor = Nxt.getBlockchainProcessor();
        Peer peer = blockchainProcessor.getLastBlockchainFeeder();
        jSONObject.put((Object)"lastBlockchainFeeder", (Object)(peer == null ? null : peer.getAnnouncedAddress()));
        jSONObject.put((Object)"lastBlockchainFeederHeight", (Object)blockchainProcessor.getLastBlockchainFeederHeight());
        jSONObject.put((Object)"isScanning", (Object)blockchainProcessor.isScanning());
        jSONObject.put((Object)"isDownloading", (Object)blockchainProcessor.isDownloading());
        jSONObject.put((Object)"maxRollback", (Object)Constants.MAX_ROLLBACK);
        jSONObject.put((Object)"currentMinRollbackHeight", (Object)Nxt.getBlockchainProcessor().getMinRollbackHeight());
        jSONObject.put((Object)"isTestnet", (Object)Constants.isTestnet);
        jSONObject.put((Object)"maxPrunableLifetime", (Object)Constants.MAX_PRUNABLE_LIFETIME);
        jSONObject.put((Object)"includeExpiredPrunable", (Object)Constants.INCLUDE_EXPIRED_PRUNABLE);
        jSONObject.put((Object)"correctInvalidFees", (Object)Constants.correctInvalidFees);
        jSONObject.put((Object)"ledgerTrimKeep", (Object)AccountLedger.trimKeep);
        JSONArray jSONArray = new JSONArray();
        Peers.getServices().forEach(service -> jSONArray.add((Object)service.name()));
        jSONObject.put((Object)"services", (Object)jSONArray);
        if (APIProxy.isActivated()) {
            String string = APIProxy.getInstance().getMainPeerAnnouncedAddress();
            jSONObject.put((Object)"apiProxy", (Object)true);
            jSONObject.put((Object)"apiProxyPeer", (Object)string);
        } else {
            jSONObject.put((Object)"apiProxy", (Object)false);
        }
        jSONObject.put((Object)"isLightClient", (Object)Constants.isLightClient);
        jSONObject.put((Object)"maxAPIRecords", (Object)API.maxRecords);
        jSONObject.put((Object)"blockchainState", (Object)Peers.getMyBlockchainState());
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }
}

