/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.DigitalGoodsStore;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetDGSTagsLike
extends APIServlet.APIRequestHandler {
    static final GetDGSTagsLike instance = new GetDGSTagsLike();

    private GetDGSTagsLike() {
        super(new APITag[]{APITag.DGS, APITag.SEARCH}, "tagPrefix", "inStockOnly", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("inStockOnly"));
        String string = Convert.emptyToNull(httpServletRequest.getParameter("tagPrefix"));
        if (string == null) {
            return JSONResponses.missing("tagPrefix");
        }
        if (string.length() < 2) {
            return JSONResponses.incorrect("tagPrefix", "tagPrefix must be at least 2 characters long");
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put((Object)"tags", (Object)jSONArray);
        try (DbIterator<DigitalGoodsStore.Tag> dbIterator = DigitalGoodsStore.Tag.getTagsLike(string, bl, n, n2);){
            while (dbIterator.hasNext()) {
                jSONArray.add((Object)JSONData.tag(dbIterator.next()));
            }
        }
        return jSONObject;
    }
}

