/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.PhasingPoll;
import nxt.PhasingVote;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class GetPhasingPollVotes
extends APIServlet.APIRequestHandler {
    static final GetPhasingPollVotes instance = new GetPhasingPollVotes();

    private GetPhasingPollVotes() {
        super(new APITag[]{APITag.PHASING}, "transaction", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "transaction", true);
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        PhasingPoll phasingPoll = PhasingPoll.getPoll(l);
        if (phasingPoll != null) {
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            try (DbIterator<PhasingVote> dbIterator = PhasingVote.getVotes(l, n, n2);){
                for (PhasingVote phasingVote : dbIterator) {
                    jSONArray.add((Object)JSONData.phasingPollVote(phasingVote));
                }
            }
            jSONObject.put((Object)"votes", (Object)jSONArray);
            return jSONObject;
        }
        return JSONResponses.UNKNOWN_TRANSACTION;
    }
}

