/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class IssueAsset
extends CreateTransaction {
    static final IssueAsset instance = new IssueAsset();

    private IssueAsset() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "name", "description", "quantityQNT", "decimals");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte by;
        String string = httpServletRequest.getParameter("name");
        String string2 = httpServletRequest.getParameter("description");
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter("decimals"));
        if (string == null) {
            return JSONResponses.MISSING_NAME;
        }
        if ((string = string.trim()).length() < 3 || string.length() > 10) {
            return JSONResponses.INCORRECT_ASSET_NAME_LENGTH;
        }
        String string4 = string.toLowerCase(Locale.ROOT);
        for (by = 0; by < string4.length(); ++by) {
            if ("0123456789abcdefghijklmnopqrstuvwxyz".indexOf(string4.charAt(by)) >= 0) continue;
            return JSONResponses.INCORRECT_ASSET_NAME;
        }
        if (string2 != null && string2.length() > 1000) {
            return JSONResponses.INCORRECT_ASSET_DESCRIPTION;
        }
        by = 0;
        if (string3 != null) {
            try {
                by = Byte.parseByte(string3);
                if (by < 0 || by > 8) {
                    return JSONResponses.INCORRECT_DECIMALS;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return JSONResponses.INCORRECT_DECIMALS;
            }
        }
        long l = ParameterParser.getQuantityQNT(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Attachment.ColoredCoinsAssetIssuance coloredCoinsAssetIssuance = new Attachment.ColoredCoinsAssetIssuance(string, string2, l, by);
        return this.createTransaction(httpServletRequest, account, coloredCoinsAssetIssuance);
    }
}

