/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.Shuffler;
import nxt.Shuffling;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.JSON;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class StartShuffler
extends APIServlet.APIRequestHandler {
    static final StartShuffler instance = new StartShuffler();

    private StartShuffler() {
        super(new APITag[]{APITag.SHUFFLING}, "secretPhrase", "shufflingFullHash", "recipientSecretPhrase", "recipientPublicKey");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "shufflingFullHash", true);
        String string = ParameterParser.getSecretPhrase(httpServletRequest, true);
        byte[] byArray2 = ParameterParser.getPublicKey(httpServletRequest, "recipient");
        try {
            Shuffler shuffler = Shuffler.addOrGetShuffler(string, byArray2, byArray);
            return shuffler != null ? JSONData.shuffler(shuffler, false) : JSON.emptyJSON;
        }
        catch (Shuffler.ShufflerLimitException shufflerLimitException) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"errorCode", (Object)7);
            jSONObject.put((Object)"errorDescription", (Object)shufflerLimitException.getMessage());
            return JSON.prepare(jSONObject);
        }
        catch (Shuffler.DuplicateShufflerException duplicateShufflerException) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"errorCode", (Object)8);
            jSONObject.put((Object)"errorDescription", (Object)duplicateShufflerException.getMessage());
            return JSON.prepare(jSONObject);
        }
        catch (Shuffler.InvalidRecipientException invalidRecipientException) {
            return JSONResponses.incorrect("recipientPublicKey", invalidRecipientException.getMessage());
        }
        catch (Shuffler.ControlledAccountException controlledAccountException) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"errorCode", (Object)9);
            jSONObject.put((Object)"errorDescription", (Object)controlledAccountException.getMessage());
            return JSON.prepare(jSONObject);
        }
        catch (Shuffler.ShufflerException shufflerException) {
            if (shufflerException.getCause() instanceof NxtException.InsufficientBalanceException) {
                Shuffling shuffling = Shuffling.getShuffling(byArray);
                if (shuffling == null) {
                    return JSONResponses.NOT_ENOUGH_FUNDS;
                }
                return JSONResponses.notEnoughHolding(shuffling.getHoldingType());
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"errorCode", (Object)10);
            jSONObject.put((Object)"errorDescription", (Object)shufflerException.getMessage());
            return JSON.prepare(jSONObject);
        }
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }
}

