/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.Currency;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class TransferCurrency
extends CreateTransaction {
    static final TransferCurrency instance = new TransferCurrency();

    private TransferCurrency() {
        super(new APITag[]{APITag.MS, APITag.CREATE_TRANSACTION}, "recipient", "currency", "units");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getAccountId(httpServletRequest, "recipient", true);
        Currency currency = ParameterParser.getCurrency(httpServletRequest);
        long l2 = ParameterParser.getLong(httpServletRequest, "units", 0L, Long.MAX_VALUE, true);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Attachment.MonetarySystemCurrencyTransfer monetarySystemCurrencyTransfer = new Attachment.MonetarySystemCurrencyTransfer(currency.getId(), l2);
        try {
            return this.createTransaction(httpServletRequest, account, l, 0L, monetarySystemCurrencyTransfer);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_CURRENCY;
        }
    }
}

