/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ThreadLocalRandom;
import nxt.Account;
import nxt.crypto.Crypto;
import nxt.peer.Peers;
import nxt.util.Convert;

public final class Hallmark {
    private final String hallmarkString;
    private final String host;
    private final int port;
    private final int weight;
    private final int date;
    private final byte[] publicKey;
    private final long accountId;
    private final byte[] signature;
    private final boolean isValid;

    public static int parseDate(String string) {
        return Integer.parseInt(string.substring(0, 4)) * 10000 + Integer.parseInt(string.substring(5, 7)) * 100 + Integer.parseInt(string.substring(8, 10));
    }

    public static String formatDate(int n) {
        int n2 = n / 10000;
        int n3 = n % 10000 / 100;
        int n4 = n % 100;
        return (n2 < 10 ? "000" : (n2 < 100 ? "00" : (n2 < 1000 ? "0" : ""))) + n2 + "-" + (n3 < 10 ? "0" : "") + n3 + "-" + (n4 < 10 ? "0" : "") + n4;
    }

    public static String generateHallmark(String string, String string2, int n, int n2) {
        if (string2.length() == 0 || string2.length() > 100) {
            throw new IllegalArgumentException("Hostname length should be between 1 and 100");
        }
        if (n <= 0 || (long)n > 1000000000L) {
            throw new IllegalArgumentException("Weight should be between 1 and 1000000000");
        }
        byte[] byArray = Crypto.getPublicKey(string);
        byte[] byArray2 = Convert.toBytes(string2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(34 + byArray2.length + 4 + 4 + 1);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray);
        byteBuffer.putShort((short)byArray2.length);
        byteBuffer.put(byArray2);
        byteBuffer.putInt(n);
        byteBuffer.putInt(n2);
        byte[] byArray3 = byteBuffer.array();
        byArray3[byArray3.length - 1] = (byte)ThreadLocalRandom.current().nextInt();
        byte[] byArray4 = Crypto.sign(byArray3, string);
        return Convert.toHexString(byArray3) + Convert.toHexString(byArray4);
    }

    public static Hallmark parseHallmark(String string) {
        if ((string = string.trim()).length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid hallmark string length " + string.length());
        }
        byte[] byArray = Convert.parseHexString(string);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray2 = new byte[32];
        byteBuffer.get(byArray2);
        short s = byteBuffer.getShort();
        if (s > 300) {
            throw new IllegalArgumentException("Invalid host length");
        }
        byte[] byArray3 = new byte[s];
        byteBuffer.get(byArray3);
        String string2 = Convert.toString(byArray3);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        byteBuffer.get();
        byte[] byArray4 = new byte[64];
        byteBuffer.get(byArray4);
        byte[] byArray5 = new byte[byArray.length - 64];
        System.arraycopy(byArray, 0, byArray5, 0, byArray5.length);
        boolean bl = string2.length() < 100 && n > 0 && (long)n <= 1000000000L && Crypto.verify(byArray4, byArray5, byArray2, true);
        try {
            return new Hallmark(string, byArray2, byArray4, string2, n, n2, bl);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException.toString(), uRISyntaxException);
        }
    }

    private Hallmark(String string, byte[] byArray, byte[] byArray2, String string2, int n, int n2, boolean bl) throws URISyntaxException {
        this.hallmarkString = string;
        URI uRI = new URI("http://" + string2);
        this.host = uRI.getHost();
        this.port = uRI.getPort() == -1 ? Peers.getDefaultPeerPort() : uRI.getPort();
        this.publicKey = byArray;
        this.accountId = Account.getId(byArray);
        this.signature = byArray2;
        this.weight = n;
        this.date = n2;
        this.isValid = bl;
    }

    public String getHallmarkString() {
        return this.hallmarkString;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getDate() {
        return this.date;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

