/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import nxt.peer.PeerServlet;
import nxt.peer.Peers;
import nxt.util.Logger;
import nxt.util.QueuedThreadPool;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

@WebSocket
public class PeerWebSocket {
    private static final int FLAG_COMPRESSED = 1;
    private static final int VERSION = 1;
    private static WebSocketClient peerClient;
    private int version = 1;
    private static final ExecutorService threadPool;
    private volatile Session session;
    private final PeerServlet peerServlet;
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentHashMap<Long, PostRequest> requestMap = new ConcurrentHashMap();
    private long nextRequestId = 0L;
    private long connectTime = 0L;

    public PeerWebSocket() {
        this.peerServlet = null;
    }

    public PeerWebSocket(PeerServlet peerServlet) {
        this.peerServlet = peerServlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startClient(URI uRI) throws IOException {
        if (peerClient == null) {
            return false;
        }
        String string = String.format("%s:%d", uRI.getHost(), uRI.getPort());
        boolean bl = false;
        this.lock.lock();
        try {
            if (this.session != null) {
                bl = true;
            } else if (System.currentTimeMillis() > this.connectTime + 10000L) {
                this.connectTime = System.currentTimeMillis();
                ClientUpgradeRequest clientUpgradeRequest = new ClientUpgradeRequest();
                Future future = peerClient.connect((Object)this, uRI, clientUpgradeRequest);
                future.get(Peers.connectTimeout + 100, TimeUnit.MILLISECONDS);
                bl = true;
            }
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof UpgradeException) {
            } else {
                if (executionException.getCause() instanceof IOException) {
                    throw (IOException)executionException.getCause();
                }
                Logger.logDebugMessage(String.format("WebSocket connection to %s failed", string), executionException);
            }
        }
        catch (TimeoutException timeoutException) {
            throw new SocketTimeoutException(String.format("WebSocket connection to %s timed out", string));
        }
        catch (IllegalStateException illegalStateException) {
            if (!peerClient.isStarted()) {
                Logger.logDebugMessage("WebSocket client not started or shutting down");
                throw illegalStateException;
            }
            Logger.logDebugMessage(String.format("WebSocket connection to %s failed", string), illegalStateException);
        }
        catch (Exception exception) {
            Logger.logDebugMessage(String.format("WebSocket connection to %s failed", string), exception);
        }
        finally {
            if (!bl) {
                this.close();
            }
            this.lock.unlock();
        }
        return bl;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session = session;
        if ((Peers.communicationLoggingMask & 4) != 0) {
            Logger.logDebugMessage(String.format("%s WebSocket connection with %s completed", this.peerServlet != null ? "Inbound" : "Outbound", session.getRemoteAddress().getHostString()));
        }
    }

    public boolean isOpen() {
        Session session = this.session;
        return session != null && session.isOpen();
    }

    public InetSocketAddress getRemoteAddress() {
        Session session = this.session;
        return session != null && session.isOpen() ? session.getRemoteAddress() : null;
    }

    public String doPost(String string) throws IOException {
        Object object;
        long l;
        this.lock.lock();
        try {
            Object object2;
            if (this.session == null || !this.session.isOpen()) {
                throw new IOException("WebSocket session is not open");
            }
            l = this.nextRequestId++;
            object = string.getBytes("UTF-8");
            int n = ((byte[])object).length;
            int n2 = 0;
            if (Peers.isGzipEnabled && n >= 256) {
                n2 |= 1;
                object2 = new ByteArrayOutputStream(n);
                try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)object2);){
                    gZIPOutputStream.write((byte[])object);
                }
                object = ((ByteArrayOutputStream)object2).toByteArray();
            }
            object2 = ByteBuffer.allocate(((byte[])object).length + 20);
            ((ByteBuffer)object2).putInt(this.version).putLong(l).putInt(n2).putInt(n).put((byte[])object).flip();
            if (((Buffer)object2).limit() > 0xA00000) {
                throw new ProtocolException("POST request length exceeds max message size");
            }
            this.session.getRemote().sendBytes((ByteBuffer)object2);
        }
        catch (WebSocketException webSocketException) {
            throw new SocketException(webSocketException.getMessage());
        }
        finally {
            this.lock.unlock();
        }
        try {
            PostRequest postRequest = new PostRequest();
            this.requestMap.put(l, postRequest);
            object = postRequest.get(Peers.readTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new SocketTimeoutException("WebSocket POST interrupted");
        }
        return object;
    }

    public void sendResponse(long l, String string) throws IOException {
        block19: {
            this.lock.lock();
            try {
                Object object;
                if (this.session == null || !this.session.isOpen()) break block19;
                byte[] byArray = string.getBytes("UTF-8");
                int n = byArray.length;
                int n2 = 0;
                if (Peers.isGzipEnabled && n >= 256) {
                    n2 |= 1;
                    object = new ByteArrayOutputStream(n);
                    try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)object);){
                        gZIPOutputStream.write(byArray);
                    }
                    byArray = ((ByteArrayOutputStream)object).toByteArray();
                }
                object = ByteBuffer.allocate(byArray.length + 20);
                ((ByteBuffer)object).putInt(this.version).putLong(l).putInt(n2).putInt(n).put(byArray).flip();
                if (((Buffer)object).limit() > 0xA00000) {
                    throw new ProtocolException("POST response length exceeds max message size");
                }
                this.session.getRemote().sendBytes((ByteBuffer)object);
            }
            catch (WebSocketException webSocketException) {
                throw new SocketException(webSocketException.getMessage());
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketMessage
    public void onMessage(byte[] byArray, int n, int n2) {
        this.lock.lock();
        try {
            Object object;
            Object object2;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            this.version = Math.min(byteBuffer.getInt(), 1);
            Long l = byteBuffer.getLong();
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            byte[] byArray2 = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray2);
            if ((n3 & 1) != 0) {
                object2 = new ByteArrayInputStream(byArray2);
                object = new GZIPInputStream((InputStream)object2, 1024);
                Throwable throwable = null;
                try {
                    int n5;
                    byArray2 = new byte[n4];
                    for (int i = 0; i < byArray2.length; i += n5) {
                        n5 = ((GZIPInputStream)object).read(byArray2, i, byArray2.length - i);
                        if (n5 >= 0) continue;
                        throw new EOFException("End-of-data reading compressed data");
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((GZIPInputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((GZIPInputStream)object).close();
                        }
                    }
                }
            }
            object2 = new String(byArray2, "UTF-8");
            if (this.peerServlet != null) {
                threadPool.execute(() -> this.lambda$onMessage$0(l, (String)object2));
            } else {
                object = this.requestMap.remove(l);
                if (object != null) {
                    ((PostRequest)object).complete((String)object2);
                }
            }
        }
        catch (Exception exception) {
            Logger.logDebugMessage("Exception while processing WebSocket message", exception);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketClose
    public void onClose(int n, String string) {
        this.lock.lock();
        try {
            if (this.session != null) {
                if ((Peers.communicationLoggingMask & 4) != 0) {
                    Logger.logDebugMessage(String.format("%s WebSocket connection with %s closed", this.peerServlet != null ? "Inbound" : "Outbound", this.session.getRemoteAddress().getHostString()));
                }
                this.session = null;
            }
            SocketException socketException = new SocketException("WebSocket connection closed");
            Set<Map.Entry<Long, PostRequest>> set = this.requestMap.entrySet();
            set.forEach(entry -> ((PostRequest)entry.getValue()).complete(socketException));
            this.requestMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        this.lock.lock();
        try {
            if (this.session != null && this.session.isOpen()) {
                this.session.close();
            }
        }
        catch (Exception exception) {
            Logger.logDebugMessage("Exception while closing WebSocket", exception);
        }
        finally {
            this.lock.unlock();
        }
    }

    private /* synthetic */ void lambda$onMessage$0(Long l, String string) {
        this.peerServlet.doPost(this, l, string);
    }

    static {
        try {
            peerClient = new WebSocketClient();
            peerClient.getPolicy().setIdleTimeout((long)Peers.webSocketIdleTimeout);
            peerClient.getPolicy().setMaxBinaryMessageSize(0xA00000);
            peerClient.setConnectTimeout((long)Peers.connectTimeout);
            peerClient.start();
        }
        catch (Exception exception) {
            Logger.logErrorMessage("Unable to start WebSocket client", exception);
            peerClient = null;
        }
        threadPool = new QueuedThreadPool(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 4);
    }

    private class PostRequest {
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile String response;
        private volatile IOException exception;

        public String get(long l, TimeUnit timeUnit) throws InterruptedException, IOException {
            if (!this.latch.await(l, timeUnit)) {
                throw new SocketTimeoutException("WebSocket read timeout exceeded");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.response;
        }

        public void complete(String string) {
            this.response = string;
            this.latch.countDown();
        }

        public void complete(IOException iOException) {
            this.exception = iOException;
            this.latch.countDown();
        }
    }
}

