/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class CopyTranslationProperty {
    private static final String JSON_FILENAME = "translation.json";
    private static final String EN = "en";
    private static Path sourceDir;
    private static String propertyName;
    private static Path targetDir;
    private static int lineNumber;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 4) {
            System.out.println("Copies one translation key between sets of locales (i.e.: different projects).");
            System.out.println("Modifies translation.json files inside target subdirectories.");
            System.out.println();
            System.out.println("Usage: CopyTranslationProperty <source-locales-dir> <property-name> <target-locales-dir> <line-number>");
            System.exit(1);
        }
        if (!Files.isDirectory(sourceDir = Paths.get(stringArray[0], new String[0]), new LinkOption[0]) || !Files.isRegularFile(sourceDir.resolve(EN).resolve(JSON_FILENAME), new LinkOption[0])) {
            System.out.println("First parameter must be the source locales directory.");
            System.exit(1);
        }
        propertyName = stringArray[1];
        if (!CopyTranslationProperty.readProperty(sourceDir.resolve(EN).resolve(JSON_FILENAME)).isPresent()) {
            System.out.println("Second parameter must be a valid property name (checked against english locale).");
            System.exit(1);
        }
        if (!Files.isDirectory(targetDir = Paths.get(stringArray[2], new String[0]), new LinkOption[0]) || !Files.isRegularFile(targetDir.resolve(EN).resolve(JSON_FILENAME), new LinkOption[0])) {
            System.out.println("Third parameter must be the target locales directory.");
            System.exit(1);
        }
        if ((lineNumber = Integer.parseInt(stringArray[3])) <= 0 || (long)lineNumber > Files.lines(targetDir.resolve(EN).resolve(JSON_FILENAME)).count()) {
            System.out.println("Last parameter must be the line number from target files where you want the new line.");
            System.exit(1);
        }
        Files.list(sourceDir).filter(path -> Files.isDirectory(path, new LinkOption[0])).forEach(path -> CopyTranslationProperty.copyProperty(path.resolve(JSON_FILENAME), targetDir.resolve(path.getFileName()).resolve(JSON_FILENAME)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> readProperty(Path path) {
        if (!Files.isReadable(path)) {
            System.err.println(path + " ignored, as I cannot read it.");
            return Optional.empty();
        }
        try (Stream<String> stream = Files.lines(path);){
            Optional<String> optional = stream.filter(string -> string.trim().startsWith('\"' + propertyName + "\":")).findAny();
            return optional;
        }
        catch (IOException iOException) {
            System.err.println(path + " ignored, as per the exception:");
            iOException.printStackTrace();
            return Optional.empty();
        }
    }

    private static void copyProperty(Path path, Path path2) {
        if (!Files.isWritable(path2)) {
            System.err.println("Can't write target: " + path2);
            return;
        }
        CopyTranslationProperty.readProperty(path).ifPresent(string -> {
            try {
                List<String> list = Files.readAllLines(path2);
                if (lineNumber > list.size()) {
                    System.err.println("Not writing to " + path2 + ", not enough lines.");
                } else {
                    list.add(lineNumber - 1, (String)string);
                    byte[] byArray = String.join((CharSequence)"\r\n", list).getBytes(StandardCharsets.UTF_8);
                    Files.write(path2, byArray, new OpenOption[0]);
                }
            }
            catch (IOException iOException) {
                System.err.println("Not writing to " + path2 + ", as per the exception:");
                iOException.printStackTrace();
            }
        });
    }
}

