/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import nxt.Account;
import nxt.Db;
import nxt.Nxt;
import nxt.crypto.Crypto;
import nxt.util.Convert;
import nxt.util.Logger;

public final class PassphraseRecovery {
    static final Solution NO_SOLUTION = new Solution();

    public static void main(String[] stringArray) {
        new PassphraseRecovery().recover();
    }

    private void recover() {
        try {
            Object object;
            Object object2;
            int[] nArray;
            Map<Long, byte[]> map = PassphraseRecovery.getPublicKeys();
            String string = Nxt.getStringProperty("recoveryWildcard", "", false, "UTF-8");
            if ("".equals(string)) {
                Logger.logInfoMessage("Specify in the recoveryWildcard setting, an approximate passphrase as close as possible to the real passphrase");
                return;
            }
            int[] nArray2 = string.chars().toArray();
            Logger.logInfoMessage("wildcard=" + string + ", wildcard chars=" + Arrays.toString(nArray2));
            String string2 = Nxt.getStringProperty("recoveryPositions", "");
            try {
                nArray = string2.length() == 0 ? new int[]{} : Arrays.stream(string2.split(",")).map(String::trim).mapToInt(Integer::parseInt).map(n -> n - 1).toArray();
                object2 = IntStream.of(nArray).boxed().collect(Collectors.toList());
                object = object2.stream().map(n -> Character.toString(string.charAt((int)n))).collect(Collectors.joining(" "));
                Logger.logInfoMessage("Recovering chars: " + (String)object);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.logInfoMessage("Specify in the recoveryPositions setting, a comma separated list of numeric positions pointing to the recoveryWildcard unknown characters (first position is 1)");
                return;
            }
            object2 = Nxt.getStringProperty("recoveryDictionary", "");
            switch (((String)object2).toLowerCase()) {
                case "": 
                case "ascii": {
                    object = PassphraseRecovery.getDictionary(32, 127);
                    break;
                }
                case "asciiall": {
                    object = PassphraseRecovery.getDictionary(0, (int)(Math.pow(2.0, 8.0) - 1.0));
                    break;
                }
                case "unicode": {
                    object = PassphraseRecovery.getDictionary(0, (int)(Math.pow(2.0, 16.0) - 1.0));
                    break;
                }
                default: {
                    object = ((String)object2).toCharArray();
                }
            }
            Logger.logMessage(String.format("Wildcard %s positions %s dictionary %s", string, Arrays.toString(nArray), Arrays.toString((char[])object)));
            Object object3 = new Scanner(map, nArray, string.toCharArray(), (char[])object);
            Solution solution = ((Scanner)object3).scan();
            Logger.logDebugMessage("" + solution);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static char[] getDefaultDictionary() {
        return PassphraseRecovery.getDictionary(27, 132);
    }

    static char[] getDictionary(int n2, int n3) {
        return IntStream.rangeClosed(n2, n3).mapToObj(n -> "" + (char)n).collect(Collectors.joining()).toCharArray();
    }

    static Map<Long, byte[]> getPublicKeys() {
        Db.init();
        HashMap<Long, byte[]> hashMap = new HashMap<Long, byte[]>();
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM public_key WHERE latest=TRUE");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long l = resultSet.getLong("account_id");
                byte[] byArray = resultSet.getBytes("public_key");
                hashMap.put(l, byArray);
            }
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException(sQLException);
        }
        Logger.logMessage(String.format("Loaded %d public keys", hashMap.size()));
        return hashMap;
    }

    static class Solution {
        private String passphrase;
        private byte[] publicKey;
        private long accountId;
        private String rsAccount;

        Solution() {
        }

        Solution(String string, byte[] byArray, long l, String string2) {
            this.passphrase = string;
            this.publicKey = byArray;
            this.accountId = l;
            this.rsAccount = string2;
        }

        public String toString() {
            if (this == NO_SOLUTION) {
                return "Not Found";
            }
            int[] nArray = this.passphrase.chars().toArray();
            return "Solution{passphrase=" + this.passphrase + ", passphraseChars=" + Arrays.toString(nArray) + ", publicKey=" + (this.publicKey != null ? Convert.toHexString(this.publicKey) : "not registered on blockchain") + ", accountId=" + this.accountId + ", rsAccount=" + this.rsAccount + '}';
        }

        public String getRsAccount() {
            return this.rsAccount;
        }
    }

    static class Scanner
    implements Callable<Solution> {
        private final Map<Long, byte[]> publicKeys;
        private int[] positions;
        private final char[] wildcard;
        private final char[] dictionary;
        private Solution realSolution = NO_SOLUTION;

        Scanner(Map<Long, byte[]> map, int[] nArray, char[] cArray, char[] cArray2) {
            this.publicKeys = map;
            this.positions = nArray;
            this.wildcard = cArray;
            this.dictionary = cArray2;
        }

        Solution scan() {
            if (this.positions.length == 0) {
                Logger.logInfoMessage("Position not specified scanning for a single typo");
                char[] cArray = new char[this.wildcard.length];
                int n = 0;
                while (n < this.wildcard.length) {
                    this.positions = new int[1];
                    this.positions[0] = n++;
                    System.arraycopy(this.wildcard, 0, cArray, 0, this.wildcard.length);
                    Solution solution = this.scan(0, cArray);
                    if (solution == NO_SOLUTION) continue;
                    return solution;
                }
                return NO_SOLUTION;
            }
            Logger.logInfoMessage("Scanning " + Math.pow(this.dictionary.length, this.positions.length) + " permutations");
            if (this.positions.length == 1) {
                return this.scan(0, this.wildcard);
            }
            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
            ExecutorCompletionService<Solution> executorCompletionService = new ExecutorCompletionService<Solution>(executorService);
            executorService.submit(() -> {
                int n = 0;
                while (!executorService.isShutdown()) {
                    Solution solution;
                    try {
                        solution = (Solution)executorCompletionService.take().get();
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        throw new IllegalStateException(exception);
                    }
                    Logger.logInfoMessage(String.format("task %d / %d is done", ++n, this.dictionary.length));
                    if (solution == NO_SOLUTION) continue;
                    this.realSolution = solution;
                    break;
                }
                executorService.shutdown();
            });
            for (char c : this.dictionary) {
                char[] cArray = new char[this.wildcard.length];
                System.arraycopy(this.wildcard, 0, cArray, 0, this.wildcard.length);
                cArray[this.positions[0]] = c;
                Scanner scanner = new Scanner(this.publicKeys, this.positions, cArray, this.dictionary);
                executorCompletionService.submit(scanner);
            }
            try {
                executorService.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException(interruptedException);
            }
            return this.realSolution;
        }

        private Solution scan(int n, char[] cArray) {
            char[] cArray2 = this.dictionary;
            int n2 = cArray2.length;
            for (int i = 0; i < n2; ++i) {
                Object object;
                char c;
                cArray[this.positions[n]] = c = cArray2[i];
                if (n < this.positions.length - 1) {
                    object = this.scan(n + 1, cArray);
                    if (object == NO_SOLUTION) continue;
                    return object;
                }
                object = new String(cArray);
                byte[] byArray = Crypto.getPublicKey((String)object);
                long l = Account.getId(byArray);
                if (!this.publicKeys.keySet().contains(l)) continue;
                return new Solution((String)object, this.publicKeys.get(l), l, Convert.rsAccount(l));
            }
            return NO_SOLUTION;
        }

        @Override
        public Solution call() throws Exception {
            return this.scan(1, this.wildcard);
        }
    }
}

