/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nxt.Constants;
import nxt.util.Convert;

public final class VerifyTraceFile {
    private static final List<String> balanceHeaders = Arrays.asList("balance", "unconfirmed balance");
    private static final List<String> deltaHeaders = Arrays.asList("transaction amount", "transaction fee", "dividend", "generation fee", "trade cost", "purchase cost", "discount", "refund", "exchange cost", "currency cost");
    private static final List<String> assetQuantityHeaders = Arrays.asList("asset balance", "unconfirmed asset balance");
    private static final List<String> deltaAssetQuantityHeaders = Arrays.asList("asset quantity", "trade quantity");
    private static final List<String> currencyBalanceHeaders = Arrays.asList("currency balance", "unconfirmed currency balance");
    private static final List<String> deltaCurrencyUnitHeaders = Arrays.asList("currency units", "exchange quantity");
    private static final String beginQuote = "^\"";
    private static final String endQuote = "\"$";

    private static boolean isBalance(String string) {
        return balanceHeaders.contains(string);
    }

    private static boolean isDelta(String string) {
        return deltaHeaders.contains(string);
    }

    private static boolean isAssetQuantity(String string) {
        return assetQuantityHeaders.contains(string);
    }

    private static boolean isDeltaAssetQuantity(String string) {
        return deltaAssetQuantityHeaders.contains(string);
    }

    private static boolean isCurrencyBalance(String string) {
        return currencyBalanceHeaders.contains(string);
    }

    private static boolean isDeltaCurrencyUnits(String string) {
        return deltaCurrencyUnitHeaders.contains(string);
    }

    public static void main(String[] stringArray) {
        String string2 = stringArray.length == 1 ? stringArray[0] : "nxt-trace.csv";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));){
            Map.Entry entry4;
            Object object;
            Object object4;
            Cloneable cloneable;
            String[] stringArray2;
            String string3 = bufferedReader.readLine();
            String[] stringArray3 = VerifyTraceFile.unquote(string3.split("\t"));
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            HashMap<String, Map> hashMap2 = new HashMap<String, Map>();
            HashMap<Object, Long> hashMap3 = new HashMap<Object, Long>();
            HashMap<Object, Long> hashMap4 = new HashMap<Object, Long>();
            HashMap<String, Map> hashMap5 = new HashMap<String, Map>();
            HashMap<String, Long> hashMap6 = new HashMap<String, Long>();
            HashMap<Object, Long> hashMap7 = new HashMap<Object, Long>();
            while ((string3 = bufferedReader.readLine()) != null) {
                long l;
                long l2;
                Object object2;
                stringArray2 = VerifyTraceFile.unquote(string3.split("\t"));
                cloneable = new HashMap();
                for (int i = 0; i < stringArray3.length; ++i) {
                    cloneable.put(stringArray3[i], stringArray2[i]);
                }
                object4 = (String)cloneable.get("account");
                Map hashSet2 = hashMap.computeIfAbsent((String)object4, string -> new HashMap());
                Map map = hashMap2.computeIfAbsent((String)object4, string -> new HashMap());
                String string4 = (String)cloneable.get("event");
                if ("asset issuance".equals(string4)) {
                    object2 = (String)cloneable.get("asset");
                    hashMap3.put(object2, Long.parseLong((String)cloneable.get("asset quantity")));
                }
                if ("asset transfer".equals(string4) && 1739068987193023818L == Convert.parseUnsignedLong((String)object4)) {
                    object2 = (String)cloneable.get("asset");
                    l2 = Long.parseLong((String)cloneable.get("asset quantity"));
                    l = (Long)hashMap3.get(object2);
                    hashMap3.put(object2, l - l2);
                }
                if ("asset quantity change".equals(string4)) {
                    object2 = (String)cloneable.get("asset");
                    l2 = Long.parseLong((String)cloneable.get("asset quantity"));
                    l = (Long)hashMap3.get(object2);
                    hashMap3.put(object2, l + l2);
                }
                object2 = hashMap5.computeIfAbsent((String)object4, string -> new HashMap());
                if ("currency issuance".equals(string4)) {
                    String string5 = (String)cloneable.get("currency");
                    hashMap6.put(string5, Long.parseLong((String)cloneable.get("currency units")));
                }
                if ("crowdfunding".equals(string4)) {
                    String string6 = (String)cloneable.get("currency");
                    hashMap6.put(string6, Long.parseLong((String)cloneable.get("crowdfunding")));
                }
                if ("currency mint".equals(string4)) {
                    String string7 = (String)cloneable.get("currency");
                    hashMap6.put(string7, Math.addExact(VerifyTraceFile.nullToZero((Long)hashMap6.get(string7)), Long.parseLong((String)cloneable.get("currency units"))));
                }
                if ("currency claim".equals(string4)) {
                    String string8 = (String)cloneable.get("currency");
                    hashMap6.put(string8, Math.addExact(VerifyTraceFile.nullToZero((Long)hashMap6.get(string8)), Long.parseLong((String)cloneable.get("currency units"))));
                }
                if ("currency delete".equals(string4) || "undo crowdfunding".equals(string4)) {
                    String string9 = (String)cloneable.get("currency");
                    hashMap6.put(string9, 0L);
                }
                for (Map.Entry entry2 : cloneable.entrySet()) {
                    long l3;
                    String string10 = (String)entry2.getKey();
                    object = (String)entry2.getValue();
                    if (object == null || "".equals(((String)object).trim())) continue;
                    if (VerifyTraceFile.isBalance(string10)) {
                        hashSet2.put(string10, Long.parseLong((String)object));
                        continue;
                    }
                    if (VerifyTraceFile.isDelta(string10)) {
                        long l4 = VerifyTraceFile.nullToZero((Long)hashSet2.get(string10));
                        hashSet2.put(string10, Math.addExact(l4, Long.parseLong((String)object)));
                        continue;
                    }
                    if (VerifyTraceFile.isAssetQuantity(string10)) {
                        String string11 = (String)cloneable.get("asset");
                        entry4 = map.computeIfAbsent(string11, string -> new HashMap());
                        entry4.put(string10, Long.parseLong((String)object));
                        continue;
                    }
                    if (VerifyTraceFile.isDeltaAssetQuantity(string10)) {
                        String string12 = (String)cloneable.get("asset");
                        entry4 = map.computeIfAbsent(string12, string -> new HashMap());
                        l3 = VerifyTraceFile.nullToZero((Long)entry4.get(string10));
                        entry4.put(string10, Math.addExact(l3, Long.parseLong((String)object)));
                        continue;
                    }
                    if (VerifyTraceFile.isCurrencyBalance(string10)) {
                        String string13 = (String)cloneable.get("currency");
                        entry4 = object2.computeIfAbsent(string13, string -> new HashMap());
                        entry4.put(string10, Long.parseLong((String)object));
                        continue;
                    }
                    if (!VerifyTraceFile.isDeltaCurrencyUnits(string10)) continue;
                    String string14 = (String)cloneable.get("currency");
                    entry4 = object2.computeIfAbsent(string14, string -> new HashMap());
                    l3 = VerifyTraceFile.nullToZero((Long)entry4.get(string10));
                    entry4.put(string10, Math.addExact(l3, Long.parseLong((String)object)));
                }
            }
            stringArray2 = Constants.isTestnet ? "861080501219231688" : "12422608354438203866";
            cloneable = new HashSet();
            for (Map.Entry entry3 : hashMap.entrySet()) {
                Object object3;
                Object object5;
                String string15 = (String)entry3.getKey();
                Map map = (Map)entry3.getValue();
                System.out.println("account: " + string15);
                for (String string16 : balanceHeaders) {
                    System.out.println(string16 + ": " + VerifyTraceFile.nullToZero((Long)map.get(string16)));
                }
                System.out.println("totals:");
                long l = 0L;
                for (String string17 : deltaHeaders) {
                    long l5 = VerifyTraceFile.nullToZero((Long)map.get(string17));
                    l = Math.addExact(l, l5);
                    System.out.println(string17 + ": " + l5);
                }
                System.out.println("total confirmed balance change: " + l);
                long l6 = VerifyTraceFile.nullToZero((Long)map.get("balance"));
                if (l6 != l) {
                    System.out.println("ERROR: balance doesn't match total change!!!");
                    cloneable.add(string15);
                }
                object = (Map)hashMap2.get(string15);
                for (Map.Entry entry4 : object.entrySet()) {
                    long l7;
                    object5 = (String)entry4.getKey();
                    if (((String)object5).equals(stringArray2)) continue;
                    object3 = (Map)entry4.getValue();
                    System.out.println("asset: " + (String)object5);
                    for (Map.Entry entry5 : object3.entrySet()) {
                        System.out.println((String)entry5.getKey() + ": " + entry5.getValue());
                    }
                    long l8 = 0L;
                    for (String string18 : deltaAssetQuantityHeaders) {
                        l7 = VerifyTraceFile.nullToZero((Long)object3.get(string18));
                        l8 = Math.addExact(l8, l7);
                    }
                    System.out.println("total confirmed asset quantity change: " + l8);
                    long l9 = VerifyTraceFile.nullToZero((Long)object3.get("asset balance"));
                    if (l9 != l8 && (1739068987193023818L != Convert.parseUnsignedLong(string15) || l9 != 0L)) {
                        System.out.println("ERROR: asset balance doesn't match total asset quantity change!!!");
                        cloneable.add(string15);
                    }
                    l7 = VerifyTraceFile.nullToZero((Long)hashMap4.get(object5));
                    hashMap4.put(object5, Math.addExact(l7, l9));
                }
                Map map2 = (Map)hashMap5.get(string15);
                entry4 = map2.entrySet().iterator();
                while (entry4.hasNext()) {
                    long l10;
                    object5 = (Map.Entry)entry4.next();
                    object3 = (String)object5.getKey();
                    Map map3 = (Map)object5.getValue();
                    System.out.println("currency: " + (String)object3);
                    for (Map.Entry entry6 : map3.entrySet()) {
                        System.out.println((String)entry6.getKey() + ": " + entry6.getValue());
                    }
                    long l11 = 0L;
                    for (String string19 : deltaCurrencyUnitHeaders) {
                        l10 = VerifyTraceFile.nullToZero((Long)map3.get(string19));
                        l11 = Math.addExact(l11, l10);
                    }
                    System.out.println("total confirmed currency units change: " + l11);
                    long l12 = VerifyTraceFile.nullToZero((Long)map3.get("currency balance"));
                    if (l12 != l11) {
                        System.out.println("ERROR: currency balance doesn't match total currency units change!!!");
                        cloneable.add(string15);
                    }
                    l10 = VerifyTraceFile.nullToZero((Long)hashMap7.get(object3));
                    hashMap7.put(object3, Math.addExact(l10, l12));
                }
                System.out.println();
            }
            object4 = new HashSet();
            for (Map.Entry entry7 : hashMap3.entrySet()) {
                long l;
                String string20 = (String)entry7.getKey();
                if (string20.equals(stringArray2) || (l = ((Long)entry7.getValue()).longValue()) == VerifyTraceFile.nullToZero((Long)hashMap4.get(string20))) continue;
                System.out.println("ERROR: asset " + string20 + " balances don't match, issued: " + l + ", total of account balances: " + hashMap4.get(string20));
                object4.add(string20);
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry entry8 : hashMap6.entrySet()) {
                String string21 = (String)entry8.getKey();
                long l = (Long)entry8.getValue();
                if (l == VerifyTraceFile.nullToZero((Long)hashMap7.get(string21))) continue;
                System.out.println("ERROR: currency " + string21 + " balances don't match, issued: " + l + ", total of account balances: " + hashMap7.get(string21));
                hashSet.add(string21);
            }
            if (cloneable.size() > 0) {
                System.out.println("ERROR: " + cloneable.size() + " accounts have incorrect balances");
                System.out.println(cloneable);
            } else {
                System.out.println("SUCCESS: all " + hashMap.size() + " account balances and asset balances match the transaction and trade totals!");
            }
            if (object4.size() > 0) {
                System.out.println("ERROR: " + object4.size() + " assets have incorrect balances");
                System.out.println(object4);
            } else {
                System.out.println("SUCCESS: all " + hashMap3.size() + " assets quantities are correct!");
            }
            if (hashSet.size() > 0) {
                System.out.println("ERROR: " + hashSet.size() + " currencies have incorrect balances");
                System.out.println(hashSet);
            } else {
                System.out.println("SUCCESS: all " + hashMap6.size() + " currency units are correct!");
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            throw new RuntimeException(iOException);
        }
    }

    private static String[] unquote(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].replaceFirst(beginQuote, "").replaceFirst(endQuote, "");
        }
        return stringArray2;
    }

    private static long nullToZero(Long l) {
        return l == null ? 0L : l;
    }
}

