/*
 * Decompiled with CFR 0.152.
 */
package nxt.user;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.Generator;
import nxt.crypto.Crypto;
import nxt.user.Users;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

final class User {
    private volatile String secretPhrase;
    private volatile byte[] publicKey;
    private volatile boolean isInactive;
    private final String userId;
    private final ConcurrentLinkedQueue<JSONStreamAware> pendingResponses = new ConcurrentLinkedQueue();
    private AsyncContext asyncContext;

    User(String string) {
        this.userId = string;
    }

    String getUserId() {
        return this.userId;
    }

    byte[] getPublicKey() {
        return this.publicKey;
    }

    String getSecretPhrase() {
        return this.secretPhrase;
    }

    boolean isInactive() {
        return this.isInactive;
    }

    void setInactive(boolean bl) {
        this.isInactive = bl;
    }

    void enqueue(JSONStreamAware jSONStreamAware) {
        this.pendingResponses.offer(jSONStreamAware);
    }

    void lockAccount() {
        Generator.stopForging(this.secretPhrase);
        this.secretPhrase = null;
    }

    long unlockAccount(String string) {
        this.publicKey = Crypto.getPublicKey(string);
        this.secretPhrase = string;
        return Generator.startForging(string).getAccountId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void processPendingResponses(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        JSONStreamAware jSONStreamAware;
        JSONArray jSONArray = new JSONArray();
        while ((jSONStreamAware = this.pendingResponses.poll()) != null) {
            jSONArray.add((Object)jSONStreamAware);
        }
        if (jSONArray.size() > 0) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"responses", (Object)jSONArray);
            if (this.asyncContext != null) {
                this.asyncContext.getResponse().setContentType("text/plain; charset=UTF-8");
                try (PrintWriter printWriter = this.asyncContext.getResponse().getWriter();){
                    jSONObject.writeJSONString((Writer)printWriter);
                }
                this.asyncContext.complete();
                this.asyncContext = httpServletRequest.startAsync();
                this.asyncContext.addListener((AsyncListener)new UserAsyncListener());
                this.asyncContext.setTimeout(5000L);
                return;
            }
            httpServletResponse.setContentType("text/plain; charset=UTF-8");
            try (PrintWriter printWriter = httpServletResponse.getWriter();){
                jSONObject.writeJSONString((Writer)printWriter);
                return;
            }
        }
        if (this.asyncContext != null) {
            this.asyncContext.getResponse().setContentType("text/plain; charset=UTF-8");
            try (PrintWriter printWriter = this.asyncContext.getResponse().getWriter();){
                JSON.emptyJSON.writeJSONString((Writer)printWriter);
            }
            this.asyncContext.complete();
        }
        this.asyncContext = httpServletRequest.startAsync();
        this.asyncContext.addListener((AsyncListener)new UserAsyncListener());
        this.asyncContext.setTimeout(5000L);
    }

    synchronized void send(JSONStreamAware jSONStreamAware) {
        if (this.asyncContext == null) {
            if (this.isInactive) {
                return;
            }
            if (this.pendingResponses.size() > 1000) {
                this.pendingResponses.clear();
                this.isInactive = true;
                if (this.secretPhrase == null) {
                    Users.remove(this);
                }
                return;
            }
            this.pendingResponses.offer(jSONStreamAware);
        } else {
            JSONStreamAware jSONStreamAware2;
            JSONArray jSONArray = new JSONArray();
            while ((jSONStreamAware2 = this.pendingResponses.poll()) != null) {
                jSONArray.add((Object)jSONStreamAware2);
            }
            jSONArray.add((Object)jSONStreamAware);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"responses", (Object)jSONArray);
            this.asyncContext.getResponse().setContentType("text/plain; charset=UTF-8");
            try (PrintWriter printWriter = this.asyncContext.getResponse().getWriter();){
                jSONObject.writeJSONString((Writer)printWriter);
            }
            catch (IOException iOException) {
                Logger.logMessage("Error sending response to user", iOException);
            }
            this.asyncContext.complete();
            this.asyncContext = null;
        }
    }

    private final class UserAsyncListener
    implements AsyncListener {
        private UserAsyncListener() {
        }

        public void onComplete(AsyncEvent asyncEvent) throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(AsyncEvent asyncEvent) throws IOException {
            User user = User.this;
            synchronized (user) {
                User.this.asyncContext.getResponse().setContentType("text/plain; charset=UTF-8");
                try (PrintWriter printWriter = User.this.asyncContext.getResponse().getWriter();){
                    JSON.emptyJSON.writeJSONString((Writer)printWriter);
                }
                User.this.asyncContext.complete();
                User.this.asyncContext = null;
            }
        }

        public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimeout(AsyncEvent asyncEvent) throws IOException {
            User user = User.this;
            synchronized (user) {
                User.this.asyncContext.getResponse().setContentType("text/plain; charset=UTF-8");
                try (PrintWriter printWriter = User.this.asyncContext.getResponse().getWriter();){
                    JSON.emptyJSON.writeJSONString((Writer)printWriter);
                }
                User.this.asyncContext.complete();
                User.this.asyncContext = null;
            }
        }
    }
}

