/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import nxt.NxtException;

public class CountingInputReader
extends FilterReader {
    private long count = 0L;
    private final long limit;

    public CountingInputReader(Reader reader, long l) {
        super(reader);
        this.limit = l;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.incCount(1L);
        }
        return n;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = super.read(cArray, n, n2);
        if (n3 != -1) {
            this.incCount(n3);
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        if (l2 != -1L) {
            this.incCount(l2);
        }
        return l2;
    }

    public long getCount() {
        return this.count;
    }

    private void incCount(long l) throws NxtException.NxtIOException {
        this.count += l;
        if (this.count > this.limit) {
            throw new NxtException.NxtIOException("Maximum size exceeded: " + this.count);
        }
    }
}

