/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class JSON {
    public static final JSONStreamAware emptyJSON = JSON.prepare(new JSONObject());
    private static final Pattern pattern = Pattern.compile("[\"\\\\\\u0008\\f\\n\\r\\t/\\u0000-\\u001f\\u007f-\\u009f\\u2000-\\u20ff\\ud800-\\udbff]");

    private JSON() {
    }

    public static JSONStreamAware prepare(final JSONObject jSONObject) {
        return new JSONStreamAware(){
            private final char[] jsonChars;
            {
                this.jsonChars = JSON.toJSONString((JSONAware)jSONObject).toCharArray();
            }

            public void writeJSONString(Writer writer) throws IOException {
                writer.write(this.jsonChars);
            }
        };
    }

    public static JSONStreamAware prepareRequest(JSONObject jSONObject) {
        jSONObject.put((Object)"protocol", (Object)1);
        return JSON.prepare(jSONObject);
    }

    public static String toString(JSONStreamAware jSONStreamAware) {
        StringWriter stringWriter = new StringWriter();
        try {
            JSON.writeJSONString(jSONStreamAware, stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static String toJSONString(JSONAware jSONAware) {
        if (jSONAware == null) {
            return "null";
        }
        if (jSONAware instanceof Map) {
            StringBuilder stringBuilder = new StringBuilder(1024);
            JSON.encodeObject((Map)jSONAware, stringBuilder);
            return stringBuilder.toString();
        }
        if (jSONAware instanceof List) {
            StringBuilder stringBuilder = new StringBuilder(1024);
            JSON.encodeArray((List)jSONAware, stringBuilder);
            return stringBuilder.toString();
        }
        return jSONAware.toJSONString();
    }

    public static void writeJSONString(JSONStreamAware jSONStreamAware, Writer writer) throws IOException {
        if (jSONStreamAware == null) {
            writer.write("null");
            return;
        }
        if (jSONStreamAware instanceof Map) {
            StringBuilder stringBuilder = new StringBuilder(1024);
            JSON.encodeObject((Map)jSONStreamAware, stringBuilder);
            writer.write(stringBuilder.toString());
            return;
        }
        if (jSONStreamAware instanceof List) {
            StringBuilder stringBuilder = new StringBuilder(1024);
            JSON.encodeArray((List)jSONStreamAware, stringBuilder);
            writer.write(stringBuilder.toString());
            return;
        }
        jSONStreamAware.writeJSONString(writer);
    }

    private static void encodeArray(List<?> list, StringBuilder stringBuilder) {
        if (list == null) {
            stringBuilder.append("null");
            return;
        }
        boolean bl = true;
        stringBuilder.append('[');
        for (Object obj : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            JSON.encodeValue(obj, stringBuilder);
        }
        stringBuilder.append(']');
    }

    public static void encodeObject(Map<?, ?> map, StringBuilder stringBuilder) {
        if (map == null) {
            stringBuilder.append("null");
            return;
        }
        Set<Map.Entry<?, ?>> set = map.entrySet();
        Iterator<Map.Entry<?, ?>> iterator = set.iterator();
        boolean bl = true;
        stringBuilder.append('{');
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            Object obj = entry.getKey();
            Object obj2 = entry.getValue();
            if (obj == null) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"').append(obj.toString()).append("\":");
            JSON.encodeValue(obj2, stringBuilder);
        }
        stringBuilder.append('}');
    }

    public static void encodeValue(Object object, StringBuilder stringBuilder) {
        if (object == null) {
            stringBuilder.append("null");
        } else if (object instanceof Double) {
            if (((Double)object).isInfinite() || ((Double)object).isNaN()) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(object.toString());
            }
        } else if (object instanceof Float) {
            if (((Float)object).isInfinite() || ((Float)object).isNaN()) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(object.toString());
            }
        } else if (object instanceof Number) {
            stringBuilder.append(object.toString());
        } else if (object instanceof Boolean) {
            stringBuilder.append(object.toString());
        } else if (object instanceof Map) {
            JSON.encodeObject((Map)object, stringBuilder);
        } else if (object instanceof List) {
            JSON.encodeArray((List)object, stringBuilder);
        } else {
            stringBuilder.append('\"');
            JSON.escapeString(object.toString(), stringBuilder);
            stringBuilder.append('\"');
        }
    }

    private static void escapeString(String string, StringBuilder stringBuilder) {
        if (string.length() == 0) {
            return;
        }
        int n = 0;
        Matcher matcher = pattern.matcher(string);
        block10: while (matcher.find(n)) {
            int n2 = matcher.start();
            if (n2 > n) {
                stringBuilder.append(string.substring(n, n2));
            }
            n = n2 + 1;
            char c = string.charAt(n2);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '/': {
                    stringBuilder.append("\\/");
                    continue block10;
                }
            }
            if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff') {
                stringBuilder.append("\\u").append(String.format("%04X", c));
                continue;
            }
            stringBuilder.append(c);
        }
        if (n == 0) {
            stringBuilder.append(string);
        } else if (n < string.length()) {
            stringBuilder.append(string.substring(n));
        }
    }
}

