/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;

public class MultipartUtility {
    private static final String LINE_FEED = "\r\n";
    private final String boundary;
    private final HttpURLConnection connection;
    private final Charset charset;
    private final OutputStream outputStream;
    private final PrintWriter writer;

    public MultipartUtility(URL uRL, Charset charset) {
        this.charset = charset;
        this.boundary = "===" + System.currentTimeMillis() + "===";
        try {
            this.connection = (HttpURLConnection)uRL.openConnection();
            this.connection.setUseCaches(false);
            this.connection.setDoOutput(true);
            this.connection.setDoInput(true);
            this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
            this.outputStream = this.connection.getOutputStream();
            this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public void addFormField(String string, String string2) {
        this.writer.append("--").append(this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"").append(string).append("\"").append(LINE_FEED);
        this.writer.append("Content-Type: text/plain; charset=").append(this.charset.displayName()).append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(string2).append(LINE_FEED);
        this.writer.flush();
    }

    public void addFilePart(String string, String string2, byte[] byArray) {
        this.writer.append("--").append(this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"").append(string).append("\"; filename=\"").append(string2).append("\"").append(LINE_FEED);
        this.writer.append("Content-Type: ").append(URLConnection.guessContentTypeFromName(string2)).append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            byte[] byArray2 = new byte[4096];
            while ((n = byteArrayInputStream.read(byArray2)) != -1) {
                this.outputStream.write(byArray2, 0, n);
            }
            this.outputStream.flush();
            ((InputStream)byteArrayInputStream).close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        this.writer.append(LINE_FEED);
        this.writer.flush();
    }

    public void addHeaderField(String string, String string2) {
        this.writer.append(string).append(": ").append(string2).append(LINE_FEED);
        this.writer.flush();
    }

    public InputStream finish() {
        this.writer.append("--").append(this.boundary).append("--").append(LINE_FEED);
        this.writer.flush();
        this.writer.close();
        try {
            int n = this.connection.getResponseCode();
            if (n == 200) {
                return this.connection.getInputStream();
            }
            throw new IOException("Server returned non-OK status: " + n);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }
}

