/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Nxt;
import nxt.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.EntityDbTable;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class AssetHistory {
    private static final Listeners<AssetHistory, Event> listeners = new Listeners();
    private static final DbKey.LongKeyFactory<AssetHistory> assetHistoryDbKeyFactory = new DbKey.LongKeyFactory<AssetHistory>("id"){

        @Override
        public DbKey newKey(AssetHistory assetHistory) {
            return assetHistory.dbKey;
        }
    };
    private static final EntityDbTable<AssetHistory> assetHistoryTable = new EntityDbTable<AssetHistory>("asset_history", assetHistoryDbKeyFactory){

        @Override
        protected AssetHistory load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new AssetHistory(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, AssetHistory assetHistory) throws SQLException {
            assetHistory.save(connection);
        }
    };
    private static final DbClause deletesClause = new DbClause.LongClause("quantity", DbClause.Op.LT, 0L);
    private static final DbClause increasesClause = new DbClause.LongClause("quantity", DbClause.Op.GT, 0L);
    private final long id;
    private final DbKey dbKey;
    private final long assetId;
    private final int height;
    private final long accountId;
    private final long quantityQNT;
    private final int timestamp;

    public static boolean addListener(Listener<AssetHistory> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<AssetHistory> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    public static DbIterator<AssetHistory> getAssetHistory(long l, int n, int n2) {
        return assetHistoryTable.getManyBy((DbClause)new DbClause.LongClause("asset_id", l), n, n2, " ORDER BY asset_id, height DESC ");
    }

    public static DbIterator<AssetHistory> getAccountAssetHistory(long l, int n, int n2) {
        return assetHistoryTable.getManyBy((DbClause)new DbClause.LongClause("account_id", l), n, n2, " ORDER BY account_id, height DESC ");
    }

    public static DbIterator<AssetHistory> getAccountAssetHistory(long l, long l2, int n, int n2) {
        return assetHistoryTable.getManyBy(new DbClause.LongClause("account_id", l).and(new DbClause.LongClause("asset_id", l2)), n, n2, " ORDER BY asset_id, height DESC ");
    }

    public static DbIterator<AssetHistory> getAssetDeletes(long l, int n, int n2) {
        return assetHistoryTable.getManyBy(new DbClause.LongClause("asset_id", l).and(deletesClause), n, n2, " ORDER BY asset_id, height DESC ");
    }

    public static DbIterator<AssetHistory> getAccountAssetDeletes(long l, int n, int n2) {
        return assetHistoryTable.getManyBy(new DbClause.LongClause("account_id", l).and(deletesClause), n, n2, " ORDER BY account_id, height DESC ");
    }

    public static DbIterator<AssetHistory> getAccountAssetDeletes(long l, long l2, int n, int n2) {
        return assetHistoryTable.getManyBy(new DbClause.LongClause("account_id", l).and(new DbClause.LongClause("asset_id", l2)).and(deletesClause), n, n2, " ORDER BY asset_id, height DESC ");
    }

    public static DbIterator<AssetHistory> getAssetIncreases(long l, int n, int n2) {
        return assetHistoryTable.getManyBy(new DbClause.LongClause("asset_id", l).and(increasesClause), n, n2, " ORDER BY asset_id, height DESC ");
    }

    public static DbIterator<AssetHistory> getAccountAssetIncreases(long l, int n, int n2) {
        return assetHistoryTable.getManyBy(new DbClause.LongClause("account_id", l).and(increasesClause), n, n2, " ORDER BY account_id, height DESC ");
    }

    public static DbIterator<AssetHistory> getAccountAssetIncreases(long l, long l2, int n, int n2) {
        return assetHistoryTable.getManyBy(new DbClause.LongClause("account_id", l).and(new DbClause.LongClause("asset_id", l2)).and(increasesClause), n, n2, " ORDER BY asset_id, height DESC ");
    }

    static AssetHistory addAssetDelete(Transaction transaction, long l, long l2) {
        AssetHistory assetHistory = new AssetHistory(transaction, l, -l2);
        assetHistoryTable.insert(assetHistory);
        listeners.notify(assetHistory, Event.ASSET_DELETE);
        return assetHistory;
    }

    static AssetHistory addAssetIncrease(Transaction transaction, long l, long l2) {
        AssetHistory assetHistory = new AssetHistory(transaction, l, l2);
        assetHistoryTable.insert(assetHistory);
        listeners.notify(assetHistory, Event.ASSET_INCREASE);
        return assetHistory;
    }

    static void init() {
    }

    private AssetHistory(Transaction transaction, long l, long l2) {
        this.id = transaction.getId();
        this.dbKey = assetHistoryDbKeyFactory.newKey(this.id);
        this.assetId = l;
        this.accountId = transaction.getSenderId();
        this.quantityQNT = l2;
        this.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
        this.height = Nxt.getBlockchain().getHeight();
    }

    private AssetHistory(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.id = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.assetId = resultSet.getLong("asset_id");
        this.accountId = resultSet.getLong("account_id");
        this.quantityQNT = resultSet.getLong("quantity");
        this.timestamp = resultSet.getInt("timestamp");
        this.height = resultSet.getInt("height");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO asset_history (id, asset_id, account_id, quantity, timestamp, height) VALUES (?, ?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.assetId);
            preparedStatement.setLong(++n, this.accountId);
            preparedStatement.setLong(++n, this.quantityQNT);
            preparedStatement.setInt(++n, this.timestamp);
            preparedStatement.setInt(++n, this.height);
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.id;
    }

    public long getAssetId() {
        return this.assetId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getQuantityQNT() {
        return this.quantityQNT;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getHeight() {
        return this.height;
    }

    public static enum Event {
        ASSET_DELETE,
        ASSET_INCREASE;

    }
}

