/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import nxt.Nxt;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;

public class CurrencyFounder {
    private static final DbKey.LinkKeyFactory<CurrencyFounder> currencyFounderDbKeyFactory = new DbKey.LinkKeyFactory<CurrencyFounder>("currency_id", "account_id"){

        @Override
        public DbKey newKey(CurrencyFounder currencyFounder) {
            return currencyFounder.dbKey;
        }
    };
    private static final VersionedEntityDbTable<CurrencyFounder> currencyFounderTable = new VersionedEntityDbTable<CurrencyFounder>("currency_founder", currencyFounderDbKeyFactory){

        @Override
        protected CurrencyFounder load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new CurrencyFounder(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, CurrencyFounder currencyFounder) throws SQLException {
            currencyFounder.save(connection);
        }

        @Override
        public String defaultSort() {
            return " ORDER BY height DESC ";
        }
    };
    private final DbKey dbKey;
    private final long currencyId;
    private final long accountId;
    private long amountPerUnitNQT;

    static void init() {
    }

    private CurrencyFounder(long l, long l2, long l3) {
        this.currencyId = l;
        this.dbKey = currencyFounderDbKeyFactory.newKey(l, l2);
        this.accountId = l2;
        this.amountPerUnitNQT = l3;
    }

    private CurrencyFounder(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.currencyId = resultSet.getLong("currency_id");
        this.accountId = resultSet.getLong("account_id");
        this.dbKey = dbKey;
        this.amountPerUnitNQT = resultSet.getLong("amount");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO currency_founder (currency_id, account_id, amount, height, latest) KEY (currency_id, account_id, height) VALUES (?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.getCurrencyId());
            preparedStatement.setLong(++n, this.getAccountId());
            preparedStatement.setLong(++n, this.getAmountPerUnitNQT());
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public long getCurrencyId() {
        return this.currencyId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getAmountPerUnitNQT() {
        return this.amountPerUnitNQT;
    }

    static void addOrUpdateFounder(long l, long l2, long l3) {
        CurrencyFounder currencyFounder = CurrencyFounder.getFounder(l, l2);
        if (currencyFounder == null) {
            currencyFounder = new CurrencyFounder(l, l2, l3);
        } else {
            currencyFounder.amountPerUnitNQT += l3;
        }
        currencyFounderTable.insert(currencyFounder);
    }

    public static CurrencyFounder getFounder(long l, long l2) {
        return (CurrencyFounder)currencyFounderTable.get(currencyFounderDbKeyFactory.newKey(l, l2));
    }

    public static DbIterator<CurrencyFounder> getCurrencyFounders(long l, int n, int n2) {
        return currencyFounderTable.getManyBy(new DbClause.LongClause("currency_id", l), n, n2);
    }

    public static DbIterator<CurrencyFounder> getFounderCurrencies(long l, int n, int n2) {
        return currencyFounderTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
    }

    static void remove(long l) {
        ArrayList<CurrencyFounder> arrayList = new ArrayList<CurrencyFounder>();
        try (DbIterator<CurrencyFounder> dbIterator = CurrencyFounder.getCurrencyFounders(l, 0, Integer.MAX_VALUE);){
            for (CurrencyFounder currencyFounder : dbIterator) {
                arrayList.add(currencyFounder);
            }
        }
        arrayList.forEach(currencyFounderTable::delete);
    }
}

